/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.panel.network.BSNetworkProfilePanel;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectEnumWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.hooks.TCommonHooks;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_3469;
import net.minecraft.class_4543;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;

public class BSStatPanel_General
extends BSStatPanel {
    public BSStatPanel_General(TPanelElement parentToFill) {
        super(parentToFill);
    }

    public BSStatPanel_General(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public TSelectWidget createFilterSortByWidget(BetterStatsScreen bss, int x, int y, int width, int height) {
        TSelectEnumWidget sw = new TSelectEnumWidget(x, y, width, height, BSStatPanelGeneral_SortBy.class);
        sw.setSelected((Enum)bss.cache.getAs("BSStatPanelGeneral_SortBy", BSStatPanelGeneral_SortBy.class, (Object)BSStatPanelGeneral_SortBy.Default), false);
        sw.setEnumValueToLabel(newVal -> ((BSStatPanelGeneral_SortBy)((Object)newVal)).asText());
        sw.setOnSelectionChange(newVal -> {
            bss.cache.set("BSStatPanelGeneral_SortBy", newVal);
            bss.getStatPanel().init_stats();
        });
        return sw;
    }

    @Override
    public void init(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        Objects.requireNonNull(this.getTextRenderer());
        int statHeight = 9 + 8;
        class_638 world = this.getClient().field_1687;
        BSNetworkProfilePanel netProfile = new BSNetworkProfilePanel(this.getScrollPadding(), this.getScrollPadding(), this.getTpeWidth() - this.getScrollPadding() * 2, bss.PLAYER_BADGES_ENABLED);
        this.addTChild((TElement)netProfile, true);
        netProfile.init(bss);
        if (BetterStatsClient.DEBUG_MODE && StringUtils.isBlank((CharSequence)bss.filter_searchTerm)) {
            this.init_groupLabel((class_2561)TextUtils.translatable((String)"selectWorld.world", (Object[])new Object[0]));
            new BSStatWidget_General((class_2561)TextUtils.translatable((String)"selectWorld.enterName", (Object[])new Object[0]), (class_2561)TextUtils.literal((String)world.method_27983().method_29177().toString()), statHeight);
            new BSStatWidget_General((class_2561)TextUtils.literal((String)"Seed (SHA256)"), (class_2561)TextUtils.literal((String)("" + TCommonHooks.getBiomeAccessSeed((class_4543)world.method_22385()))), statHeight);
            this.init_groupLabel((class_2561)TextUtils.translatable((String)"entity.minecraft.player", (Object[])new Object[0]));
        }
        ArrayList<StatUtils.StatUtilsGeneralStat> stats = StatUtils.getGeneralStats(statHandler, statFilter.and(this.getStatPredicate()));
        switch ((BSStatPanelGeneral_SortBy)((Object)bss.cache.getAs("BSStatPanelGeneral_SortBy", BSStatPanelGeneral_SortBy.class, (Object)BSStatPanelGeneral_SortBy.Default))) {
            case Reverse: {
                Collections.reverse(stats);
                break;
            }
            case Incremental: {
                Collections.sort(stats, (o1, o2) -> Integer.compare(o1.intValue, o2.intValue));
                break;
            }
            case Decremental: {
                Collections.sort(stats, (o1, o2) -> Integer.compare(o2.intValue, o1.intValue));
                break;
            }
        }
        for (StatUtils.StatUtilsGeneralStat stat : stats) {
            new BSStatWidget_General(stat, statHeight);
        }
        if (stats.size() == 0) {
            this.init_noResults();
        }
    }

    public int getChildBottomY() {
        if (this.getTChildren().size() == 0) {
            return this.getTpeY() + this.getScrollPadding();
        }
        return ((TElement)this.getTChildren().getTopmostElements().Item2).getTpeEndY() + 2;
    }

    public static enum BSStatPanelGeneral_SortBy {
        Default(TextUtils.literal((String)"A-Z")),
        Reverse(TextUtils.literal((String)"Z-A")),
        Incremental(TextUtils.literal((String)"0-9")),
        Decremental(TextUtils.literal((String)"9-0"));

        private final class_5250 text;

        private BSStatPanelGeneral_SortBy(class_5250 text) {
            this.text = text;
        }

        public class_5250 asText() {
            return this.text;
        }
    }

    protected class BSStatWidget_General
    extends BSStatPanel.BSStatWidget {
        protected StatUtils.StatUtilsGeneralStat stat;
        protected final class_2561 txt_left;
        protected final class_2561 txt_right;

        public BSStatWidget_General(class_2561 txt_left, class_2561 txt_right, int height) {
            super(BSStatPanel_General.this, BSStatPanel_General.this.getTpeX() + BSStatPanel_General.this.getScrollPadding(), BSStatPanel_General.this.getChildBottomY(), BSStatPanel_General.this.getTpeWidth() - BSStatPanel_General.this.getScrollPadding() * 2, height);
            BSStatPanel_General.this.addTChild(this, false);
            this.txt_left = txt_left;
            this.txt_right = txt_right;
            this.updateTooltip();
        }

        public BSStatWidget_General(StatUtils.StatUtilsGeneralStat stat, int height) {
            this(stat.label, (class_2561)stat.value, height);
            this.stat = stat;
            this.updateTooltip();
        }

        @Override
        public void updateTooltip() {
            if (BetterStatsClient.DEBUG_MODE && this.stat != null) {
                this.setTooltip((class_2561)TextUtils.fLiteral((String)("\u00a77" + Objects.toString(this.stat.stat.method_14951()))));
            } else {
                this.setTooltip(null);
            }
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
            super.render(matrices, mouseX, mouseY, deltaTime);
            this.drawTElementText(matrices, this.txt_left, HorizontalAlignment.LEFT, deltaTime);
            this.drawTElementText(matrices, this.txt_right, HorizontalAlignment.RIGHT, deltaTime);
        }
    }
}

