/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.networking.NetworkManager;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.client.gui_hud.screen.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.network.BStatsListener;
import io.github.thecsdev.betterstats.network.BSNetworkProfile;
import io.github.thecsdev.betterstats.network.BetterStatsNetworkHandler;
import io.github.thecsdev.tcdcommons.api.client.registry.TCDCommonsClientRegistry;
import io.github.thecsdev.tcdcommons.api.events.TNetworkEvent;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2617;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsClientNetworkHandler {
    public static boolean serverHasBSS;
    public static boolean enableBSSProtocol;
    private static final Cache<String, BSNetworkProfile> ProfileCache;

    protected BetterStatsClientNetworkHandler() {
    }

    public static void init() {
    }

    @Nullable
    public static BSNetworkProfile getCachedProfile(GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        String gpName = gameProfile.getName();
        String gpUUID = Objects.toString(gameProfile.getId());
        BSNetworkProfile profile = null;
        if (gpName != null) {
            profile = (BSNetworkProfile)ProfileCache.getIfPresent((Object)gpName);
        }
        if (profile == null && gpUUID != null) {
            profile = (BSNetworkProfile)ProfileCache.getIfPresent((Object)gpUUID);
        }
        return profile;
    }

    private static void initNetworkReceivers() {
        enableBSSProtocol = false;
        serverHasBSS = false;
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(cp -> {
            enableBSSProtocol = false;
            serverHasBSS = false;
            TCDCommonsClientRegistry.InGameHud_Screens.remove(BetterStatsHudScreen.HUD_ID);
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)BetterStatsNetworkHandler.S2C_I_HAVE_BSS, (payload, context) -> {
            serverHasBSS = true;
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)BetterStatsNetworkHandler.S2C_REQ_PREFS, (payload, context) -> BetterStatsClientNetworkHandler.c2s_sendPrefs());
        TNetworkEvent.RECEIVE_PACKET_POST.register((packet, side) -> {
            if (!(packet instanceof class_2617) || side != class_2598.field_11942) {
                return;
            }
            try {
                BetterStatsClientNetworkHandler.onReceivedBSNetworkProfile(BSNetworkProfile.ofLocalClient());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)BetterStatsNetworkHandler.S2C_STATS, (payload, context) -> BetterStatsClientNetworkHandler.onReceivedBSNetworkProfile(BSNetworkProfile.readPacket(payload)));
    }

    public static BSNetworkProfile handleCachingAndMerging(BSNetworkProfile of) {
        BSNetworkProfile existing = BetterStatsClientNetworkHandler.getCachedProfile(of.gameProfile);
        if (existing == null) {
            ProfileCache.put((Object)of.getProfileDisplayName(), (Object)of);
            existing = of;
        } else {
            existing.putAllStats(of);
        }
        return existing;
    }

    private static boolean onReceivedBSNetworkProfile(BSNetworkProfile receivedProfile) {
        if (receivedProfile == null) {
            return false;
        }
        BSNetworkProfile cachedProfile = BetterStatsClientNetworkHandler.handleCachingAndMerging(receivedProfile);
        class_310 client = class_310.method_1551();
        class_437 screen = client.field_1755;
        if (screen instanceof BStatsListener) {
            BStatsListener bsl = (BStatsListener)screen;
            if (Objects.equals(cachedProfile.gameProfile.getId(), new UUID(0L, 0L))) {
                client.method_40000(() -> bsl.onStatsPlayerNotFound());
            } else if (BSNetworkProfile.compareGameProfiles(bsl.getListenerTargetGameProfile(), cachedProfile.gameProfile)) {
                client.method_40000(() -> bsl.onBetterStatsReady(cachedProfile));
            }
        }
        return true;
    }

    public static boolean comms() {
        return enableBSSProtocol || class_310.method_1551().method_1542();
    }

    public static boolean c2s_sendPrefs() {
        if (!BetterStatsClientNetworkHandler.comms()) {
            return false;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeBoolean(enableBSSProtocol && BetterStatsHudScreen.getInstance() != null);
        class_2817 packet = new class_2817(BetterStatsNetworkHandler.C2S_PREFS, data);
        try {
            class_310.method_1551().method_1562().method_2883((class_2596)packet);
        }
        catch (Exception e) {
            BetterStats.LOGGER.debug("Failed to send '" + BetterStatsNetworkHandler.C2S_PREFS + "' packet; " + e.getMessage());
        }
        return true;
    }

    static {
        ProfileCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).build();
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(clientPlayer -> ProfileCache.invalidateAll());
        BetterStatsClientNetworkHandler.initNetworkReceivers();
    }
}

