/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy.impl;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergySnapshot;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;

public class SimpleEnergyContainer
implements EnergyContainer {
    private final long capacity;
    private final long maxInsert;
    private final long maxExtract;
    private long energy;

    public SimpleEnergyContainer(long maxCapacity) {
        this(maxCapacity, 1024L, 1024L);
    }

    public SimpleEnergyContainer(long maxCapacity, long maxTransfer) {
        this(maxCapacity, maxTransfer, maxTransfer);
    }

    public SimpleEnergyContainer(long maxCapacity, long maxExtract, long maxInsert) {
        this.capacity = maxCapacity;
        this.maxExtract = maxExtract;
        this.maxInsert = maxInsert;
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = class_3532.method_24156((long)maxAmount, (long)0L, (long)Math.min(this.maxInsert(), this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = class_3532.method_24156((long)maxAmount, (long)0L, (long)Math.min(this.maxExtract(), this.getStoredEnergy()));
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    @Override
    public long internalInsert(long maxAmount, boolean simulate) {
        long inserted = class_3532.method_24156((long)maxAmount, (long)0L, (long)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    @Override
    public long internalExtract(long maxAmount, boolean simulate) {
        long extracted = class_3532.method_24156((long)maxAmount, (long)0L, (long)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = energy;
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxCapacity() {
        return this.capacity;
    }

    @Override
    public long maxInsert() {
        return this.maxInsert;
    }

    @Override
    public long maxExtract() {
        return this.maxExtract;
    }

    @Override
    public class_2487 serialize(class_2487 root) {
        class_2487 tag = root.method_10562("BotariumData");
        tag.method_10544("Energy", this.energy);
        root.method_10566("BotariumData", (class_2520)tag);
        return root;
    }

    @Override
    public void deserialize(class_2487 root) {
        class_2487 tag = root.method_10562("BotariumData");
        this.energy = tag.method_10537("Energy");
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    public void method_5448() {
        this.energy = 0L;
    }
}

