/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.base;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.impl.ItemStackStorage;
import earth.terrarium.botarium.impl.fluid.storage.PlatformFluidContainer;
import earth.terrarium.botarium.impl.fluid.storage.PlatformFluidItemHandler;
import earth.terrarium.botarium.util.Serializable;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3829;
import org.jetbrains.annotations.Nullable;

public interface FluidContainer
extends Serializable,
class_3829 {
    @Nullable
    public static FluidContainer of(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        return PlatformFluidContainer.of(level, pos, state, entity, direction);
    }

    @Nullable
    public static FluidContainer of(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        return FluidContainer.of(level, pos, null, null, direction);
    }

    @Nullable
    public static FluidContainer of(class_2586 block, @Nullable class_2350 direction) {
        return FluidContainer.of(block.method_10997(), block.method_11016(), block.method_11010(), block, direction);
    }

    @Nullable
    public static ItemFluidContainer of(ItemStackHolder holder) {
        return PlatformFluidItemHandler.of(holder);
    }

    public static boolean holdsFluid(class_1799 stack) {
        return FluidStorage.ITEM.find(stack, (Object)ItemStackStorage.of(stack)) != null;
    }

    public static boolean holdsFluid(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        return FluidStorage.SIDED.find(level, pos, state, entity, (Object)direction) != null;
    }

    public static boolean holdsFluid(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        return FluidContainer.holdsFluid(level, pos, null, null, direction);
    }

    public static boolean holdsFluid(class_2586 block, @Nullable class_2350 direction) {
        return FluidContainer.holdsFluid(block.method_10997(), block.method_11016(), block.method_11010(), block, direction);
    }

    public long insertFluid(FluidHolder var1, boolean var2);

    default public long internalInsert(FluidHolder fluids, boolean simulate) {
        return this.insertFluid(fluids, simulate);
    }

    public FluidHolder extractFluid(FluidHolder var1, boolean var2);

    default public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        return this.extractFluid(fluid, simulate);
    }

    public void setFluid(int var1, FluidHolder var2);

    public List<FluidHolder> getFluids();

    public int getSize();

    public boolean isEmpty();

    public FluidContainer copy();

    public long getTankCapacity(int var1);

    public void fromContainer(FluidContainer var1);

    public long extractFromSlot(FluidHolder var1, FluidHolder var2, Runnable var3);

    default public long extractFromSlot(int slot, FluidHolder toExtract, boolean simulate) {
        return this.extractFromSlot(this.getFluids().get(slot), toExtract, () -> {});
    }

    public boolean allowsInsertion();

    public boolean allowsExtraction();

    default public boolean isFluidValid(int slot, FluidHolder fluidHolder) {
        return this.allowsInsertion();
    }

    public FluidSnapshot createSnapshot();

    default public void readSnapshot(FluidSnapshot snapshot) {
        snapshot.loadSnapshot(this);
    }

    default public FluidHolder getFirstFluid() {
        return this.getFluids().get(0);
    }
}

