/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.modeloverride;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2259;
import net.minecraft.class_2291;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import tschipp.carryon.common.scripting.Matchables;

public class ModelOverride {
    public static Codec<ModelOverride> CODEC = Codec.STRING.comapFlatMap(ModelOverride::of, override -> override.raw);
    private String raw;
    private class_2259.class_7211 parsedBlock;
    private Type type;
    private Either<class_2291.class_7215, class_2259.class_7211> parsedRHS;
    private Either<class_1799, class_2680> renderObject;

    private ModelOverride(String raw, class_2259.class_7211 parsedBlock, Type type, Either<class_2291.class_7215, class_2259.class_7211> parsedRHS) {
        this.raw = raw;
        this.parsedBlock = parsedBlock;
        this.type = type;
        this.parsedRHS = parsedRHS;
        parsedRHS.ifLeft(res -> {
            class_1799 stack = new class_1799(res.comp_628());
            if (res.comp_629() != null) {
                stack.method_7980(res.comp_629());
            }
            this.renderObject = Either.left((Object)stack);
        });
        parsedRHS.ifRight(res -> {
            class_2680 state = res.comp_622();
            this.renderObject = Either.right((Object)state);
        });
    }

    public static DataResult<ModelOverride> of(String str) {
        Either either;
        class_2259.class_7211 res;
        if (!str.contains("->")) {
            return DataResult.error((String)(str + " must contain -> Arrow!"));
        }
        String[] split = str.split("->");
        String from = split[0];
        String to = split[1];
        try {
            res = class_2259.method_41957((class_2378)class_2378.field_11146, (String)from, (boolean)true);
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)("Error while parsing " + from + ":" + e.getMessage()));
        }
        Type type = Type.ITEM;
        if (to.contains("(") && to.contains(")")) {
            String t = to.substring(to.indexOf("(") + 1, to.indexOf(")"));
            if (t.equals("block")) {
                type = Type.BLOCK;
            }
            to = to.substring(to.indexOf(")") + 1);
        }
        try {
            either = type == Type.ITEM ? Either.left((Object)class_2291.method_41972((class_7225)class_7225.method_42018((class_2378)class_2378.field_11142), (StringReader)new StringReader(to))) : Either.right((Object)class_2259.method_41957((class_2378)class_2378.field_11146, (String)to, (boolean)true));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)("Error while parsing " + to + ":" + e.getMessage()));
        }
        return DataResult.success((Object)new ModelOverride(str, res, type, (Either<class_2291.class_7215, class_2259.class_7211>)either));
    }

    public boolean matches(class_2680 state, @Nullable class_2487 tag) {
        if (state.method_26204() == this.parsedBlock.comp_622().method_26204() && this.matchesProperties(state, this.parsedBlock.comp_623())) {
            if (tag == null || this.parsedBlock.comp_624() == null) {
                return true;
            }
            Matchables.NBTCondition nbt = new Matchables.NBTCondition(this.parsedBlock.comp_624());
            return nbt.matches(tag);
        }
        return false;
    }

    public Either<class_1799, class_2680> getRenderObject() {
        return this.renderObject;
    }

    private boolean matchesProperties(class_2680 state, Map<class_2769<?>, Comparable<?>> props) {
        for (Map.Entry<class_2769<?>, Comparable<?>> entry : props.entrySet()) {
            Comparable val = state.method_11654(entry.getKey());
            if (val == entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        ITEM,
        BLOCK;

    }
}

