/*
 * Decompiled with CFR 0.152.
 */
package com.github.reoseah.catwalksinc.block;

import com.github.reoseah.catwalksinc.CIncBlocks;
import com.github.reoseah.catwalksinc.CatwalksInc;
import com.github.reoseah.catwalksinc.block.CatwalkAccess;
import com.github.reoseah.catwalksinc.block.MetalLadderBlock;
import com.github.reoseah.catwalksinc.block.PaintScrapableBlock;
import com.github.reoseah.catwalksinc.block.Paintable;
import com.github.reoseah.catwalksinc.block.WaterloggableBlock;
import com.github.reoseah.catwalksinc.block.Wrenchable;
import com.github.reoseah.catwalksinc.block.entity.CagedLadderBlockEntity;
import com.github.reoseah.catwalksinc.block.state.ElementMode;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CagedLadderBlock
extends WaterloggableBlock
implements class_2343,
CatwalkAccess,
Wrenchable,
Paintable {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 EXTENSION = class_2746.method_11825((String)"extension");
    public static final class_265[] OUTLINE_SHAPES = new class_265[4];
    public static final class_265[] EXTENSION_OUTLINE_SHAPES = new class_265[4];
    public static final class_265[] COLLISION_SHAPES;
    public static final class_265[] EXTENSION_COLLISION_SHAPES;

    public CagedLadderBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)EXTENSION, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, EXTENSION});
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int idx = ((class_2350)state.method_11654(FACING)).method_10161();
        return (Boolean)state.method_11654((class_2769)EXTENSION) != false ? EXTENSION_COLLISION_SHAPES[idx] : COLLISION_SHAPES[idx];
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int idx = ((class_2350)state.method_11654(FACING)).method_10161();
        return (Boolean)state.method_11654((class_2769)EXTENSION) != false ? EXTENSION_OUTLINE_SHAPES[idx] : OUTLINE_SHAPES[idx];
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)super.method_9605(ctx).method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
        return (class_2680)state.method_11657((class_2769)EXTENSION, (Comparable)Boolean.valueOf(this.shouldChangeToExtension(state, (class_1936)ctx.method_8045(), ctx.method_8037())));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        super.method_9559(state, direction, newState, world, posFrom, pos);
        return (class_2680)state.method_11657((class_2769)EXTENSION, (Comparable)Boolean.valueOf(this.shouldChangeToExtension(state, world, pos)));
    }

    public boolean shouldChangeToExtension(class_2680 state, class_1936 world, class_2338 pos) {
        CatwalkAccess catwalk;
        CagedLadderBlockEntity ladder;
        Optional<ElementMode> mode;
        class_2586 be = world.method_8321(pos);
        if (be instanceof CagedLadderBlockEntity && (mode = (ladder = (CagedLadderBlockEntity)be).getLadderState()).isPresent()) {
            return mode.get() == ElementMode.ALWAYS;
        }
        class_2350 supportDirection = ((class_2350)state.method_11654(FACING)).method_10153();
        class_2338 supportPos = pos.method_10093(supportDirection);
        class_2680 support = world.method_8320(supportPos);
        class_2248 class_22482 = support.method_26204();
        return class_22482 instanceof CatwalkAccess && (catwalk = (CatwalkAccess)class_22482).needsCatwalkConnectivity(support, (class_1922)world, supportPos, supportDirection.method_10153());
    }

    @Override
    public boolean useWrench(class_2680 state, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player, class_1268 hand, class_243 hitPos) {
        if (player != null && player.method_5715()) {
            world.method_8652(pos, (class_2680)state.method_28493(FACING), 3);
            return true;
        }
        CagedLadderBlockEntity be = (CagedLadderBlockEntity)world.method_8321(pos);
        if (be == null) {
            be = new CagedLadderBlockEntity(pos, state);
            world.method_8438((class_2586)be);
        }
        world.method_8501(pos, be.useWrench(state, player));
        if (be.canBeRemoved()) {
            world.method_8544(pos);
        }
        return true;
    }

    @Override
    public boolean canPaintBlock(class_1767 color, class_2680 state, class_1922 world, class_2338 pos) {
        class_2248 block = PaintedCagedLadderBlock.ofColor(color);
        return block != null;
    }

    @Override
    public void paintBlock(class_1767 color, class_2680 state, class_1936 world, class_2338 pos) {
        class_2248 block = PaintedCagedLadderBlock.ofColor(color);
        if (block != null) {
            world.method_8652(pos, (class_2680)((class_2680)((class_2680)block.method_9564().method_11657(FACING, (Comparable)((class_2350)state.method_11654(FACING)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)EXTENSION, (Comparable)((Boolean)state.method_11654((class_2769)EXTENSION))), 3);
        }
    }

    @Override
    public boolean needsCatwalkAccess(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
        return state.method_11654(FACING) == side.method_10153();
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!(newState.method_26204() instanceof CagedLadderBlock)) {
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return null;
    }

    static {
        class_265 south = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        class_265 west = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 north = class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 east = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        CagedLadderBlock.OUTLINE_SHAPES[0] = class_259.method_17786((class_265)MetalLadderBlock.OUTLINE_SHAPES[0], (class_265[])new class_265[]{west, north, east});
        CagedLadderBlock.OUTLINE_SHAPES[1] = class_259.method_17786((class_265)MetalLadderBlock.OUTLINE_SHAPES[1], (class_265[])new class_265[]{south, north, east});
        CagedLadderBlock.OUTLINE_SHAPES[2] = class_259.method_17786((class_265)MetalLadderBlock.OUTLINE_SHAPES[2], (class_265[])new class_265[]{south, west, east});
        CagedLadderBlock.OUTLINE_SHAPES[3] = class_259.method_17786((class_265)MetalLadderBlock.OUTLINE_SHAPES[3], (class_265[])new class_265[]{south, west, north});
        CagedLadderBlock.EXTENSION_OUTLINE_SHAPES[0] = class_259.method_17786((class_265)west, (class_265[])new class_265[]{north, east});
        CagedLadderBlock.EXTENSION_OUTLINE_SHAPES[1] = class_259.method_17786((class_265)south, (class_265[])new class_265[]{north, east});
        CagedLadderBlock.EXTENSION_OUTLINE_SHAPES[2] = class_259.method_17786((class_265)south, (class_265[])new class_265[]{west, east});
        CagedLadderBlock.EXTENSION_OUTLINE_SHAPES[3] = class_259.method_17786((class_265)south, (class_265[])new class_265[]{west, north});
        COLLISION_SHAPES = new class_265[4];
        EXTENSION_COLLISION_SHAPES = new class_265[4];
        south = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5);
        west = class_2248.method_9541((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        north = class_2248.method_9541((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0);
        east = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0);
        CagedLadderBlock.COLLISION_SHAPES[0] = class_259.method_17786((class_265)MetalLadderBlock.COLLISION_SHAPES[0], (class_265[])new class_265[]{west, north, east});
        CagedLadderBlock.COLLISION_SHAPES[1] = class_259.method_17786((class_265)MetalLadderBlock.COLLISION_SHAPES[1], (class_265[])new class_265[]{south, north, east});
        CagedLadderBlock.COLLISION_SHAPES[2] = class_259.method_17786((class_265)MetalLadderBlock.COLLISION_SHAPES[2], (class_265[])new class_265[]{south, west, east});
        CagedLadderBlock.COLLISION_SHAPES[3] = class_259.method_17786((class_265)MetalLadderBlock.COLLISION_SHAPES[3], (class_265[])new class_265[]{south, west, north});
        CagedLadderBlock.EXTENSION_COLLISION_SHAPES[0] = class_259.method_17786((class_265)west, (class_265[])new class_265[]{north, east});
        CagedLadderBlock.EXTENSION_COLLISION_SHAPES[1] = class_259.method_17786((class_265)south, (class_265[])new class_265[]{north, east});
        CagedLadderBlock.EXTENSION_COLLISION_SHAPES[2] = class_259.method_17786((class_265)south, (class_265[])new class_265[]{west, east});
        CagedLadderBlock.EXTENSION_COLLISION_SHAPES[3] = class_259.method_17786((class_265)south, (class_265[])new class_265[]{west, north});
    }

    public static class PaintedCagedLadderBlock
    extends CagedLadderBlock
    implements PaintScrapableBlock {
        protected static final Map<class_1767, class_2248> INSTANCES = new EnumMap<class_1767, class_2248>(class_1767.class);
        protected final class_1767 color;

        public PaintedCagedLadderBlock(class_1767 color, class_4970.class_2251 settings) {
            super(settings);
            this.color = color;
            INSTANCES.put(color, this);
        }

        public static class_2248 ofColor(class_1767 color) {
            return INSTANCES.get(color);
        }

        public String method_9539() {
            return class_156.method_646((String)"misc", (class_2960)CatwalksInc.id("painted_caged_ladder"));
        }

        public void method_9568(class_1799 stack, class_1922 world, List<class_2561> tooltip, class_1836 options) {
            super.method_9568(stack, world, tooltip, options);
            tooltip.add((class_2561)class_2561.method_43471((String)("misc.catwalksinc." + this.color.method_15434())).method_27692(class_124.field_1080));
        }

        @Override
        public boolean canPaintBlock(class_1767 color, class_2680 state, class_1922 world, class_2338 pos) {
            return false;
        }

        @Override
        public void scrapPaint(class_2680 state, class_1936 world, class_2338 pos) {
            world.method_8652(pos, (class_2680)((class_2680)CIncBlocks.CAGED_LADDER.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED))), 3);
        }
    }
}

