/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.client.util.DirectBuffers;
import java.nio.ByteBuffer;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL32C;

public class DirectVertexBuffer {
    private int vertexArrayObjectId = GL32C.glGenVertexArrays();
    private int vertexBufferId = DirectBuffers.createBuffer();
    private class_293.class_5596 mode;
    private class_293 format;
    private int vertexCount;
    private RenderSystem.class_5590 indexBuffer;
    private class_5944 currentShader;
    private boolean vaoInitialised;

    public void upload(int vertexCount, class_293.class_5596 mode, class_293 format, ByteBuffer buffer) {
        DirectBuffers.setBufferData(34962, this.vertexBufferId, buffer, 35044);
        this.format = format;
        this.mode = mode;
        this.vertexCount = vertexCount;
        this.indexBuffer = RenderSystem.getSequentialBuffer((class_293.class_5596)mode);
        this.vaoInitialised = false;
    }

    public void begin(class_1159 modelView, class_1159 projection, class_5944 shader) {
        class_286.method_34420();
        this.bindVertexArray();
        if (!this.vaoInitialised) {
            GL32C.glBindBuffer((int)34962, (int)this.vertexBufferId);
            this.format.method_22649();
            GL32C.glBindBuffer((int)34962, (int)0);
            this.indexBuffer.method_43410(this.mode.method_31973(this.vertexCount));
            this.vaoInitialised = true;
        }
        this.currentShader = shader;
        this.setupShader(shader, modelView, projection);
        shader.method_34586();
    }

    public void end() {
        this.currentShader.method_34585();
        this.currentShader = null;
        DirectVertexBuffer.unbindVertexArray();
    }

    public void draw(int vertexCount, int baseVertex) {
        if (vertexCount == 0 || this.currentShader == null) {
            return;
        }
        GL32C.glDrawElementsBaseVertex((int)this.mode.field_27383, (int)this.mode.method_31973(vertexCount), (int)this.indexBuffer.method_31924().field_27374, (long)0L, (int)baseVertex);
    }

    private void bindVertexArray() {
        GL32C.glBindVertexArray((int)this.vertexArrayObjectId);
    }

    private static void unbindVertexArray() {
        GL32C.glBindVertexArray((int)0);
    }

    public void close() {
        if (this.vertexBufferId > 0) {
            DirectBuffers.deleteBuffer(34962, this.vertexBufferId);
            this.vertexBufferId = 0;
        }
        if (this.vertexArrayObjectId > 0) {
            GL32C.glDeleteVertexArrays((int)this.vertexArrayObjectId);
            this.vertexArrayObjectId = 0;
        }
    }

    private void setupShader(class_5944 shader, class_1159 modelView, class_1159 projection) {
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            shader.method_34583("Sampler" + i, (Object)j);
        }
        if (shader.field_29470 != null) {
            shader.field_29470.method_1250(modelView);
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(projection);
        }
        if (shader.field_36323 != null) {
            shader.field_36323.method_39978(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shader.field_29474 != null) {
            shader.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shader.field_29477 != null) {
            shader.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shader.field_29478 != null) {
            shader.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shader.field_29479 != null) {
            shader.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shader.field_36373 != null) {
            shader.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (shader.field_29472 != null) {
            shader.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shader.field_29481 != null) {
            shader.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shader.field_29473 != null) {
            class_1041 window = class_310.method_1551().method_22683();
            shader.field_29473.method_35650(window.method_4489(), window.method_4506());
        }
        if (shader.field_29480 != null && (this.mode == class_293.class_5596.field_27377 || this.mode == class_293.class_5596.field_27378)) {
            shader.field_29480.method_1251(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((class_5944)shader);
    }
}

