/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.computer.ComputerExecutor;
import dan200.computercraft.core.computer.TimeoutState;
import dan200.computercraft.shared.util.ThreadUtils;
import java.util.TreeSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ComputerThread {
    private static final long MONITOR_WAKEUP = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long DEFAULT_LATENCY = TimeUnit.MILLISECONDS.toNanos(50L);
    private static final long DEFAULT_MIN_PERIOD = TimeUnit.MILLISECONDS.toNanos(5L);
    private static final long LATENCY_MAX_TASKS = DEFAULT_LATENCY / DEFAULT_MIN_PERIOD;
    private static final long REPORT_DEBOUNCE = TimeUnit.SECONDS.toNanos(1L);
    private static final Object threadLock = new Object();
    private static volatile boolean running = false;
    private static Thread monitor;
    private static TaskRunner[] runners;
    private static long latency;
    private static long minPeriod;
    private static final ReentrantLock computerLock;
    private static final Condition hasWork;
    private static final AtomicInteger idleWorkers;
    private static final Condition monitorWakeup;
    private static final TreeSet<ComputerExecutor> computerQueue;
    private static long minimumVirtualRuntime;
    private static final ThreadFactory monitorFactory;
    private static final ThreadFactory runnerFactory;

    private ComputerThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void start() {
        Object object = threadLock;
        synchronized (object) {
            running = true;
            if (runners == null) {
                runners = new TaskRunner[ComputerCraft.computerThreads];
                long factor = 64 - Long.numberOfLeadingZeros(runners.length);
                latency = DEFAULT_LATENCY * factor;
                minPeriod = DEFAULT_MIN_PERIOD * factor;
            }
            for (int i = 0; i < runners.length; ++i) {
                TaskRunner runner = runners[i];
                if (runner != null && runner.owner != null && runner.owner.isAlive()) continue;
                if (runner != null) {
                    runner.running = false;
                }
                ComputerThread.runners[i] = new TaskRunner();
                runnerFactory.newThread(ComputerThread.runners[i]).start();
            }
            if (monitor == null || !monitor.isAlive()) {
                monitor = monitorFactory.newThread(new Monitor());
                monitor.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = threadLock;
        synchronized (object) {
            running = false;
            if (runners != null) {
                for (TaskRunner runner : runners) {
                    if (runner == null) continue;
                    runner.running = false;
                    if (runner.owner == null) continue;
                    runner.owner.interrupt();
                }
            }
        }
        computerLock.lock();
        try {
            computerQueue.clear();
        }
        finally {
            computerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void queue(@Nonnull ComputerExecutor executor) {
        computerLock.lock();
        try {
            if (executor.onComputerQueue) {
                throw new IllegalStateException("Cannot queue already queued executor");
            }
            executor.onComputerQueue = true;
            ComputerThread.updateRuntimes(null);
            long newRuntime = minimumVirtualRuntime;
            newRuntime = executor.virtualRuntime == 0L ? (newRuntime += ComputerThread.scaledPeriod()) : (newRuntime -= latency / 2L);
            executor.virtualRuntime = Math.max(newRuntime, executor.virtualRuntime);
            boolean wasBusy = ComputerThread.isBusy();
            computerQueue.add(executor);
            hasWork.signal();
            if (!wasBusy && ComputerThread.isBusy()) {
                monitorWakeup.signal();
            }
        }
        finally {
            computerLock.unlock();
        }
    }

    private static void updateRuntimes(@Nullable ComputerExecutor current) {
        long minRuntime = Long.MAX_VALUE;
        if (!computerQueue.isEmpty()) {
            minRuntime = ComputerThread.computerQueue.first().virtualRuntime;
        }
        long now = System.nanoTime();
        int tasks = 1 + computerQueue.size();
        TaskRunner[] currentRunners = runners;
        if (currentRunners != null) {
            for (TaskRunner runner : currentRunners) {
                ComputerExecutor executor;
                if (runner == null || (executor = runner.currentExecutor.get()) == null) continue;
                minRuntime = Math.min(minRuntime, executor.virtualRuntime += (now - executor.vRuntimeStart) / (long)tasks);
                executor.vRuntimeStart = now;
            }
        }
        if (current != null) {
            minRuntime = Math.min(minRuntime, current.virtualRuntime += (now - current.vRuntimeStart) / (long)tasks);
        }
        if (minRuntime > minimumVirtualRuntime && minRuntime < Long.MAX_VALUE) {
            minimumVirtualRuntime = minRuntime;
        }
    }

    private static void afterWork(TaskRunner runner, ComputerExecutor executor) {
        Thread currentThread = executor.executingThread.getAndSet(null);
        if (currentThread != runner.owner) {
            ComputerCraft.log.error("Expected computer #{} to be running on {}, but already running on {}. This is a SERIOUS bug, please report with your debug.log.", (Object)executor.getComputer().getID(), (Object)runner.owner.getName(), (Object)(currentThread == null ? "nothing" : currentThread.getName()));
        }
        computerLock.lock();
        try {
            ComputerThread.updateRuntimes(executor);
            if (!executor.afterWork()) {
                return;
            }
            computerQueue.add(executor);
            hasWork.signal();
        }
        finally {
            computerLock.unlock();
        }
    }

    static long scaledPeriod() {
        int count = 1 + computerQueue.size();
        return (long)count < LATENCY_MAX_TASKS ? latency / (long)count : minPeriod;
    }

    static boolean hasPendingWork() {
        return !computerQueue.isEmpty();
    }

    private static boolean isBusy() {
        return computerQueue.size() > idleWorkers.get();
    }

    static {
        computerLock = new ReentrantLock();
        hasWork = computerLock.newCondition();
        idleWorkers = new AtomicInteger(0);
        monitorWakeup = computerLock.newCondition();
        computerQueue = new TreeSet((a, b) -> {
            if (a == b) {
                return 0;
            }
            long at = a.virtualRuntime;
            long bt = b.virtualRuntime;
            if (at == bt) {
                return Integer.compare(a.hashCode(), b.hashCode());
            }
            return at < bt ? -1 : 1;
        });
        minimumVirtualRuntime = 0L;
        monitorFactory = ThreadUtils.factory("Computer-Monitor");
        runnerFactory = ThreadUtils.factory("Computer-Runner");
    }

    private static final class TaskRunner
    implements Runnable {
        Thread owner;
        long lastReport = Long.MIN_VALUE;
        volatile boolean running = true;
        final AtomicReference<ComputerExecutor> currentExecutor = new AtomicReference();

        private TaskRunner() {
        }

        @Override
        public void run() {
            this.owner = Thread.currentThread();
            block10: while (this.running && running) {
                ComputerExecutor executor;
                try {
                    computerLock.lockInterruptibly();
                    try {
                        idleWorkers.incrementAndGet();
                        while (computerQueue.isEmpty()) {
                            hasWork.await();
                        }
                        executor = computerQueue.pollFirst();
                        assert (executor != null) : "hasWork should ensure we never receive null work";
                    }
                    finally {
                        computerLock.unlock();
                        idleWorkers.decrementAndGet();
                    }
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                while (!executor.executingThread.compareAndSet(null, this.owner)) {
                    Thread existing = executor.executingThread.get();
                    if (existing == null) continue;
                    ComputerCraft.log.error("Trying to run computer #{} on thread {}, but already running on {}. This is a SERIOUS bug, please report with your debug.log.", (Object)executor.getComputer().getID(), (Object)this.owner.getName(), (Object)existing.getName());
                    continue block10;
                }
                executor.beforeWork();
                this.currentExecutor.set(executor);
                try {
                    executor.work();
                }
                catch (Exception | LinkageError | VirtualMachineError e) {
                    ComputerCraft.log.error("Error running task on computer #" + executor.getComputer().getID(), e);
                    executor.fastFail();
                }
                finally {
                    ComputerExecutor thisExecutor = this.currentExecutor.getAndSet(null);
                    if (thisExecutor == null) continue;
                    ComputerThread.afterWork(this, executor);
                }
            }
        }

        private void reportTimeout(ComputerExecutor executor, long time) {
            if (!ComputerCraft.logComputerErrors) {
                return;
            }
            long now = System.nanoTime();
            if (this.lastReport != Long.MIN_VALUE && now - this.lastReport - REPORT_DEBOUNCE <= 0L) {
                return;
            }
            this.lastReport = now;
            StringBuilder builder = new StringBuilder().append("Terminating computer #").append(executor.getComputer().getID()).append(" due to timeout (running for ").append((double)time * 1.0E-9).append(" seconds). This is NOT a bug, but may mean a computer is misbehaving. ").append(this.owner.getName()).append(" is currently ").append((Object)this.owner.getState());
            Object blocking = LockSupport.getBlocker(this.owner);
            if (blocking != null) {
                builder.append("\n  on ").append(blocking);
            }
            for (StackTraceElement element : this.owner.getStackTrace()) {
                builder.append("\n  at ").append(element);
            }
            ComputerCraft.log.warn(builder.toString());
        }
    }

    private static final class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            while (true) {
                computerLock.lock();
                try {
                    monitorWakeup.awaitNanos(ComputerThread.isBusy() ? ComputerThread.scaledPeriod() : MONITOR_WAKEUP);
                }
                catch (InterruptedException e) {
                    ComputerCraft.log.error("Monitor thread interrupted. Computers may behave very badly!", (Throwable)e);
                    break;
                }
                finally {
                    computerLock.unlock();
                }
                Monitor.checkRunners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void checkRunners() {
            TaskRunner[] currentRunners = runners;
            if (currentRunners == null) {
                return;
            }
            for (int i = 0; i < currentRunners.length; ++i) {
                ComputerExecutor executor;
                TaskRunner runner = currentRunners[i];
                if (runner == null || runner.owner == null || !runner.owner.isAlive()) {
                    if (!running) continue;
                    ComputerCraft.log.warn("Previous runner ({}) has crashed, restarting!", runner != null && runner.owner != null ? runner.owner.getName() : runner);
                    if (runner != null) {
                        runner.running = false;
                    }
                    ComputerThread.runners[i] = new TaskRunner();
                    runnerFactory.newThread(ComputerThread.runners[i]).start();
                }
                if ((executor = runner.currentExecutor.get()) == null) continue;
                executor.timeout.refresh();
                long afterStart = executor.timeout.nanoCumulative();
                long afterHardAbort = afterStart - TimeoutState.TIMEOUT - TimeoutState.ABORT_TIMEOUT;
                if (afterHardAbort < 0L) continue;
                executor.timeout.hardAbort();
                executor.abort();
                if (afterHardAbort >= TimeoutState.ABORT_TIMEOUT * 2L) {
                    runner.reportTimeout(executor, afterStart);
                    runner.running = false;
                    runner.owner.interrupt();
                    ComputerExecutor thisExecutor = runner.currentExecutor.getAndSet(null);
                    if (thisExecutor != null) {
                        ComputerThread.afterWork(runner, executor);
                    }
                    Object object = threadLock;
                    synchronized (object) {
                        if (running && runners.length > i && runners[i] == runner) {
                            currentRunners[i] = new TaskRunner();
                            runnerFactory.newThread(currentRunners[i]).start();
                        }
                        continue;
                    }
                }
                if (afterHardAbort < TimeoutState.ABORT_TIMEOUT) continue;
                runner.reportTimeout(executor, afterStart);
                runner.owner.interrupt();
            }
        }
    }
}

