/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public final class BundledRedstone {
    private static final ArrayList<IBundledRedstoneProvider> providers = new ArrayList();

    private BundledRedstone() {
    }

    public static synchronized void register(@Nonnull IBundledRedstoneProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        if (!providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public static int getDefaultOutput(@Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2350 side) {
        return world.method_24794(pos) ? DefaultBundledRedstoneProvider.getDefaultBundledRedstoneOutput(world, pos, side) : -1;
    }

    private static int getUnmaskedOutput(class_1937 world, class_2338 pos, class_2350 side) {
        if (!world.method_24794(pos)) {
            return -1;
        }
        int combinedSignal = -1;
        for (IBundledRedstoneProvider bundledRedstoneProvider : providers) {
            try {
                int signal = bundledRedstoneProvider.getBundledRedstoneOutput(world, pos, side);
                if (signal < 0) continue;
                combinedSignal = combinedSignal < 0 ? signal & 0xFFFF : combinedSignal | signal & 0xFFFF;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Bundled redstone provider " + bundledRedstoneProvider + " errored.", (Throwable)e);
            }
        }
        return combinedSignal;
    }

    public static int getOutput(class_1937 world, class_2338 pos, class_2350 side) {
        int signal = BundledRedstone.getUnmaskedOutput(world, pos, side);
        return signal >= 0 ? signal : 0;
    }
}

