/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.tracking.ComputerTracker;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.core.tracking.TrackingContext;
import dan200.computercraft.core.tracking.TrackingField;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.ComputersArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.command.builder.CommandBuilder;
import dan200.computercraft.shared.command.builder.HelpingArgumentBuilder;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import dan200.computercraft.shared.network.container.ViewComputerContainerData;
import dan200.computercraft.shared.util.IDAssigner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2708;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public final class CommandComputerCraft {
    public static final UUID SYSTEM_UUID = new UUID(0L, 0L);
    private static final int DUMP_LIST_ID = 0x520000;
    private static final int DUMP_SINGLE_ID = 1844510720;
    private static final int TRACK_ID = 373882880;
    private static final List<TrackingField> DEFAULT_FIELDS = Arrays.asList(TrackingField.TASKS, TrackingField.TOTAL_TIME, TrackingField.AVERAGE_TIME, TrackingField.MAX_TIME);

    private CommandComputerCraft() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("computercraft").then((ArgumentBuilder<class_2168, ?>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").requires((Predicate)UserLevel.OWNER_OP)).executes(context -> {
            TableBuilder table = new TableBuilder(0x520000, "Computer", "On", "Position");
            class_2168 source = (class_2168)context.getSource();
            ArrayList computers = new ArrayList(ComputerCraft.serverComputerRegistry.getComputers());
            class_3218 world = source.method_9225();
            class_2338 pos = new class_2338(source.method_9222());
            computers.sort((arg_0, arg_1) -> CommandComputerCraft.lambda$register$0((class_1937)world, pos, arg_0, arg_1));
            for (ServerComputer computer : computers) {
                table.row(new class_2561[]{CommandComputerCraft.linkComputer(source, computer, computer.getID()), ChatHelpers.bool(computer.isOn()), CommandComputerCraft.linkPosition(source, computer)});
            }
            table.display((class_2168)context.getSource());
            return computers.size();
        })).then(CommandBuilder.args().arg("computer", ComputerArgumentType.oneComputer()).executes((Command<class_2168>)((Command)context -> {
            ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<class_2168>)context, "computer");
            TableBuilder table = new TableBuilder(1844510720);
            table.row(new class_2561[]{ChatHelpers.header("Instance"), ChatHelpers.text(Integer.toString(computer.getInstanceID()))});
            table.row(new class_2561[]{ChatHelpers.header("Id"), ChatHelpers.text(Integer.toString(computer.getID()))});
            table.row(new class_2561[]{ChatHelpers.header("Label"), ChatHelpers.text(computer.getLabel())});
            table.row(new class_2561[]{ChatHelpers.header("On"), ChatHelpers.bool(computer.isOn())});
            table.row(new class_2561[]{ChatHelpers.header("Position"), CommandComputerCraft.linkPosition((class_2168)context.getSource(), computer)});
            table.row(new class_2561[]{ChatHelpers.header("Family"), ChatHelpers.text(computer.getFamily().toString())});
            for (ComputerSide side : ComputerSide.values()) {
                IPeripheral peripheral = computer.getPeripheral(side);
                if (peripheral == null) continue;
                table.row(new class_2561[]{ChatHelpers.header("Peripheral " + side.getName()), ChatHelpers.text(peripheral.getType())});
            }
            table.display((class_2168)context.getSource());
            return 1;
        })))).then(CommandBuilder.command("shutdown").requires(UserLevel.OWNER_OP).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ComputerCraft.serverComputerRegistry.getComputers()).executes((context, computerSelectors) -> {
            int shutdown = 0;
            Set<ServerComputer> computers = ComputersArgumentType.unwrap((class_2168)context.getSource(), computerSelectors);
            for (ServerComputer computer : computers) {
                if (computer.isOn()) {
                    ++shutdown;
                }
                computer.shutdown();
            }
            ((class_2168)context.getSource()).method_9226((class_2561)ChatHelpers.translate("commands.computercraft.shutdown.done", shutdown, computers.size()), false);
            return shutdown;
        }))).then(CommandBuilder.command("turn-on").requires(UserLevel.OWNER_OP).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ComputerCraft.serverComputerRegistry.getComputers()).executes((context, computerSelectors) -> {
            int on = 0;
            Set<ServerComputer> computers = ComputersArgumentType.unwrap((class_2168)context.getSource(), computerSelectors);
            for (ServerComputer computer : computers) {
                if (!computer.isOn()) {
                    ++on;
                }
                computer.turnOn();
            }
            ((class_2168)context.getSource()).method_9226((class_2561)ChatHelpers.translate("commands.computercraft.turn_on.done", on, computers.size()), false);
            return on;
        }))).then(CommandBuilder.command("tp").requires(UserLevel.OP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<class_2168>)((Command)context -> {
            ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<class_2168>)context, "computer");
            class_1937 world = computer.getLevel();
            class_2338 pos = computer.getPosition();
            if (world == null || pos == null) {
                throw Exceptions.TP_NOT_THERE.create();
            }
            class_1297 entity = ((class_2168)context.getSource()).method_9229();
            if (!(entity instanceof class_3222)) {
                throw Exceptions.TP_NOT_PLAYER.create();
            }
            class_3222 player = (class_3222)entity;
            if (player.method_5770() == world) {
                player.field_13987.method_14360((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f, EnumSet.noneOf(class_2708.class_2709.class));
            } else {
                player.method_14251((class_3218)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            }
            return 1;
        })))).then(CommandBuilder.command("queue").requires(UserLevel.ANYONE).arg("computer", ComputersArgumentType.manyComputers()).argManyValue("args", StringArgumentType.string(), Collections.emptyList()).executes((ctx, args) -> {
            Collection<ServerComputer> computers = ComputersArgumentType.getComputersArgument((CommandContext<class_2168>)ctx, "computer");
            Object[] rest = args.toArray();
            int queued = 0;
            for (ServerComputer computer : computers) {
                if (computer.getFamily() != ComputerFamily.COMMAND || !computer.isOn()) continue;
                computer.queueEvent("computer_command", rest);
                ++queued;
            }
            return queued;
        }))).then(CommandBuilder.command("view").requires(UserLevel.OP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<class_2168>)((Command)context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            final ServerComputer computer = ComputerArgumentType.getComputerArgument((CommandContext<class_2168>)context, "computer");
            computer.sendTerminalState((class_1657)player);
            final ViewComputerContainerData container = new ViewComputerContainerData(computer);
            container.open((class_1657)player, (class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    container.toBytes(buf);
                }

                @Nonnull
                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"gui.computercraft.view_computer");
                }

                @Nonnull
                public class_1703 createMenu(int id, @Nonnull class_1661 player, @Nonnull class_1657 entity) {
                    return new ContainerViewComputer(id, player, computer);
                }
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("track").then(CommandBuilder.command("start").requires(UserLevel.OWNER_OP).executes((Command<class_2168>)((Command)context -> {
            CommandComputerCraft.getTimingContext((class_2168)context.getSource()).start();
            String stopCommand = "/computercraft track stop";
            ((class_2168)context.getSource()).method_9226((class_2561)ChatHelpers.translate("commands.computercraft.track.start.stop", ChatHelpers.link(ChatHelpers.text(stopCommand), stopCommand, (class_2561)ChatHelpers.translate("commands.computercraft.track.stop.action"))), false);
            return 1;
        }))).then(CommandBuilder.command("stop").requires(UserLevel.OWNER_OP).executes((Command<class_2168>)((Command)context -> {
            TrackingContext timings = CommandComputerCraft.getTimingContext((class_2168)context.getSource());
            if (!timings.stop()) {
                throw Exceptions.NOT_TRACKING_EXCEPTION.create();
            }
            CommandComputerCraft.displayTimings((class_2168)context.getSource(), timings.getImmutableTimings(), TrackingField.AVERAGE_TIME, DEFAULT_FIELDS);
            return 1;
        })))).then(CommandBuilder.command("dump").requires(UserLevel.OWNER_OP).argManyValue("fields", TrackingFieldArgumentType.trackingField(), DEFAULT_FIELDS).executes((context, fields) -> {
            TrackingField sort;
            if (fields.size() == 1 && DEFAULT_FIELDS.contains(fields.get(0))) {
                sort = (TrackingField)fields.get(0);
                fields = DEFAULT_FIELDS;
            } else {
                sort = (TrackingField)fields.get(0);
            }
            return CommandComputerCraft.displayTimings((class_2168)context.getSource(), sort, fields);
        }))));
    }

    private static class_2561 linkComputer(class_2168 source, ServerComputer serverComputer, int computerId) {
        class_2561 linkPath;
        class_5250 out = class_2561.method_43470((String)"");
        if (serverComputer == null) {
            out.method_10852((class_2561)ChatHelpers.text("?"));
        } else {
            out.method_10852(ChatHelpers.link(ChatHelpers.text(Integer.toString(serverComputer.getInstanceID())), "/computercraft dump " + serverComputer.getInstanceID(), (class_2561)ChatHelpers.translate("commands.computercraft.dump.action")));
        }
        out.method_27693(" (id " + computerId + ")");
        if (serverComputer != null && UserLevel.OP.test(source) && CommandUtils.isPlayer(source)) {
            out.method_27693(" ").method_10852(ChatHelpers.link(ChatHelpers.text("\u261b"), "/computercraft tp " + serverComputer.getInstanceID(), (class_2561)ChatHelpers.translate("commands.computercraft.tp.action"))).method_27693(" ").method_10852(ChatHelpers.link(ChatHelpers.text("\u20e2"), "/computercraft view " + serverComputer.getInstanceID(), (class_2561)ChatHelpers.translate("commands.computercraft.view.action")));
        }
        if (UserLevel.OWNER.test(source) && CommandUtils.isPlayer(source) && (linkPath = CommandComputerCraft.linkStorage(computerId)) != null) {
            out.method_27693(" ").method_10852(linkPath);
        }
        return out;
    }

    private static class_2561 linkPosition(class_2168 context, ServerComputer computer) {
        if (UserLevel.OP.test(context)) {
            return ChatHelpers.link(ChatHelpers.position(computer.getPosition()), "/computercraft tp " + computer.getInstanceID(), (class_2561)ChatHelpers.translate("commands.computercraft.tp.action"));
        }
        return ChatHelpers.position(computer.getPosition());
    }

    private static class_2561 linkStorage(int id) {
        File file = new File(IDAssigner.getDir(), "computer/" + id);
        if (!file.isDirectory()) {
            return null;
        }
        return ChatHelpers.link(ChatHelpers.text("\u270e"), "/computercraft open-computer " + id, (class_2561)ChatHelpers.translate("commands.computercraft.dump.open_path"));
    }

    @Nonnull
    private static TrackingContext getTimingContext(class_2168 source) {
        class_1297 entity = source.method_9228();
        return entity instanceof class_1657 ? Tracking.getContext(entity.method_5667()) : Tracking.getContext(SYSTEM_UUID);
    }

    private static int displayTimings(class_2168 source, TrackingField sortField, List<TrackingField> fields) throws CommandSyntaxException {
        return CommandComputerCraft.displayTimings(source, CommandComputerCraft.getTimingContext(source).getTimings(), sortField, fields);
    }

    private static int displayTimings(class_2168 source, @Nonnull List<ComputerTracker> timings, @Nonnull TrackingField sortField, @Nonnull List<TrackingField> fields) throws CommandSyntaxException {
        if (timings.isEmpty()) {
            throw Exceptions.NO_TIMINGS_EXCEPTION.create();
        }
        HashMap<Computer, ServerComputer> lookup = new HashMap<Computer, ServerComputer>();
        int maxId = 0;
        int maxInstance = 0;
        for (ServerComputer server : ComputerCraft.serverComputerRegistry.getComputers()) {
            lookup.put(server.getComputer(), server);
            if (server.getInstanceID() > maxInstance) {
                maxInstance = server.getInstanceID();
            }
            if (server.getID() <= maxId) continue;
            maxId = server.getID();
        }
        timings.sort(Comparator.comparing(x -> x.get(sortField)).reversed());
        class_2561[] headers = new class_2561[1 + fields.size()];
        headers[0] = ChatHelpers.translate("commands.computercraft.track.dump.computer");
        for (int i = 0; i < fields.size(); ++i) {
            headers[i + 1] = ChatHelpers.translate(fields.get(i).translationKey());
        }
        TableBuilder table = new TableBuilder(373882880, headers);
        for (ComputerTracker entry : timings) {
            Computer computer = entry.getComputer();
            ServerComputer serverComputer = computer == null ? null : (ServerComputer)lookup.get(computer);
            class_2561 computerComponent = CommandComputerCraft.linkComputer(source, serverComputer, entry.getComputerId());
            class_2561[] row = new class_2561[1 + fields.size()];
            row[0] = computerComponent;
            for (int i = 0; i < fields.size(); ++i) {
                row[i + 1] = ChatHelpers.text(entry.getFormatted(fields.get(i)));
            }
            table.row(row);
        }
        table.display(source);
        return timings.size();
    }

    private static /* synthetic */ int lambda$register$0(class_1937 world, class_2338 pos, ServerComputer a, ServerComputer b) {
        if (a.getLevel() == b.getLevel() && a.getLevel() == world) {
            return Double.compare(a.getPosition().method_10262((class_2382)pos), b.getPosition().method_10262((class_2382)pos));
        }
        if (a.getLevel() == world) {
            return -1;
        }
        if (b.getLevel() == world) {
            return 1;
        }
        return Integer.compare(a.getInstanceID(), b.getInstanceID());
    }
}

