/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public interface TableFormatter {
    public static final class_2561 SEPARATOR = ChatHelpers.coloured("| ", class_124.field_1080);
    public static final class_2561 HEADER = ChatHelpers.coloured("=", class_124.field_1080);

    @Nullable
    public class_2561 getPadding(class_2561 var1, int var2);

    public int getColumnPadding();

    public int getWidth(class_2561 var1);

    public void writeLine(int var1, class_2561 var2);

    default public int display(TableBuilder table) {
        int width;
        int i;
        if (table.getColumns() <= 0) {
            return 0;
        }
        int rowId = table.getId();
        int columns = table.getColumns();
        int[] maxWidths = new int[columns];
        class_2561[] headers = table.getHeaders();
        if (headers != null) {
            for (int i2 = 0; i2 < columns; ++i2) {
                maxWidths[i2] = this.getWidth(headers[i2]);
            }
        }
        for (class_2561[] row : table.getRows()) {
            for (i = 0; i < row.length; ++i) {
                width = this.getWidth(row[i]);
                if (width <= maxWidths[i]) continue;
                maxWidths[i] = width;
            }
        }
        int padding = this.getColumnPadding();
        int i22 = 0;
        while (i22 < maxWidths.length - 1) {
            int n = i22++;
            maxWidths[n] = maxWidths[n] + padding;
        }
        int totalWidth = (columns - 1) * this.getWidth(SEPARATOR);
        int[] i22 = maxWidths;
        i = i22.length;
        for (width = 0; width < i; ++width) {
            int x = i22[width];
            totalWidth += x;
        }
        if (headers != null) {
            class_5250 line = class_2561.method_43473();
            for (i = 0; i < columns - 1; ++i) {
                line.method_10852(headers[i]);
                class_2561 padding2 = this.getPadding(headers[i], maxWidths[i]);
                if (padding2 != null) {
                    line.method_10852(padding2);
                }
                line.method_10852(SEPARATOR);
            }
            line.method_10852(headers[columns - 1]);
            this.writeLine(rowId++, (class_2561)line);
            int rowCharWidth = this.getWidth(HEADER);
            int rowWidth = totalWidth / rowCharWidth + (totalWidth % rowCharWidth == 0 ? 0 : 1);
            this.writeLine(rowId++, (class_2561)ChatHelpers.coloured(StringUtils.repeat((String)HEADER.getString(), (int)rowWidth), class_124.field_1080));
        }
        for (class_2561[] row : table.getRows()) {
            class_5250 line = class_2561.method_43470((String)"");
            for (int i3 = 0; i3 < columns - 1; ++i3) {
                line.method_10852(row[i3]);
                class_2561 padding3 = this.getPadding(row[i3], maxWidths[i3]);
                if (padding3 != null) {
                    line.method_10852(padding3);
                }
                line.method_10852(SEPARATOR);
            }
            line.method_10852(row[columns - 1]);
            this.writeLine(rowId++, (class_2561)line);
        }
        if (table.getAdditional() > 0) {
            this.writeLine(rowId++, (class_2561)ChatHelpers.coloured(ChatHelpers.translate("commands.computercraft.generic.additional_rows", table.getAdditional()), class_124.field_1075));
        }
        return rowId - table.getId();
    }
}

