/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import net.minecraft.class_2487;

public class ClientComputer
extends ClientTerminal
implements IComputer {
    private final int instanceID;
    private boolean on = false;
    private boolean blinking = false;
    private class_2487 userData = null;

    public ClientComputer(int instanceID) {
        super(false);
        this.instanceID = instanceID;
    }

    public class_2487 getUserData() {
        return this.userData;
    }

    public void requestState() {
        NetworkHandler.sendToServer(new RequestComputerMessage(this.getInstanceID()));
    }

    @Override
    public int getInstanceID() {
        return this.instanceID;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isCursorDisplayed() {
        return this.on && this.blinking;
    }

    @Override
    public void turnOn() {
        NetworkHandler.sendToServer(new ComputerActionServerMessage(this.instanceID, ComputerActionServerMessage.Action.TURN_ON));
    }

    @Override
    public void shutdown() {
        NetworkHandler.sendToServer(new ComputerActionServerMessage(this.instanceID, ComputerActionServerMessage.Action.SHUTDOWN));
    }

    @Override
    public void reboot() {
        NetworkHandler.sendToServer(new ComputerActionServerMessage(this.instanceID, ComputerActionServerMessage.Action.REBOOT));
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        NetworkHandler.sendToServer(new QueueEventServerMessage(this.instanceID, event, arguments));
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        NetworkHandler.sendToServer(new KeyEventServerMessage(this.instanceID, repeat ? 1 : 0, key));
    }

    @Override
    public void keyUp(int key) {
        NetworkHandler.sendToServer(new KeyEventServerMessage(this.instanceID, 2, key));
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.instanceID, 0, button, x, y));
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.instanceID, 2, button, x, y));
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.instanceID, 1, button, x, y));
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        NetworkHandler.sendToServer(new MouseEventServerMessage(this.instanceID, 3, direction, x, y));
    }

    public void setState(ComputerState state, class_2487 userData) {
        this.on = state != ComputerState.OFF;
        this.blinking = state == ComputerState.BLINKING;
        this.userData = userData;
    }
}

