/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.computer.core.ComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Iterator;

public class ServerComputerRegistry
extends ComputerRegistry<ServerComputer> {
    public void update() {
        Iterator it = this.getComputers().iterator();
        while (it.hasNext()) {
            ServerComputer computer = (ServerComputer)it.next();
            if (computer.hasTimedOut()) {
                computer.unload();
                computer.broadcastDelete();
                it.remove();
                continue;
            }
            computer.update();
            if (!computer.hasTerminalChanged() && !computer.hasOutputChanged()) continue;
            computer.broadcastState(false);
        }
    }

    @Override
    public void add(int instanceID, ServerComputer computer) {
        super.add(instanceID, computer);
        computer.broadcastState(true);
    }

    @Override
    public void remove(int instanceID) {
        ServerComputer computer = (ServerComputer)this.get(instanceID);
        if (computer != null) {
            computer.unload();
            computer.broadcastDelete();
        }
        super.remove(instanceID);
    }

    @Override
    public void reset() {
        for (ServerComputer computer : this.getComputers()) {
            computer.unload();
        }
        super.reset();
    }

    public ServerComputer lookup(int computerID) {
        if (computerID < 0) {
            return null;
        }
        for (ServerComputer computer : this.getComputers()) {
            if (computer.getID() != computerID) continue;
            return computer;
        }
        return null;
    }
}

