/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.fabric.util.GameInstanceUtils;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.PacketContext;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.TerminalDimensionsClientMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.ContinueUploadMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public final class NetworkHandler {
    private static final Int2ObjectMap<BiConsumer<PacketContext, class_2540>> packetReaders = new Int2ObjectOpenHashMap();
    private static final Object2IntMap<Class<?>> packetIds = new Object2IntOpenHashMap();
    private static final class_2960 ID = new class_2960("computercraft", "main");

    private NetworkHandler() {
    }

    public static void setup() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, NetworkHandler::receive);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientHandler.setup();
        }
        NetworkHandler.registerMainThread(0, ComputerActionServerMessage.class, ComputerActionServerMessage::new);
        NetworkHandler.registerMainThread(1, QueueEventServerMessage.class, QueueEventServerMessage::new);
        NetworkHandler.registerMainThread(2, RequestComputerMessage.class, RequestComputerMessage::new);
        NetworkHandler.registerMainThread(3, KeyEventServerMessage.class, KeyEventServerMessage::new);
        NetworkHandler.registerMainThread(4, MouseEventServerMessage.class, MouseEventServerMessage::new);
        NetworkHandler.registerMainThread(5, UploadFileMessage.class, UploadFileMessage::new);
        NetworkHandler.registerMainThread(6, ContinueUploadMessage.class, ContinueUploadMessage::new);
        NetworkHandler.registerMainThread(10, ChatTableClientMessage.class, ChatTableClientMessage::new);
        NetworkHandler.registerMainThread(11, ComputerDataClientMessage.class, ComputerDataClientMessage::new);
        NetworkHandler.registerMainThread(12, ComputerDeletedClientMessage.class, ComputerDeletedClientMessage::new);
        NetworkHandler.registerMainThread(13, ComputerTerminalClientMessage.class, ComputerTerminalClientMessage::new);
        NetworkHandler.registerMainThread(14, PlayRecordClientMessage.class, PlayRecordClientMessage::new);
        NetworkHandler.registerMainThread(15, MonitorClientMessage.class, MonitorClientMessage::new);
        NetworkHandler.registerMainThread(16, SpeakerAudioClientMessage.class, SpeakerAudioClientMessage::new);
        NetworkHandler.registerMainThread(17, SpeakerMoveClientMessage.class, SpeakerMoveClientMessage::new);
        NetworkHandler.registerMainThread(18, SpeakerPlayClientMessage.class, SpeakerPlayClientMessage::new);
        NetworkHandler.registerMainThread(19, SpeakerStopClientMessage.class, SpeakerStopClientMessage::new);
        NetworkHandler.registerMainThread(20, UploadResultMessage.class, UploadResultMessage::new);
        NetworkHandler.registerMainThread(21, TerminalDimensionsClientMessage.class, TerminalDimensionsClientMessage::new);
    }

    private static void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buffer, PacketSender sender) {
        byte type = buffer.readByte();
        ((BiConsumer)packetReaders.get((int)type)).accept(new PacketContext((class_1657)player, (Executor)server), buffer);
    }

    private static <T> Class<T> getType(Supplier<T> supplier) {
        return supplier.get().getClass();
    }

    private static class_2540 encode(NetworkMessage message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(packetIds.getInt(message.getClass()));
        message.toBytes(buf);
        return buf;
    }

    public static void sendToPlayer(class_1657 player, NetworkMessage packet) {
        ((class_3222)player).field_13987.method_14364((class_2596)new class_2658(ID, NetworkHandler.encode(packet)));
    }

    public static void sendToAllPlayers(NetworkMessage packet) {
        MinecraftServer server = GameInstanceUtils.getServer();
        server.method_3760().method_14581((class_2596)new class_2658(ID, NetworkHandler.encode(packet)));
    }

    public static void sendToServer(NetworkMessage packet) {
        class_310.method_1551().field_1724.field_3944.method_2883((class_2596)new class_2817(ID, NetworkHandler.encode(packet)));
    }

    public static void sendToAllAround(NetworkMessage packet, class_1937 world, class_243 pos, double range) {
        world.method_8503().method_3760().method_14605(null, pos.field_1352, pos.field_1351, pos.field_1350, range, world.method_27983(), (class_2596)new class_2658(ID, NetworkHandler.encode(packet)));
    }

    public static void sendToAllTracking(NetworkMessage packet, class_2818 chunk) {
        Consumer<class_3222> sender = p -> p.field_13987.method_14364((class_2596)new class_2658(ID, NetworkHandler.encode(packet)));
        ((class_3215)chunk.method_12200().method_8398()).field_17254.method_17210(chunk.method_12004(), false).forEach(sender);
    }

    private static <T extends NetworkMessage> void registerMainThread(int id, Class<T> type, Function<class_2540, T> decoder) {
        packetIds.put(type, id);
        packetReaders.put(id, (context, buf) -> {
            NetworkMessage result = (NetworkMessage)decoder.apply((class_2540)buf);
            context.executor().execute(() -> result.handle((PacketContext)context));
        });
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        static void setup() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, ClientHandler::receive);
        }

        static void receive(class_310 client, class_634 handler, class_2540 buffer, PacketSender responseSender) {
            byte type = buffer.readByte();
            ((BiConsumer)packetReaders.get((int)type)).accept(new PacketContext((class_1657)client.field_1724, (Executor)client), buffer);
        }
    }
}

