/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.PacketContext;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class UploadFileMessage
extends ComputerServerMessage {
    public static final int MAX_SIZE = 524288;
    static final int MAX_PACKET_SIZE = 30720;
    public static final int MAX_FILES = 32;
    public static final int MAX_FILE_NAME = 128;
    private static final int FLAG_FIRST = 1;
    private static final int FLAG_LAST = 2;
    private final UUID uuid;
    private final int flag;
    private final List<FileUpload> files;
    private final List<FileSlice> slices;

    UploadFileMessage(int instanceId, UUID uuid, int flag, List<FileUpload> files, List<FileSlice> slices) {
        super(instanceId);
        this.uuid = uuid;
        this.flag = flag;
        this.files = files;
        this.slices = slices;
    }

    public UploadFileMessage(@Nonnull class_2540 buf) {
        super(buf);
        int i;
        this.uuid = buf.method_10790();
        byte by = buf.readByte();
        this.flag = by;
        byte flag = by;
        int totalSize = 0;
        if ((flag & 1) != 0) {
            int nFiles = buf.method_10816();
            if (nFiles >= 32) {
                throw new DecoderException("Too many files");
            }
            this.files = new ArrayList<FileUpload>(nFiles);
            ArrayList<FileUpload> files = this.files;
            for (i = 0; i < nFiles; ++i) {
                String name = buf.method_10800(128);
                int size = buf.method_10816();
                if (size > 524288 || (totalSize += size) >= 524288) {
                    throw new DecoderException("Files are too large");
                }
                byte[] digest = new byte[32];
                buf.readBytes(digest);
                files.add(new FileUpload(name, ByteBuffer.allocateDirect(size), digest));
            }
        } else {
            this.files = null;
        }
        int nSlices = buf.method_10816();
        this.slices = new ArrayList<FileSlice>(nSlices);
        ArrayList<FileSlice> slices = this.slices;
        for (i = 0; i < nSlices; ++i) {
            short fileId = buf.readUnsignedByte();
            int offset = buf.method_10816();
            int size = buf.readUnsignedShort();
            if (size > 30720) {
                throw new DecoderException("File is too large");
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buf.readBytes(buffer);
            buffer.flip();
            slices.add(new FileSlice(fileId, offset, buffer));
        }
    }

    @Override
    public void toBytes(@Nonnull class_2540 buf) {
        super.toBytes(buf);
        buf.method_10797(this.uuid);
        buf.writeByte(this.flag);
        if ((this.flag & 1) != 0) {
            buf.method_10804(this.files.size());
            for (FileUpload file : this.files) {
                buf.method_10788(file.getName(), 128);
                buf.method_10804(file.getLength());
                buf.writeBytes(file.getChecksum());
            }
        }
        buf.method_10804(this.slices.size());
        for (FileSlice slice : this.slices) {
            buf.writeByte(slice.getFileId());
            buf.method_10804(slice.getOffset());
            ByteBuffer bytes = slice.getBytes().duplicate();
            buf.writeShort(bytes.remaining());
            buf.writeBytes(bytes);
        }
    }

    public static void send(int instanceId, List<FileUpload> files) {
        UUID uuid = UUID.randomUUID();
        int remaining = 30720;
        for (FileUpload file : files) {
            remaining -= file.getName().length() * 4 + 32;
        }
        boolean first = true;
        ArrayList<FileSlice> slices = new ArrayList<FileSlice>(files.size());
        for (int fileId = 0; fileId < files.size(); ++fileId) {
            FileUpload file = files.get(fileId);
            ByteBuffer contents = file.getBytes();
            int capacity = contents.limit();
            int currentOffset = 0;
            while (currentOffset < capacity) {
                if (remaining <= 0) {
                    NetworkHandler.sendToServer(first ? new UploadFileMessage(instanceId, uuid, 1, files, new ArrayList<FileSlice>(slices)) : new UploadFileMessage(instanceId, uuid, 0, null, new ArrayList<FileSlice>(slices)));
                    slices.clear();
                    remaining = 30720;
                    first = false;
                }
                int canWrite = Math.min(remaining, capacity - currentOffset);
                contents.position(currentOffset).limit(currentOffset + canWrite);
                slices.add(new FileSlice(fileId, currentOffset, contents.slice()));
                currentOffset += canWrite;
                remaining -= canWrite;
            }
            contents.position(0).limit(capacity);
        }
        NetworkHandler.sendToServer(first ? new UploadFileMessage(instanceId, uuid, 3, files, new ArrayList<FileSlice>(slices)) : new UploadFileMessage(instanceId, uuid, 2, null, new ArrayList<FileSlice>(slices)));
    }

    @Override
    protected void handle(PacketContext context, @Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        class_3222 player = (class_3222)context.getPlayer();
        if (player != null) {
            if ((this.flag & 1) != 0) {
                container.startUpload(this.uuid, this.files);
            }
            container.continueUpload(this.uuid, this.slices);
            if ((this.flag & 2) != 0) {
                container.finishUpload(player, this.uuid);
            }
        }
    }
}

