/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

class GenericPeripheral
implements IDynamicPeripheral {
    private final String type;
    private final Set<String> additionalTypes;
    private final class_2586 tile;
    private final List<SaturatedMethod> methods;

    GenericPeripheral(class_2586 tile, String name, Set<String> additionalTypes, List<SaturatedMethod> methods) {
        class_2960 type = class_2378.field_11137.method_10221((Object)tile.method_11017());
        this.tile = tile;
        this.type = name != null ? name : (type != null ? type.toString() : "unknown");
        this.additionalTypes = additionalTypes;
        this.methods = methods;
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        String[] names = new String[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            names[i] = this.methods.get(i).getName();
        }
        return names;
    }

    @Override
    @Nonnull
    public MethodResult callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull IArguments arguments) throws LuaException {
        return this.methods.get(method).apply(context, computer, arguments);
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public Set<String> getAdditionalTypes() {
        return this.additionalTypes;
    }

    @Override
    @Nullable
    public Object getTarget() {
        return this.tile;
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GenericPeripheral)) {
            return false;
        }
        GenericPeripheral generic = (GenericPeripheral)other;
        return this.tile == generic.tile && this.methods.equals(generic.methods);
    }
}

