/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.IDAssigner;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public final class WiredModemLocalPeripheral {
    private static final String NBT_PERIPHERAL_TYPE = "PeripheralType";
    private static final String NBT_PERIPHERAL_ID = "PeripheralId";
    private int id = -1;
    private String type;
    private IPeripheral peripheral;
    private final Consumer<Object> invalidate = x -> invalidate.run();

    public WiredModemLocalPeripheral(@Nonnull Runnable invalidate) {
    }

    public boolean attach(@Nonnull class_1937 world, @Nonnull class_2338 origin, @Nonnull class_2350 direction) {
        IPeripheral oldPeripheral = this.peripheral;
        this.peripheral = this.getPeripheralFrom(world, origin, direction);
        IPeripheral peripheral = this.peripheral;
        if (peripheral == null) {
            return oldPeripheral != null;
        }
        String type = peripheral.getType();
        int id = this.id;
        if (id > 0 && this.type == null) {
            this.type = type;
        } else if (id < 0 || !type.equals(this.type)) {
            this.type = type;
            this.id = IDAssigner.getNextId("peripheral." + type);
        }
        return oldPeripheral == null || !oldPeripheral.equals(peripheral);
    }

    public boolean detach() {
        if (this.peripheral == null) {
            return false;
        }
        this.peripheral = null;
        return true;
    }

    @Nullable
    public String getConnectedName() {
        return this.peripheral != null ? this.type + "_" + this.id : null;
    }

    @Nullable
    public IPeripheral getPeripheral() {
        return this.peripheral;
    }

    public boolean hasPeripheral() {
        return this.peripheral != null;
    }

    public void extendMap(@Nonnull Map<String, IPeripheral> peripherals) {
        if (this.peripheral != null) {
            peripherals.put(this.type + "_" + this.id, this.peripheral);
        }
    }

    public Map<String, IPeripheral> toMap() {
        return this.peripheral == null ? Collections.emptyMap() : Collections.singletonMap(this.type + "_" + this.id, this.peripheral);
    }

    public void write(@Nonnull class_2487 tag, @Nonnull String suffix) {
        if (this.id >= 0) {
            tag.method_10569(NBT_PERIPHERAL_ID + suffix, this.id);
        }
        if (this.type != null) {
            tag.method_10582(NBT_PERIPHERAL_TYPE + suffix, this.type);
        }
    }

    public void read(@Nonnull class_2487 tag, @Nonnull String suffix) {
        this.id = tag.method_10573(NBT_PERIPHERAL_ID + suffix, 99) ? tag.method_10550(NBT_PERIPHERAL_ID + suffix) : -1;
        this.type = tag.method_10573(NBT_PERIPHERAL_TYPE + suffix, 8) ? tag.method_10558(NBT_PERIPHERAL_TYPE + suffix) : null;
    }

    @Nullable
    private IPeripheral getPeripheralFrom(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 offset = pos.method_10093(direction);
        class_2248 block = world.method_8320(offset).method_26204();
        if (block == Registry.ModBlocks.WIRED_MODEM_FULL || block == Registry.ModBlocks.CABLE) {
            return null;
        }
        IPeripheral peripheral = Peripherals.getPeripheral(world, offset, direction.method_10153());
        return peripheral instanceof WiredModemPeripheral ? null : peripheral;
    }
}

