/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2522;
import net.minecraft.class_3518;

public final class RecipeUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private RecipeUtil() {
    }

    public static ShapedTemplate getTemplate(JsonObject json) {
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : class_3518.method_15296((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).charAt(0)), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue())));
        }
        ingMap.put(Character.valueOf(' '), class_1856.field_9017);
        JsonArray patternJ = class_3518.method_15261((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = class_3518.method_15287((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        int width = pattern[0].length();
        int height = pattern.length;
        class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet missingKeys = Sets.newHashSet(ingMap.keySet());
        missingKeys.remove(Character.valueOf(' '));
        int i = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                class_1856 ing = (class_1856)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                ingredients.set(i++, (Object)ing);
                missingKeys.remove(Character.valueOf(chr));
            }
        }
        if (!missingKeys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + missingKeys);
        }
        return new ShapedTemplate(width, height, (class_2371<class_1856>)ingredients);
    }

    public static ComputerFamily getFamily(JsonObject json, String name) {
        String familyName = class_3518.method_15265((JsonObject)json, (String)name);
        for (ComputerFamily family : ComputerFamily.values()) {
            if (!family.name().equalsIgnoreCase(familyName)) continue;
            return family;
        }
        throw new JsonSyntaxException("Unknown computer family '" + familyName + "' for field " + name);
    }

    public static void setNbt(class_1799 itemStack, JsonObject result) {
        JsonElement nbtElement = result.get("nbt");
        if (nbtElement != null) {
            try {
                itemStack.method_7980(class_2522.method_10718((String)(nbtElement.isJsonObject() ? GSON.toJson(nbtElement) : class_3518.method_15287((JsonElement)nbtElement, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT entry: " + e.getMessage());
            }
        }
    }

    public static class ShapedTemplate {
        public final int width;
        public final int height;
        public final class_2371<class_1856> ingredients;

        public ShapedTemplate(int width, int height, class_2371<class_1856> ingredients) {
            this.width = width;
            this.height = height;
            this.ingredients = ingredients;
        }
    }
}

