/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IConfigProvider;
import com.mrcrayfish.configured.client.EditingTracker;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.network.Channels;
import com.mrcrayfish.configured.network.ClientMessages;
import com.mrcrayfish.configured.network.HandshakeMessages;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ClientHandler
implements ClientModInitializer {
    private static final Set<IConfigProvider> PROVIDERS = new HashSet<IConfigProvider>();

    public void onInitializeClient() {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)Channels.CONFIG_DATA, (client, handler, buf, listenerAdder) -> CompletableFuture.supplyAsync(() -> {
            HandshakeMessages.S2CConfigData message = HandshakeMessages.S2CConfigData.decode(buf);
            if (!SimpleConfigManager.getInstance().processConfigData(message)) {
                handler.method_2872().method_10747((class_2561)class_2561.method_43471((String)"configured.gui.handshake_process_failed"));
            }
            return PacketByteBufs.create();
        }, (Executor)client));
        EditingTracker.registerEvents();
        if (this.isModListInstalled()) {
            class_304 keyOpenModList = new class_304("key.configured.open_mod_list", -1, "key.categories.configured");
            KeyBindingHelper.registerKeyBinding((class_304)keyOpenModList);
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                while (keyOpenModList.method_1436()) {
                    this.openModList();
                }
            });
        }
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> SimpleConfigManager.getInstance().onClientDisconnect(handler.method_2872()));
        ClientMessages.register();
        this.loadProviders();
    }

    private boolean isModListInstalled() {
        return FabricLoader.getInstance().isModLoaded("catalogue") || FabricLoader.getInstance().isModLoaded("modmenu");
    }

    private void openModList() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1755 != null) {
            return;
        }
        class_437 newScreen = null;
        if (FabricLoader.getInstance().isModLoaded("catalogue")) {
            newScreen = this.createModListScreen("com.mrcrayfish.catalogue.client.screen.CatalogueModListScreen");
        } else if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            newScreen = this.createModListScreen("com.terraformersmc.modmenu.gui.ModsScreen");
        }
        if (newScreen != null) {
            minecraft.method_1507(newScreen);
        }
    }

    private class_437 createModListScreen(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (class_437)clazz.getDeclaredConstructor(class_437.class).newInstance(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void loadProviders() {
        FabricLoader.getInstance().getAllMods().forEach(container -> {
            CustomValue.CvObject configuredObj;
            CustomValue providersValue;
            CustomValue value = container.getMetadata().getCustomValue("configured");
            if (value != null && value.getType() == CustomValue.CvType.OBJECT && (providersValue = (configuredObj = value.getAsObject()).get("providers")) != null) {
                if (providersValue.getType() == CustomValue.CvType.ARRAY) {
                    CustomValue.CvArray array = providersValue.getAsArray();
                    array.forEach(providerValue -> {
                        if (providerValue.getType() != CustomValue.CvType.STRING) {
                            throw new RuntimeException("Config provider definition must be a String");
                        }
                        String providerClass = providerValue.getAsString();
                        PROVIDERS.add(ClientHandler.createProviderInstance(container, providerClass));
                        Configured.LOGGER.info("Successfully loaded config provider: {}", (Object)providerClass);
                    });
                } else if (providersValue.getType() == CustomValue.CvType.STRING) {
                    String providerClass = providersValue.getAsString();
                    PROVIDERS.add(ClientHandler.createProviderInstance(container, providerClass));
                    Configured.LOGGER.info("Successfully loaded config provider: {}", (Object)providerClass);
                } else {
                    throw new RuntimeException("Config provider definition must be either a String or Array of Strings");
                }
            }
        });
    }

    private static IConfigProvider createProviderInstance(ModContainer container, String classPath) {
        try {
            Class<?> providerClass = Class.forName(classPath);
            Object obj = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(obj instanceof IConfigProvider)) {
                throw new RuntimeException("Config providers must implement IConfigProvider");
            }
            IConfigProvider provider = (IConfigProvider)obj;
            return provider;
        }
        catch (Exception e) {
            Configured.LOGGER.error("Failed to load config provider from mod: {}", (Object)container.getMetadata().getId());
            throw new RuntimeException("Failed to load config provider", e);
        }
    }

    public static Set<IConfigProvider> getProviders() {
        return PROVIDERS;
    }
}

