/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.apache.commons.lang3.tuple.Pair;

public class EditListScreen
extends class_437
implements IBackgroundTexture,
IEditing {
    private static final Map<IConfigValue<?>, ListType> TYPE_CACHE = new HashMap();
    private final class_437 parent;
    private final IModConfig config;
    private final List<StringHolder> initialValues = new ArrayList<StringHolder>();
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final class_2960 background;
    private final IConfigValue<List<?>> holder;
    private final ListType listType;
    private ObjectList list;

    public EditListScreen(class_437 parent, IModConfig config, class_2561 titleIn, IConfigValue<List<?>> holder, class_2960 background) {
        super(titleIn);
        this.parent = parent;
        this.config = config;
        this.holder = holder;
        this.listType = EditListScreen.getType(holder);
        this.initialValues.addAll(holder.get().stream().map(o -> new StringHolder(this.listType.getStringParser().apply(o))).toList());
        this.values.addAll(this.initialValues);
        this.background = background;
    }

    protected void method_25426() {
        boolean readOnly;
        this.list = new ObjectList();
        this.list.method_31322(!ConfigHelper.isPlayingGame());
        this.method_25429((class_364)this.list);
        if (!this.config.isReadOnly()) {
            this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 140, this.field_22790 - 29, 0, 44, 90, (class_2561)class_2561.method_43471((String)"configured.gui.apply"), button -> {
                List newValues = this.values.stream().map(StringHolder::getValue).map(s -> this.listType.getValueParser().apply((String)s)).collect(Collectors.toList());
                this.holder.set(newValues);
                this.field_22787.method_1507(this.parent);
            }));
            this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 45, this.field_22790 - 29, 22, 33, 90, (class_2561)class_2561.method_43471((String)"configured.gui.add_value"), button -> this.field_22787.method_1507((class_437)new EditStringScreen(this, this.config, this.background, (class_2561)class_2561.method_43471((String)"configured.gui.edit_value"), "", s -> {
                Object value = this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)class_5244.field_39003);
                    }
                    return Pair.of((Object)false, (Object)this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)class_2561.method_43471((String)this.listType.getHintKey()));
            }, s -> {
                StringHolder holder = new StringHolder((String)s);
                this.values.add(holder);
                this.list.addEntry(new StringEntry(this.list, holder));
            }))));
        }
        int cancelWidth = (readOnly = this.config.isReadOnly()) ? 150 : 90;
        int cancelOffset = readOnly ? -75 : 50;
        class_2561 cancelLabel = readOnly ? class_2561.method_43471((String)"configured.gui.close") : class_5244.field_24335;
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + cancelOffset, this.field_22790 - 29, cancelWidth, 20, cancelLabel, button -> {
            if (this.isModified()) {
                ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (class_2561)class_2561.method_43471((String)"configured.gui.list_changed"), ConfirmationScreen.Icon.WARNING, result -> {
                    if (!result.booleanValue()) {
                        return true;
                    }
                    this.field_22787.method_1507(this.parent);
                    return false;
                });
                this.field_22787.method_1507((class_437)confirmScreen);
            } else {
                this.field_22787.method_1507(this.parent);
            }
        }));
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        this.list.method_25394(poseStack, mouseX, mouseY, partialTicks);
        EditListScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)14, (int)0xFFFFFF);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    @Override
    public class_2960 getBackgroundTexture() {
        return this.background;
    }

    public boolean isModified() {
        if (this.initialValues.size() != this.values.size()) {
            return true;
        }
        for (int i = 0; i < this.initialValues.size(); ++i) {
            String s2;
            String s1 = this.initialValues.get(i).getValue();
            if (s1.equals(s2 = this.values.get(i).getValue())) continue;
            return true;
        }
        return false;
    }

    protected static ListType getType(IConfigValue<?> holder) {
        if (holder instanceof ListTypeProvider) {
            ListTypeProvider provider = (ListTypeProvider)((Object)holder);
            return provider.getListType();
        }
        return TYPE_CACHE.computeIfAbsent(holder, value -> ListType.fromHolder(holder));
    }

    public static enum ListType {
        BOOLEAN(Object::toString, Boolean::valueOf, "configured.parser.not_a_boolean"),
        INTEGER(Object::toString, Ints::tryParse, "configured.parser.not_a_number"),
        LONG(Object::toString, Longs::tryParse, "configured.parser.not_a_number"),
        DOUBLE(Object::toString, Doubles::tryParse, "configured.parser.not_a_number"),
        STRING(Object::toString, o -> o, "configured.parser.not_a_value"),
        UNKNOWN(Object::toString, o -> o, "configured.parser.not_a_value");

        final Function<Object, String> stringParser;
        final Function<String, ?> valueParser;
        final String hintKey;

        private ListType(Function<Object, String> stringParser, Function<String, ?> valueParser, String hintKey) {
            this.stringParser = stringParser;
            this.valueParser = valueParser;
            this.hintKey = hintKey;
        }

        public Function<Object, String> getStringParser() {
            return this.stringParser;
        }

        public Function<String, ?> getValueParser() {
            return this.valueParser;
        }

        public String getHintKey() {
            return this.hintKey;
        }

        private static ListType fromHolder(IConfigValue<List<?>> holder) {
            ListType type = UNKNOWN;
            List<?> defaultList = holder.getDefault();
            if (!defaultList.isEmpty()) {
                type = ListType.fromObject(defaultList.get(0));
            }
            if (type == UNKNOWN) {
                type = ListType.fromElementValidator(holder);
            }
            return type;
        }

        private static ListType fromObject(Object o) {
            if (o instanceof Boolean) {
                return BOOLEAN;
            }
            if (o instanceof Integer) {
                return INTEGER;
            }
            if (o instanceof Long) {
                return LONG;
            }
            if (o instanceof Double) {
                return DOUBLE;
            }
            if (o instanceof String) {
                return STRING;
            }
            return UNKNOWN;
        }

        private static ListType fromElementValidator(IConfigValue<List<?>> spec) {
            if (spec.isValid(Collections.singletonList("s"))) {
                return STRING;
            }
            if (spec.isValid(Collections.singletonList(true))) {
                return BOOLEAN;
            }
            if (spec.isValid(Collections.singletonList(0.0))) {
                return DOUBLE;
            }
            if (spec.isValid(Collections.singletonList(0L))) {
                return LONG;
            }
            if (spec.isValid(Collections.singletonList(0))) {
                return INTEGER;
            }
            return UNKNOWN;
        }
    }

    public class ObjectList
    extends class_4265<StringEntry>
    implements IBackgroundTexture {
        public ObjectList() {
            super(EditListScreen.this.field_22787, EditListScreen.this.field_22789, EditListScreen.this.field_22790, 36, EditListScreen.this.field_22790 - 36, 24);
            EditListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int method_25329() {
            return this.field_22742 / 2 + 144;
        }

        public int method_25322() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.method_25330((class_350.class_351)entry);
        }

        public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(poseStack, mouseX, mouseY, partialTicks);
            this.method_25396().forEach(entry -> entry.method_25396().forEach(o -> {
                if (o instanceof class_4185) {
                    ((class_4185)o).method_25352(poseStack, mouseX, mouseY);
                }
            }));
        }

        @Override
        public class_2960 getBackgroundTexture() {
            return EditListScreen.this.background;
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static interface ListTypeProvider {
        public ListType getListType();
    }

    public class StringEntry
    extends class_4265.class_4266<StringEntry> {
        private final StringHolder holder;
        private final ObjectList list;
        private final class_4185 editButton;
        private final class_4185 deleteButton;

        public StringEntry(ObjectList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new IconButton(0, 0, 1, 22, 20, class_5244.field_39003, onPress -> EditListScreen.this.field_22787.method_1507((class_437)new EditStringScreen(EditListScreen.this, EditListScreen.this.config, EditListScreen.this.background, (class_2561)class_2561.method_43471((String)"configured.gui.edit_value"), this.holder.getValue(), s -> {
                Object value = EditListScreen.this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (EditListScreen.this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)class_5244.field_39003);
                    }
                    return Pair.of((Object)false, (Object)EditListScreen.this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)class_2561.method_43471((String)EditListScreen.this.listType.getHintKey()));
            }, this.holder::setValue)), (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_22763 && button.method_25367()) {
                    EditListScreen.this.method_25417(matrixStack, ((EditListScreen)EditListScreen.this).field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"configured.gui.edit"), Math.max(EditListScreen.this.field_22789 / 2 - 43, 170)), mouseX, mouseY);
                }
            });
            this.editButton.field_22763 = !EditListScreen.this.config.isReadOnly();
            this.deleteButton = new IconButton(0, 0, 11, 0, onPress -> {
                EditListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_22763 && button.method_25367()) {
                    EditListScreen.this.method_25417(matrixStack, ((EditListScreen)EditListScreen.this).field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"configured.gui.remove"), Math.max(EditListScreen.this.field_22789 / 2 - 43, 170)), mouseX, mouseY);
                }
            });
            this.deleteButton.field_22763 = !EditListScreen.this.config.isReadOnly();
        }

        public void method_25343(class_4587 poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (x % 2 != 0) {
                class_437.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + 24), (int)0x55000000);
            }
            ((EditListScreen)EditListScreen.this).field_22787.field_1772.method_30883(poseStack, (class_2561)class_2561.method_43470((String)this.holder.getValue()), (float)(left + 5), (float)(top + 8), 0xFFFFFF);
            this.editButton.field_22764 = true;
            this.editButton.field_22760 = left + width - 44;
            this.editButton.field_22761 = top + 2;
            this.editButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
            this.deleteButton.field_22764 = true;
            this.deleteButton.field_22760 = left + width - 22;
            this.deleteButton.field_22761 = top + 2;
            this.deleteButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.editButton, (Object)this.deleteButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37033(class_6381.field_33788, StringEntry.this.holder.getValue());
                }
            }, (Object)this.editButton, (Object)this.deleteButton);
        }
    }
}

