/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.play;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.network.message.MessageResponseSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageSyncSimpleConfig;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerPlayHandler {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    public static void handleSyncSimpleConfigMessage(class_2535 connection, class_3222 player, class_2960 id, byte[] data) {
        if (!ServerPlayHandler.canEditServerConfigs(player)) {
            return;
        }
        Configured.LOGGER.debug("Received server config sync from player: {}", (Object)player.method_5477().getString());
        SimpleConfigManager.SimpleConfigImpl config = SimpleConfigManager.getInstance().getConfig(id);
        if (config == null) {
            Configured.LOGGER.error("Client sent data for a config that doesn't exist: {}", (Object)id);
            connection.method_10747((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (config.isReadOnly()) {
            Configured.LOGGER.error("Client sent data for a read-only config '{}'", (Object)id);
            connection.method_10747((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.getType().isServer() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Configured.LOGGER.error("Client sent data for a config is not supposed to be updated '{}'", (Object)id);
            connection.method_10747((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.isLoaded()) {
            Configured.LOGGER.error("Client tried to perform sync update on an unloaded config. Something went wrong...");
            connection.method_10747((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (SimpleConfigManager.getInstance().processSyncData(id, data, true)) {
            if (config.getType().isSync()) {
                PlayerLookup.all((MinecraftServer)player.field_13995).forEach(player1 -> ServerPlayNetworking.send((class_3222)player1, (class_2960)MessageSyncSimpleConfig.ID, (class_2540)MessageSyncSimpleConfig.create(id, data)));
            }
            ServerPlayHandler.sendMessageToOperators(player.field_13995, (class_2561)class_2561.method_43469((String)"configured.chat.config_updated", (Object[])new Object[]{player.method_5477(), config.getFileName()}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        } else {
            connection.method_10747((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.bad_config_packet"));
        }
    }

    private static void sendMessageToOperators(MinecraftServer server, class_2561 message) {
        Preconditions.checkNotNull((Object)server, (Object)"The server was null when broadcasting config changes. This should not be possible...");
        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
            if (!server.method_3760().method_14569(serverPlayer.method_7334())) continue;
            serverPlayer.method_43496(message);
        }
    }

    public static void handleRequestSimpleConfigMessage(class_3222 player, class_2960 id) {
        if (!ServerPlayHandler.canEditServerConfigs(player)) {
            return;
        }
        Configured.LOGGER.debug("Received config request from player: {}", (Object)player.method_5477().getString());
        SimpleConfigManager.SimpleConfigImpl config = SimpleConfigManager.getInstance().getConfig(id);
        if (config == null) {
            Configured.LOGGER.warn("{} tried to request server config which does not exist!", (Object)player.method_5477().getString());
            player.field_13987.method_14367((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.no_permission"));
            return;
        }
        if (!config.getType().isServer() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Configured.LOGGER.warn("{} tried to request an invalid config from the server", (Object)player.method_5477().getString());
            player.field_13987.method_14367((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.no_permission"));
            return;
        }
        try {
            class_2960 key = config.getName();
            byte[] data = config.getData();
            ServerPlayNetworking.send((class_3222)player, (class_2960)MessageResponseSimpleConfig.ID, (class_2540)MessageResponseSimpleConfig.create(key, data));
            Configured.LOGGER.debug("Sending request reply back to player");
        }
        catch (Exception e) {
            Configured.LOGGER.warn("An exception occurred to read server config: {}", (Object)config.getFilePath());
            ServerPlayNetworking.send((class_3222)player, (class_2960)MessageResponseSimpleConfig.ID, (class_2540)MessageResponseSimpleConfig.create(config.getName(), new byte[0]));
        }
    }

    private static boolean canEditServerConfigs(class_3222 player) {
        MinecraftServer server = player.method_5682();
        if (server == null || !server.method_3816() || !((Boolean)Config.DEVELOPER.enabled.get()).booleanValue()) {
            Configured.LOGGER.warn("{} tried to request or update a server config, however developer mode is not enabled", (Object)player.method_5477().getString());
            player.field_13987.method_14367((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.unauthorized_request"));
            ServerPlayHandler.sendMessageToOperators(player.field_13995, (class_2561)class_2561.method_43471((String)"configured.chat.authorized_player").method_27692(class_124.field_1061));
            return false;
        }
        if (!((List)Config.DEVELOPER.developers.get()).contains(player.method_5845()) || !server.method_3760().method_14569(player.method_7334())) {
            Configured.LOGGER.warn("{} tried to request or update a server config, however they are not a developer", (Object)player.method_5477().getString());
            player.field_13987.method_14367((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.unauthorized_request"));
            ServerPlayHandler.sendMessageToOperators(player.field_13995, (class_2561)class_2561.method_43471((String)"configured.chat.authorized_player").method_27692(class_124.field_1061));
            return false;
        }
        return true;
    }
}

