/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.datagen.recipes.fabric;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.datagen.recipes.fabric.FeatureEnabledCondition;
import com.copycatsplus.copycats.datagen.recipes.gen.CopycatsRecipeProvider;
import com.copycatsplus.copycats.datagen.recipes.gen.GeneratedRecipeBuilder;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.BlockEntry;
import io.github.fabricators_of_create.porting_lib.data.ConditionalRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3957;
import net.minecraft.class_3981;
import net.minecraft.class_6862;

public class GeneratedRecipeBuilderFabric
implements GeneratedRecipeBuilder {
    private final List<ConditionJsonProvider> recipeConditions = new ArrayList<ConditionJsonProvider>();
    private String path = "";
    private String suffix;
    private Supplier<? extends class_1935> result;
    private class_2960 compatDatagenOutput;
    private Supplier<class_2073> unlockedBy;
    private int amount;

    private GeneratedRecipeBuilderFabric(String path) {
        this.path = path;
        this.suffix = "";
        this.amount = 1;
    }

    public GeneratedRecipeBuilderFabric(String path, Supplier<? extends class_1935> result) {
        this(path);
        this.result = result;
    }

    public GeneratedRecipeBuilderFabric(String path, class_2960 result) {
        this(path);
        this.compatDatagenOutput = result;
    }

    @Override
    public GeneratedRecipeBuilder returns(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public GeneratedRecipeBuilder unlockedBy(Supplier<? extends class_1935> item) {
        this.unlockedBy = () -> class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)item.get()}).method_8976();
        return this;
    }

    @Override
    public GeneratedRecipeBuilder unlockedByTag(Supplier<class_6862<class_1792>> tag) {
        this.unlockedBy = () -> class_2073.class_2074.method_8973().method_8975((class_6862)tag.get()).method_8976();
        return this;
    }

    @Override
    public GeneratedRecipeBuilder withSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe viaShaped(UnaryOperator<class_2447> builder) {
        return this.handleConditions(consumer -> {
            class_2447 b = (class_2447)builder.apply(class_2447.method_10436((class_1935)this.result.get(), (int)this.amount));
            if (this.unlockedBy != null) {
                b.method_10429("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{this.unlockedBy.get()}));
            }
            b.method_17972(consumer, this.createLocation("crafting"));
        });
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe viaShapeless(UnaryOperator<class_2450> builder) {
        return this.handleConditions(consumer -> {
            class_2450 b = (class_2450)builder.apply(class_2450.method_10448((class_1935)this.result.get(), (int)this.amount));
            if (this.unlockedBy != null) {
                b.method_10442("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{this.unlockedBy.get()}));
            }
            b.method_17972(consumer, this.createLocation("crafting"));
        });
    }

    private class_2960 clean(class_2960 loc) {
        String path = loc.method_12832();
        while (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return new class_2960(loc.method_12836(), path);
    }

    private class_2960 createSimpleLocation(String recipeType) {
        class_2960 loc = this.clean(Copycats.asResource(recipeType + "/" + this.getRegistryName().method_12832() + this.suffix));
        return loc;
    }

    protected class_2960 createLocation(String recipeType) {
        class_2960 loc = this.clean(Copycats.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().method_12832() + this.suffix));
        return loc;
    }

    private class_2960 getRegistryName() {
        return this.compatDatagenOutput == null ? RegisteredObjects.getKeyOrThrow((class_1792)this.result.get().method_8389()) : this.compatDatagenOutput;
    }

    @Override
    public GeneratedRecipeBuilder requiresResultFeature() {
        return this.requiresFeature(RegisteredObjects.getKeyOrThrow((class_1792)this.result.get().method_8389()));
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(class_2960 location) {
        return this.requiresFeature(location, false);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block) {
        return this.requiresFeature(block, false);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block, boolean invert) {
        return this.requiresFeature(block.getId(), invert);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(class_2960 location, boolean invert) {
        this.recipeConditions.add(new FeatureEnabledCondition(location, invert));
        return this;
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe handleConditions(Consumer<Consumer<class_2444>> recipe) {
        return CopycatsRecipeProvider.register(consumer -> {
            if (!this.recipeConditions.isEmpty()) {
                ConditionalRecipe.Builder b = ConditionalRecipe.builder();
                this.recipeConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)b).addCondition(arg_0));
                b.addRecipe(recipe);
                b.generateAdvancement();
                b.build(consumer, this.createLocation("crafting"));
            } else {
                recipe.accept(consumer);
            }
        });
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends class_1935> item) {
        return this.unlockedBy(item).viaCookingIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)item.get()}));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCookingTag(Supplier<class_6862<class_1792>> tag) {
        return this.unlockedByTag(tag).viaCookingIngredient(() -> class_1856.method_8106((class_6862)((class_6862)tag.get())));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<class_1856> ingredient) {
        return new GeneratedCookingRecipeBuilderFabric(ingredient);
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecutting(Supplier<? extends class_1935> item) {
        return this.unlockedBy(item).viaStonecuttingIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)item.get()}));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecuttingTag(Supplier<class_6862<class_1792>> tag) {
        return this.unlockedByTag(tag).viaStonecuttingIngredient(() -> class_1856.method_8106((class_6862)((class_6862)tag.get())));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecuttingIngredient(Supplier<class_1856> ingredient) {
        return new GeneratedStoneCuttingRecipeBuilderFabric(ingredient);
    }

    public class GeneratedCookingRecipeBuilderFabric
    implements GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder {
        private final Supplier<class_1856> ingredient;
        private float exp;
        private int cookingTime;
        private final class_3957<? extends class_1874> FURNACE = class_1865.field_9042;
        private final class_3957<? extends class_1874> SMOKER = class_1865.field_17085;
        private final class_3957<? extends class_1874> BLAST = class_1865.field_17084;
        private final class_3957<? extends class_1874> CAMPFIRE = class_1865.field_17347;

        GeneratedCookingRecipeBuilderFabric(Supplier<class_1856> ingredient) {
            this.ingredient = ingredient;
            this.cookingTime = 200;
            this.exp = 0.0f;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder forDuration(int duration) {
            this.cookingTime = duration;
            return this;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder rewardXP(float xp) {
            this.exp = xp;
            return this;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inFurnace() {
            return this.inFurnace(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inFurnace(UnaryOperator<class_2454> builder) {
            return this.create(this.FURNACE, builder, 1.0f);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inSmoker() {
            return this.inSmoker(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inSmoker(UnaryOperator<class_2454> builder) {
            this.create(this.FURNACE, builder, 1.0f);
            this.create(this.CAMPFIRE, builder, 3.0f);
            return this.create(this.SMOKER, builder, 0.5f);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inBlastFurnace() {
            return this.inBlastFurnace(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inBlastFurnace(UnaryOperator<class_2454> builder) {
            this.create(this.FURNACE, builder, 1.0f);
            return this.create(this.BLAST, builder, 0.5f);
        }

        private GeneratedRecipeBuilder.GeneratedRecipe create(class_3957<? extends class_1874> serializer, UnaryOperator<class_2454> builder, float cookingTimeModifier) {
            return CopycatsRecipeProvider.register(consumer -> {
                boolean isOtherMod = GeneratedRecipeBuilderFabric.this.compatDatagenOutput != null;
                class_2454 b = (class_2454)builder.apply(class_2454.method_17801((class_1856)this.ingredient.get(), (class_1935)(isOtherMod ? class_1802.field_8831 : GeneratedRecipeBuilderFabric.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (class_3957)serializer));
                if (GeneratedRecipeBuilderFabric.this.unlockedBy != null) {
                    b.method_10469("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{GeneratedRecipeBuilderFabric.this.unlockedBy.get()}));
                }
                b.method_17972(consumer::accept, GeneratedRecipeBuilderFabric.this.createSimpleLocation(RegisteredObjects.getKeyOrThrow((class_1865)serializer).method_12832()));
            });
        }
    }

    public class GeneratedStoneCuttingRecipeBuilderFabric
    implements GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder {
        private final Supplier<class_1856> ingredient;

        GeneratedStoneCuttingRecipeBuilderFabric(Supplier<class_1856> ingredient) {
            this.ingredient = ingredient;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe create() {
            return this.create(b -> b);
        }

        private GeneratedRecipeBuilder.GeneratedRecipe create(UnaryOperator<class_3981> builder) {
            return GeneratedRecipeBuilderFabric.this.handleConditions(consumer -> {
                class_3981 b = (class_3981)builder.apply(class_3981.method_17969((class_1856)this.ingredient.get(), (class_1935)GeneratedRecipeBuilderFabric.this.result.get(), (int)GeneratedRecipeBuilderFabric.this.amount));
                if (GeneratedRecipeBuilderFabric.this.unlockedBy != null) {
                    b.method_17970("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{GeneratedRecipeBuilderFabric.this.unlockedBy.get()}));
                }
                b.method_17972(consumer, GeneratedRecipeBuilderFabric.this.createLocation("stonecutting"));
            });
        }
    }
}

