/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.bearing.AnchoredLighter;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;

public class BearingContraption
extends Contraption {
    protected int sailBlocks;
    protected class_2350 facing;
    private boolean isWindmill;

    public BearingContraption() {
    }

    public BearingContraption(boolean isWindmill, class_2350 facing) {
        this.isWindmill = isWindmill;
        this.facing = facing;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        class_2338 offset = pos.method_10093(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        this.expandBoundsAroundAxis(this.facing.method_10166());
        if (this.isWindmill && this.sailBlocks < (Integer)AllConfigs.server().kinetics.minimumWindmillSails.get()) {
            throw AssemblyException.notEnoughSails(this.sailBlocks);
        }
        return !this.blocks.isEmpty();
    }

    @Override
    public ContraptionType getType() {
        return ContraptionType.BEARING;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals((Object)this.anchor.method_10093(this.facing.method_10153()));
    }

    @Override
    public void addBlock(class_2338 pos, Pair<class_3499.class_3501, class_2586> capture) {
        class_2338 localPos = pos.method_10059((class_2382)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && AllTags.AllBlockTags.WINDMILL_SAILS.matches(this.getSailBlock(capture))) {
            ++this.sailBlocks;
        }
        super.addBlock(pos, capture);
    }

    private class_2680 getSailBlock(Pair<class_3499.class_3501, class_2586> capture) {
        Object object;
        class_2680 state = ((class_3499.class_3501)capture.getKey()).field_15596;
        if (AllBlocks.COPYCAT_PANEL.has(state) && (object = capture.getRight()) instanceof CopycatBlockEntity) {
            CopycatBlockEntity cbe = (CopycatBlockEntity)object;
            return cbe.getMaterial();
        }
        return state;
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        tag.method_10569("Sails", this.sailBlocks);
        tag.method_10569("Facing", this.facing.method_10146());
        return tag;
    }

    @Override
    public void readNBT(class_1937 world, class_2487 tag, boolean spawnData) {
        this.sailBlocks = tag.method_10550("Sails");
        this.facing = class_2350.method_10143((int)tag.method_10550("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    public int getSailBlocks() {
        return this.sailBlocks;
    }

    public class_2350 getFacing() {
        return this.facing;
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        if (facing.method_10153() == this.facing && class_2338.field_10980.equals((Object)localPos)) {
            return false;
        }
        return facing.method_10166() == this.facing.method_10166();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new AnchoredLighter(this);
    }
}

