/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart.capability;

import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.minecart.CouplingHandler;
import com.simibubi.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartControllerUpdatePacket;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.extensions.INBTSerializable;
import io.github.fabricators_of_create.porting_lib.util.MinecartAndRailUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1695;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MinecartController
implements INBTSerializable<class_2487> {
    public static MinecartController EMPTY;
    private boolean needsEntryRefresh;
    private WeakReference<class_1688> weakRef;
    private Couple<Optional<StallData>> stallData;
    private Couple<Optional<CouplingData>> couplings;

    public MinecartController(class_1688 minecart) {
        this.weakRef = new WeakReference<class_1688>(minecart);
        this.stallData = Couple.create(Optional::empty);
        this.couplings = Couple.create(Optional::empty);
        this.needsEntryRefresh = true;
    }

    public void tick() {
        class_1688 cart = this.cart();
        class_1937 world = this.getWorld();
        if (this.needsEntryRefresh) {
            CapabilityMinecartController.queuedAdditions.get((class_1936)world).add(cart);
            this.needsEntryRefresh = false;
        }
        this.stallData.forEach(opt -> opt.ifPresent(sd -> sd.tick(cart)));
        MutableBoolean internalStall = new MutableBoolean(false);
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(world, idOfOther);
            internalStall.setValue(internalStall.booleanValue() || otherCart == null || !otherCart.isPresent() || otherCart.isStalled(false));
        }));
        if (!world.field_9236) {
            this.setStalled(internalStall.booleanValue(), true);
            this.disassemble(cart);
        }
    }

    private void disassemble(class_1688 cart) {
        class_2338 blockpos;
        class_2680 blockstate;
        int k;
        int j;
        if (cart instanceof class_1695) {
            return;
        }
        List passengers = cart.method_5685();
        if (passengers.isEmpty() || !(passengers.get(0) instanceof AbstractContraptionEntity)) {
            return;
        }
        class_1937 world = cart.field_6002;
        int i = class_3532.method_15357((double)cart.method_23317());
        if (world.method_8320(new class_2338(i, (j = class_3532.method_15357((double)cart.method_23318())) - 1, k = class_3532.method_15357((double)cart.method_23321()))).method_26164(class_3481.field_15463)) {
            --j;
        }
        if ((blockstate = world.method_8320(blockpos = new class_2338(i, j, k))).method_26164(class_3481.field_15463) && blockstate.method_26204() instanceof class_2442 && MinecartAndRailUtil.isActivatorRail((class_2248)blockstate.method_26204())) {
            if (cart.method_5782()) {
                cart.method_5772();
            }
            if (cart.method_7507() == 0) {
                cart.method_7524(-cart.method_7522());
                cart.method_7509(10);
                cart.method_7520(50.0f);
                cart.field_6037 = true;
            }
        }
    }

    public boolean isFullyCoupled() {
        return this.isLeadingCoupling() && this.isConnectedToCoupling();
    }

    public boolean isLeadingCoupling() {
        return this.couplings.get(true).isPresent();
    }

    public boolean isConnectedToCoupling() {
        return this.couplings.get(false).isPresent();
    }

    public boolean isCoupledThroughContraption() {
        for (boolean current : Iterate.trueAndFalse) {
            if (!this.hasContraptionCoupling(current)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContraptionCoupling(boolean current) {
        Optional<CouplingData> optional = this.couplings.get(current);
        return optional.isPresent() && optional.get().contraption;
    }

    public float getCouplingLength(boolean leading) {
        Optional<CouplingData> optional = this.couplings.get(leading);
        if (optional.isPresent()) {
            return optional.get().length;
        }
        return 0.0f;
    }

    public void decouple() {
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(this.getWorld(), idOfOther);
            if (otherCart == null) {
                return;
            }
            this.removeConnection((boolean)main);
            otherCart.removeConnection(main == false);
        }));
    }

    public void removeConnection(boolean main) {
        class_1297 entity;
        List passengers;
        if (this.hasContraptionCoupling(main) && !this.getWorld().field_9236 && !(passengers = this.cart().method_5685()).isEmpty() && (entity = (class_1297)passengers.get(0)) instanceof AbstractContraptionEntity) {
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.couplings.set(main, Optional.empty());
        this.needsEntryRefresh |= main;
        this.sendData();
    }

    public void prepareForCoupling(boolean isLeading) {
        if (isLeading && this.isLeadingCoupling() || !isLeading && this.isConnectedToCoupling()) {
            ArrayList<MinecartController> cartsToFlip = new ArrayList<MinecartController>();
            MinecartController current = this;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.LOGGER.warn("Infinite loop in coupling iteration");
                    return;
                }
                cartsToFlip.add(current);
            } while ((current = CouplingHandler.getNextInCouplingChain(this.getWorld(), current, forward)) != null && current != EMPTY);
            Iterator iterator = cartsToFlip.iterator();
            while (iterator.hasNext()) {
                MinecartController minecartController;
                MinecartController mc = minecartController = (MinecartController)iterator.next();
                mc.couplings.forEachWithContext((opt, leading) -> opt.ifPresent(cd -> {
                    cd.flip();
                    if (!cd.contraption) {
                        return;
                    }
                    List passengers = mc.cart().method_5685();
                    if (passengers.isEmpty()) {
                        return;
                    }
                    class_1297 entity = (class_1297)passengers.get(0);
                    if (!(entity instanceof OrientedContraptionEntity)) {
                        return;
                    }
                    OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
                    UUID couplingId = contraption.getCouplingId();
                    if (couplingId == cd.mainCartID) {
                        contraption.setCouplingId(cd.connectedCartID);
                        return;
                    }
                    if (couplingId == cd.connectedCartID) {
                        contraption.setCouplingId(cd.mainCartID);
                        return;
                    }
                }));
                mc.couplings = mc.couplings.swap();
                mc.needsEntryRefresh = true;
                if (mc == this) continue;
                mc.sendData();
            }
        }
    }

    public void coupleWith(boolean isLeading, UUID coupled, float length, boolean contraption) {
        UUID mainID = isLeading ? this.cart().method_5667() : coupled;
        UUID connectedID = isLeading ? coupled : this.cart().method_5667();
        this.couplings.set(isLeading, Optional.of(new CouplingData(mainID, connectedID, length, contraption)));
        this.needsEntryRefresh |= isLeading;
        this.sendData();
    }

    @Nullable
    public UUID getCoupledCart(boolean asMain) {
        Optional<CouplingData> optional = this.couplings.get(asMain);
        if (!optional.isPresent()) {
            return null;
        }
        CouplingData couplingData = optional.get();
        return asMain ? couplingData.connectedCartID : couplingData.mainCartID;
    }

    public boolean isStalled() {
        return this.isStalled(true) || this.isStalled(false);
    }

    private boolean isStalled(boolean internal) {
        return this.stallData.get(internal).isPresent();
    }

    public void setStalledExternally(boolean stall) {
        this.setStalled(stall, false);
    }

    private void setStalled(boolean stall, boolean internal) {
        if (this.isStalled(internal) == stall) {
            return;
        }
        class_1688 cart = this.cart();
        if (stall) {
            this.stallData.set(internal, Optional.of(new StallData(cart)));
            this.sendData();
            return;
        }
        if (!this.isStalled(!internal)) {
            this.stallData.get(internal).get().release(cart);
        }
        this.stallData.set(internal, Optional.empty());
        this.sendData();
    }

    public void sendData() {
        if (this.getWorld().field_9236) {
            return;
        }
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new MinecartControllerUpdatePacket(this), (class_1297)this.cart());
    }

    public class_2487 serializeNBT() {
        class_2487 compoundNBT = new class_2487();
        this.stallData.forEachWithContext((opt, internal) -> opt.ifPresent(sd -> compoundNBT.method_10566(internal != false ? "InternalStallData" : "StallData", (class_2520)sd.serialize())));
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> compoundNBT.method_10566(main != false ? "MainCoupling" : "ConnectedCoupling", (class_2520)cd.serialize())));
        return compoundNBT;
    }

    public void deserializeNBT(class_2487 nbt) {
        Optional<Object> internalSD = Optional.empty();
        Optional<Object> externalSD = Optional.empty();
        Optional<Object> mainCD = Optional.empty();
        Optional<Object> connectedCD = Optional.empty();
        if (nbt.method_10545("InternalStallData")) {
            internalSD = Optional.of(StallData.read(nbt.method_10562("InternalStallData")));
        }
        if (nbt.method_10545("StallData")) {
            externalSD = Optional.of(StallData.read(nbt.method_10562("StallData")));
        }
        if (nbt.method_10545("MainCoupling")) {
            mainCD = Optional.of(CouplingData.read(nbt.method_10562("MainCoupling")));
        }
        if (nbt.method_10545("ConnectedCoupling")) {
            connectedCD = Optional.of(CouplingData.read(nbt.method_10562("ConnectedCoupling")));
        }
        this.stallData = Couple.create(internalSD, externalSD);
        this.couplings = Couple.create(mainCD, connectedCD);
        this.needsEntryRefresh = true;
    }

    public boolean isPresent() {
        return this.weakRef.get() != null && this.cart().method_5805();
    }

    public class_1688 cart() {
        return (class_1688)this.weakRef.get();
    }

    public static MinecartController empty() {
        return EMPTY != null ? EMPTY : (EMPTY = new MinecartController(null));
    }

    private class_1937 getWorld() {
        return this.cart().method_5770();
    }

    private static class CouplingData {
        private UUID mainCartID;
        private UUID connectedCartID;
        private float length;
        private boolean contraption;

        public CouplingData(UUID mainCartID, UUID connectedCartID, float length, boolean contraption) {
            this.mainCartID = mainCartID;
            this.connectedCartID = connectedCartID;
            this.length = length;
            this.contraption = contraption;
        }

        void flip() {
            UUID swap = this.mainCartID;
            this.mainCartID = this.connectedCartID;
            this.connectedCartID = swap;
        }

        class_2487 serialize() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("Main", (class_2520)class_2512.method_25929((UUID)this.mainCartID));
            nbt.method_10566("Connected", (class_2520)class_2512.method_25929((UUID)this.connectedCartID));
            nbt.method_10548("Length", this.length);
            nbt.method_10556("Contraption", this.contraption);
            return nbt;
        }

        static CouplingData read(class_2487 nbt) {
            UUID mainCartID = class_2512.method_25930((class_2520)NBTHelper.getINBT(nbt, "Main"));
            UUID connectedCartID = class_2512.method_25930((class_2520)NBTHelper.getINBT(nbt, "Connected"));
            float length = nbt.method_10583("Length");
            boolean contraption = nbt.method_10577("Contraption");
            return new CouplingData(mainCartID, connectedCartID, length, contraption);
        }

        public UUID idOfCart(boolean main) {
            return main ? this.mainCartID : this.connectedCartID;
        }
    }

    private static class StallData {
        class_243 position;
        class_243 motion;
        float yaw;
        float pitch;

        private StallData() {
        }

        StallData(class_1688 entity) {
            this.position = entity.method_19538();
            this.motion = entity.method_18798();
            this.yaw = entity.method_36454();
            this.pitch = entity.method_36455();
            this.tick(entity);
        }

        void tick(class_1688 entity) {
            entity.method_18799(class_243.field_1353);
            entity.method_36456(this.yaw);
            entity.method_36457(this.pitch);
        }

        void release(class_1688 entity) {
            entity.method_18799(this.motion);
        }

        class_2487 serialize() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("Pos", (class_2520)VecHelper.writeNBT(this.position));
            nbt.method_10566("Motion", (class_2520)VecHelper.writeNBT(this.motion));
            nbt.method_10548("Yaw", this.yaw);
            nbt.method_10548("Pitch", this.pitch);
            return nbt;
        }

        static StallData read(class_2487 nbt) {
            StallData stallData = new StallData();
            stallData.position = VecHelper.readNBT(nbt.method_10554("Pos", 6));
            stallData.motion = VecHelper.readNBT(nbt.method_10554("Motion", 6));
            stallData.yaw = nbt.method_10583("Yaw");
            stallData.pitch = nbt.method_10583("Pitch");
            return stallData;
        }
    }
}

