/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.error.GlError;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferedData;
import com.jozufozu.flywheel.core.model.WorldModelBuilder;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.WorldAttached;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfo;
import com.simibubi.create.content.contraptions.render.ContraptionRenderingWorld;
import com.simibubi.create.content.contraptions.render.FlwContraptionManager;
import com.simibubi.create.content.contraptions.render.SBBContraptionManager;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ContraptionRenderDispatcher {
    private static WorldAttached<ContraptionRenderingWorld<?>> WORLDS = new WorldAttached(SBBContraptionManager::new);

    public static boolean invalidate(Contraption contraption) {
        class_1937 level = contraption.entity.field_6002;
        return ((ContraptionRenderingWorld)WORLDS.get((class_1936)level)).invalidate(contraption);
    }

    public static void tick(class_1937 world) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        ((ContraptionRenderingWorld)WORLDS.get((class_1936)world)).tick();
    }

    public static void beginFrame(BeginFrameEvent event) {
        ((ContraptionRenderingWorld)WORLDS.get((class_1936)event.getWorld())).beginFrame(event);
    }

    public static void renderLayer(RenderLayerEvent event) {
        ((ContraptionRenderingWorld)WORLDS.get((class_1936)event.getWorld())).renderLayer(event);
        GlError.pollAndThrow(() -> "contraption layer: " + event.getLayer());
    }

    public static void onRendererReload(ReloadRenderersEvent event) {
        ContraptionRenderDispatcher.reset();
    }

    public static void gatherContext(GatherContextEvent e) {
        ContraptionRenderDispatcher.reset();
    }

    public static void renderFromEntity(AbstractContraptionEntity entity, Contraption contraption, class_4597 buffers) {
        class_1937 world = entity.field_6002;
        Object renderInfo = ((ContraptionRenderingWorld)WORLDS.get((class_1936)world)).getRenderInfo(contraption);
        ContraptionMatrices matrices = ((ContraptionRenderInfo)renderInfo).getMatrices();
        if (!matrices.isReady()) {
            return;
        }
        VirtualRenderWorld renderWorld = ((ContraptionRenderInfo)renderInfo).renderWorld;
        ContraptionRenderDispatcher.renderBlockEntities(world, renderWorld, contraption, matrices, buffers);
        if (buffers instanceof class_4597.class_4598) {
            ((class_4597.class_4598)buffers).method_22993();
        }
        ContraptionRenderDispatcher.renderActors(world, renderWorld, contraption, matrices, buffers);
    }

    public static VirtualRenderWorld setupRenderWorld(class_1937 world, Contraption c) {
        ContraptionWorld contraptionWorld = c.getContraptionWorld();
        class_2338 origin = c.anchor;
        int minBuildHeight = contraptionWorld.method_31607();
        int height = contraptionWorld.method_31605();
        VirtualRenderWorld renderWorld = new VirtualRenderWorld(world, minBuildHeight, height, (class_2382)origin){

            public boolean supportsFlywheel() {
                return ContraptionRenderDispatcher.canInstance();
            }
        };
        renderWorld.setBlockEntities(c.presentBlockEntities.values());
        for (class_3499.class_3501 info : c.getBlocks().values()) {
            renderWorld.method_8652(info.field_15597, info.field_15596, 128);
        }
        renderWorld.runLightEngine();
        return renderWorld;
    }

    public static void renderBlockEntities(class_1937 world, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, class_4597 buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, renderWorld, c.getSpecialRenderedBEs(), matrices.getModelViewProjection(), matrices.getLight(), buffer);
    }

    protected static void renderActors(class_1937 world, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, class_4597 buffer) {
        class_4587 m = matrices.getModel();
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            class_3499.class_3501 blockInfo = (class_3499.class_3501)pair.getLeft();
            MovementBehaviour movementBehaviour = AllMovementBehaviours.getBehaviour(blockInfo.field_15596);
            if (movementBehaviour == null || c.isHiddenInPortal(blockInfo.field_15597)) continue;
            m.method_22903();
            TransformStack.cast((class_4587)m).translate((class_2382)blockInfo.field_15597);
            movementBehaviour.renderInContraption(context, renderWorld, matrices, buffer);
            m.method_22909();
        }
    }

    public static SuperByteBuffer buildStructureBuffer(VirtualRenderWorld renderWorld, Contraption c, class_1921 layer) {
        Collection<class_3499.class_3501> values = c.getRenderedBlocks();
        ShadeSeparatedBufferedData data = new WorldModelBuilder(layer).withRenderWorld((class_1920)renderWorld).withBlocks(values).build();
        SuperByteBuffer sbb = new SuperByteBuffer(data);
        data.release();
        return sbb;
    }

    public static int getLight(class_1937 world, float lx, float ly, float lz) {
        float offset;
        class_2338.class_2339 pos = new class_2338.class_2339();
        float block = 0.0f;
        float sky = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.method_10102((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    block += (float)world.method_8314(class_1944.field_9282, (class_2338)pos) / 8.0f;
                    sky += (float)world.method_8314(class_1944.field_9284, (class_2338)pos) / 8.0f;
                }
            }
        }
        return class_765.method_23687((int)((int)block), (int)((int)sky));
    }

    public static int getContraptionWorldLight(MovementContext context, VirtualRenderWorld renderWorld) {
        return class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos);
    }

    public static void reset() {
        WORLDS.empty(ContraptionRenderingWorld::delete);
        WORLDS = Backend.isOn() ? new WorldAttached(FlwContraptionManager::new) : new WorldAttached(SBBContraptionManager::new);
    }

    public static boolean canInstance() {
        return Backend.getBackendType() == BackendType.INSTANCING;
    }
}

