/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;

public class BacktankUtil {
    private static final List<Function<class_1309, List<class_1799>>> BACKTANK_SUPPLIERS = new ArrayList<Function<class_1309, List<class_1799>>>();

    public static List<class_1799> getAllWithAir(class_1309 entity) {
        ArrayList<class_1799> all = new ArrayList<class_1799>();
        for (Function<class_1309, List<class_1799>> supplier : BACKTANK_SUPPLIERS) {
            List<class_1799> result = supplier.apply(entity);
            for (class_1799 stack : result) {
                if (!BacktankUtil.hasAirRemaining(stack)) continue;
                all.add(stack);
            }
        }
        all.sort((a, b) -> Float.compare(BacktankUtil.getAir(a), BacktankUtil.getAir(b)));
        return all;
    }

    public static boolean hasAirRemaining(class_1799 backtank) {
        return BacktankUtil.getAir(backtank) > 0.0f;
    }

    public static float getAir(class_1799 backtank) {
        class_2487 tag = backtank.method_7948();
        return Math.min(tag.method_10583("Air"), (float)BacktankUtil.maxAir(backtank));
    }

    public static void consumeAir(class_1309 entity, class_1799 backtank, float i) {
        class_2487 tag = backtank.method_7948();
        int maxAir = BacktankUtil.maxAir(backtank);
        float air = BacktankUtil.getAir(backtank);
        float newAir = Math.max(air - i, 0.0f);
        tag.method_10548("Air", Math.min(newAir, (float)maxAir));
        backtank.method_7980(tag);
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        BacktankUtil.sendWarning(player, air, newAir, (float)maxAir / 10.0f);
        BacktankUtil.sendWarning(player, air, newAir, 1.0f);
    }

    private static void sendWarning(class_3222 player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        class_5250 component = Lang.translateDirect(depleted ? "backtank.depleted" : "backtank.low", new Object[0]);
        AllSoundEvents.DENY.play(player.field_6002, null, (class_2382)player.method_24515(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.field_6002, null, (class_2382)player.method_24515(), 0.5f, 0.5f);
        player.field_13987.method_14364((class_2596)new class_5905(10, 40, 10));
        player.field_13987.method_14364((class_2596)new class_5903((class_2561)Components.literal("\u26a0 ").method_27692(depleted ? class_124.field_1061 : class_124.field_1065).method_10852((class_2561)component.method_27692(class_124.field_1080))));
        player.field_13987.method_14364((class_2596)new class_5904(Components.immutableEmpty()));
    }

    public static int maxAir(class_1799 backtank) {
        return BacktankUtil.maxAir(class_1890.method_8225((class_1887)((class_1887)AllEnchantments.CAPACITY.get()), (class_1799)backtank));
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get() + (Integer)AllConfigs.server().equipment.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(class_1309 entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof class_1657 && ((class_1657)entity).method_7337()) {
            return true;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir(entity);
        if (backtanks.isEmpty()) {
            return false;
        }
        float cost = (float)BacktankUtil.maxAirWithoutEnchants() / (float)usesPerTank;
        BacktankUtil.consumeAir(entity, backtanks.get(0), cost);
        return true;
    }

    public static boolean isBarVisible(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        class_1657 player = (class_1657)EnvExecutor.callWhenOn((EnvType)EnvType.CLIENT, () -> () -> class_310.method_1551().field_1724);
        if (player == null) {
            return false;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir((class_1309)player);
        if (backtanks.isEmpty()) {
            return stack.method_7986();
        }
        return true;
    }

    public static int getBarWidth(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 13;
        }
        class_1657 player = (class_1657)EnvExecutor.callWhenOn((EnvType)EnvType.CLIENT, () -> () -> class_310.method_1551().field_1724);
        if (player == null) {
            return 13;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir((class_1309)player);
        if (backtanks.isEmpty()) {
            return Math.round(13.0f - (float)stack.method_7919() / (float)stack.method_7936() * 13.0f);
        }
        if (backtanks.size() == 1) {
            return backtanks.get(0).method_7909().method_31569(backtanks.get(0));
        }
        int sumBarWidth = backtanks.stream().map(backtank -> backtank.method_7909().method_31569(backtank)).reduce(0, Integer::sum);
        return Math.round((float)sumBarWidth / (float)backtanks.size());
    }

    public static int getBarColor(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        class_1657 player = (class_1657)EnvExecutor.callWhenOn((EnvType)EnvType.CLIENT, () -> () -> class_310.method_1551().field_1724);
        if (player == null) {
            return 0;
        }
        List<class_1799> backtanks = BacktankUtil.getAllWithAir((class_1309)player);
        if (backtanks.isEmpty()) {
            return class_3532.method_15369((float)(Math.max(0.0f, 1.0f - (float)stack.method_7919() / (float)stack.method_7936()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtanks.get(0).method_7909().method_31571(backtanks.get(0));
    }

    public static void addBacktankSupplier(Function<class_1309, List<class_1799>> supplier) {
        BACKTANK_SUPPLIERS.add(supplier);
    }

    static {
        BacktankUtil.addBacktankSupplier(entity -> {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_1799 itemStack : entity.method_5661()) {
                if (itemStack.method_7960() || !AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(itemStack)) continue;
                stacks.add(itemStack);
            }
            return stacks;
        });
    }
}

