/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper.terrainzapper;

import com.simibubi.create.content.equipment.zapper.ConfigureZapperPacket;
import com.simibubi.create.content.equipment.zapper.ZapperScreen;
import com.simibubi.create.content.equipment.zapper.terrainzapper.Brush;
import com.simibubi.create.content.equipment.zapper.terrainzapper.ConfigureWorldshaperPacket;
import com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainBrushes;
import com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class WorldshaperScreen
extends ZapperScreen {
    protected final class_2561 placementSection = Lang.translateDirect("gui.terrainzapper.placement", new Object[0]);
    protected final class_2561 toolSection = Lang.translateDirect("gui.terrainzapper.tool", new Object[0]);
    protected final List<class_2561> brushOptions = Lang.translatedOptions("gui.terrainzapper.brush", "cuboid", "sphere", "cylinder", "surface", "cluster");
    protected Vector<IconButton> toolButtons;
    protected Vector<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected Vector<ScrollInput> brushParams = new Vector(3);
    protected Vector<Label> brushParamLabels = new Vector(3);
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    protected TerrainBrushes currentBrush;
    protected int[] currentBrushParams = new int[]{1, 1, 1};
    protected boolean currentFollowDiagonals;
    protected boolean currentAcrossMaterials;
    protected TerrainTools currentTool;
    protected PlacementOptions currentPlacement;

    public WorldshaperScreen(class_1799 zapper, class_1268 hand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, hand);
        this.fontColor = 0x767676;
        this.title = zapper.method_7964();
        class_2487 nbt = zapper.method_7948();
        this.currentBrush = NBTHelper.readEnum(nbt, "Brush", TerrainBrushes.class);
        if (nbt.method_10573("BrushParams", 10)) {
            class_2338 paramsData = class_2512.method_10691((class_2487)nbt.method_10562("BrushParams"));
            this.currentBrushParams[0] = paramsData.method_10263();
            this.currentBrushParams[1] = paramsData.method_10264();
            this.currentBrushParams[2] = paramsData.method_10260();
            if (this.currentBrushParams[1] == 0) {
                this.currentFollowDiagonals = true;
            }
            if (this.currentBrushParams[2] == 0) {
                this.currentAcrossMaterials = true;
            }
        }
        this.currentTool = NBTHelper.readEnum(nbt, "Tool", TerrainTools.class);
        this.currentPlacement = NBTHelper.readEnum(nbt, "Placement", PlacementOptions.class);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brushLabel = new Label(x + 61, y + 25, Components.immutableEmpty()).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled(Lang.translateDirect("gui.terrainzapper.brush", new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> {
            this.currentBrush = TerrainBrushes.values()[brushIndex];
            this.initBrushParams(x, y);
        });
        this.brushInput.setState(this.currentBrush.ordinal());
        this.method_37063(this.brushLabel);
        this.method_37063(this.brushInput);
        this.initBrushParams(x, y);
    }

    protected void initBrushParams(int x, int y) {
        Brush currentBrush = this.currentBrush.get();
        this.removeWidgets(this.brushParamLabels);
        this.removeWidgets(this.brushParams);
        this.brushParamLabels.clear();
        this.brushParams.clear();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, Components.immutableEmpty()).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(currentBrush.getParamLabel(index).method_27662()).calling(state -> {
                this.currentBrushParams[finalIndex] = state;
                label.field_22760 = x + 65 + 20 * finalIndex - this.field_22793.method_27525((class_5348)label.text) / 2;
            });
            input.setState(this.currentBrushParams[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.field_22764 = false;
                label.field_22764 = false;
                input.field_22763 = false;
            }
            this.brushParamLabels.add(label);
            this.brushParams.add(input);
        }
        this.addRenderableWidgets(this.brushParamLabels);
        this.addRenderableWidgets(this.brushParams);
        if (this.followDiagonals != null) {
            this.method_37066(this.followDiagonals);
            this.method_37066(this.followDiagonalsIndicator);
            this.method_37066(this.acrossMaterials);
            this.method_37066(this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 7 + 72;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, Components.immutableEmpty());
            this.followDiagonals = new IconButton(x1, y1, AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, Components.immutableEmpty());
            this.acrossMaterials = new IconButton(x1, y1, AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.withCallback(() -> {
                this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentFollowDiagonals = !this.currentFollowDiagonals;
            });
            this.followDiagonals.setToolTip((class_2561)Lang.translateDirect("gui.terrainzapper.searchDiagonal", new Object[0]));
            this.acrossMaterials.withCallback(() -> {
                this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentAcrossMaterials = !this.currentAcrossMaterials;
            });
            this.acrossMaterials.setToolTip((class_2561)Lang.translateDirect("gui.terrainzapper.searchFuzzy", new Object[0]));
            this.method_37063(this.followDiagonals);
            this.method_37063(this.followDiagonalsIndicator);
            this.method_37063(this.acrossMaterials);
            this.method_37063(this.acrossMaterialsIndicator);
            if (this.currentFollowDiagonals) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (this.currentAcrossMaterials) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.removeWidgets(this.toolButtons);
        }
        TerrainTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new Vector(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            IconButton toolButton = new IconButton(x + 7 + id * 18, y + 79, tool.icon);
            toolButton.withCallback(() -> {
                this.toolButtons.forEach(b -> {
                    b.field_22763 = true;
                });
                toolButton.field_22763 = false;
                this.currentTool = tool;
            });
            toolButton.setToolTip((class_2561)Lang.translateDirect("gui.terrainzapper.tool." + tool.translationKey, new Object[0]));
            this.toolButtons.add(toolButton);
        }
        int toolIndex = -1;
        for (int i = 0; i < toolValues.length; ++i) {
            if (this.currentTool != toolValues[i]) continue;
            toolIndex = i;
        }
        if (toolIndex == -1) {
            this.currentTool = toolValues[0];
            toolIndex = 0;
        }
        this.toolButtons.get((int)toolIndex).field_22763 = false;
        this.addRenderableWidgets(this.toolButtons);
        if (this.placementButtons != null) {
            this.removeWidgets(this.placementButtons);
        }
        if (currentBrush.hasPlacementOptions()) {
            PlacementOptions[] placementValues = PlacementOptions.values();
            this.placementButtons = new Vector(placementValues.length);
            for (int id = 0; id < placementValues.length; ++id) {
                PlacementOptions option = placementValues[id];
                IconButton placementButton = new IconButton(x + 136 + id * 18, y + 79, option.icon);
                placementButton.withCallback(() -> {
                    this.placementButtons.forEach(b -> {
                        b.field_22763 = true;
                    });
                    placementButton.field_22763 = false;
                    this.currentPlacement = option;
                });
                placementButton.setToolTip((class_2561)Lang.translateDirect("gui.terrainzapper.placement." + option.translationKey, new Object[0]));
                this.placementButtons.add(placementButton);
            }
            this.placementButtons.get((int)this.currentPlacement.ordinal()).field_22763 = false;
            this.addRenderableWidgets(this.placementButtons);
        }
    }

    @Override
    protected void drawOnBackground(class_4587 matrixStack, int x, int y) {
        super.drawOnBackground(matrixStack, x, y);
        Brush currentBrush = this.currentBrush.get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.render(matrixStack, x + 56 + 20 * index, y + 40, (class_332)this);
        }
        this.field_22793.method_30883(matrixStack, this.toolSection, (float)(x + 7), (float)(y + 69), this.fontColor);
        if (currentBrush.hasPlacementOptions()) {
            this.field_22793.method_30883(matrixStack, this.placementSection, (float)(x + 136), (float)(y + 69), this.fontColor);
        }
    }

    @Override
    protected ConfigureZapperPacket getConfigurationPacket() {
        int brushParamY;
        int brushParamX = this.currentBrushParams[0];
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (brushParamY = this.currentBrushParams[1]);
        int brushParamZ = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.currentBrushParams[2];
        return new ConfigureWorldshaperPacket(this.hand, this.currentPattern, this.currentBrush, brushParamX, brushParamY, brushParamZ, this.currentTool, this.currentPlacement);
    }
}

