/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.crafter.RecipeGridHandler;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;

public class MechanicalCrafterRenderer
extends SafeBlockEntityRenderer<MechanicalCrafterBlockEntity> {
    public MechanicalCrafterRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        ms.method_22903();
        class_2350 facing = (class_2350)be.method_11010().method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        class_243 vec = class_243.method_24954((class_2382)facing.method_10163()).method_1021(0.58).method_1031(0.5, 0.5, 0.5);
        if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(be.method_11010());
            float progress = class_3532.method_15363((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
            vec = vec.method_1019(class_243.method_24954((class_2382)targetDirection.method_10163()).method_1021((double)(progress * 0.75f)));
        }
        ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        ms.method_22905(0.5f, 0.5f, 0.5f);
        float yRot = AngleHelper.horizontalAngle(facing);
        ms.method_22907(class_1160.field_20705.method_23214(yRot));
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        ms.method_22909();
        this.renderFast(be, partialTicks, ms, buffer, light);
    }

    public void renderItems(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (be.phase == MechanicalCrafterBlockEntity.Phase.IDLE) {
            class_1799 stack2 = be.getInventory().method_5438(0);
            if (!stack2.method_7960()) {
                ms.method_22903();
                ms.method_22904(0.0, 0.0, -0.00390625);
                ms.method_22907(class_1160.field_20705.method_23214(180.0f));
                class_310.method_1551().method_1480().method_23178(stack2, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                ms.method_22909();
            }
        } else {
            RecipeGridHandler.GroupedItems items = be.groupedItems;
            float distance = 0.5f;
            ms.method_22903();
            if (be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
                items = be.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = class_3532.method_15363((float)(((float)(2000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.method_22905(1.0f - lateProgress, 1.0f - lateProgress, 1.0f - lateProgress);
                class_243 centering = new class_243((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).method_1021((double)earlyProgress);
                ms.method_22904(centering.field_1352 * 0.5, centering.field_1351 * 0.5, 0.0);
                distance += (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
            }
            boolean onlyRenderFirst = be.phase == MechanicalCrafterBlockEntity.Phase.INSERTING || be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING && be.countDown < 1000;
            float spacing = distance;
            items.grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0)) {
                    return;
                }
                ms.method_22903();
                Integer x = (Integer)pair.getKey();
                Integer y = (Integer)pair.getValue();
                ms.method_22904((double)((float)x.intValue() * spacing), (double)((float)y.intValue() * spacing), 0.0);
                int offset = 0;
                if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING && be.method_11010().method_28498(MechanicalCrafterBlock.POINTING)) {
                    Pointing value = (Pointing)((Object)((Object)be.method_11010().method_11654(MechanicalCrafterBlock.POINTING)));
                    offset = value == Pointing.UP ? -1 : (value == Pointing.LEFT ? 2 : (value == Pointing.RIGHT ? -2 : 1));
                }
                ((TransformStack)TransformStack.cast((class_4587)ms).rotateY(180.0)).translate(0.0, 0.0, (double)((float)(x + y * 3 + offset * 9) / 1024.0f));
                class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                ms.method_22909();
            });
            ms.method_22909();
            if (be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
                items = be.groupedItems;
                float progress = class_3532.method_15363((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.method_22907(class_1160.field_20707.method_23214(earlyProgress * 2.0f * 360.0f));
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1.0f + (1.0f - lateProgress) * 0.125f;
                ms.method_22905(upScaling, upScaling, upScaling);
                ms.method_22905(downScaling, downScaling, downScaling);
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                        return;
                    }
                    ms.method_22903();
                    ms.method_22907(class_1160.field_20705.method_23214(180.0f));
                    class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4319, light, overlay, ms, buffer, 0);
                    ms.method_22909();
                });
            }
        }
    }

    public void renderFast(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_2680 blockState = be.method_11010();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (!Backend.canUseInstancing((class_1937)be.method_10997())) {
            SuperByteBuffer superBuffer = CachedBufferer.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light);
            superBuffer.rotateCentered(class_2350.field_11036, (float)(((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() != class_2350.class_2351.field_11048 ? 0.0 : 1.5707963267948966));
            superBuffer.rotateCentered(class_2350.field_11034, 1.5707964f);
            superBuffer.renderInto(ms, vb);
        }
        class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        class_2338 pos = be.method_11016();
        if ((be.covered || be.phase != MechanicalCrafterBlockEntity.Phase.IDLE) && be.phase != MechanicalCrafterBlockEntity.Phase.CRAFTING && be.phase != MechanicalCrafterBlockEntity.Phase.INSERTING) {
            SuperByteBuffer lidBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_LID, blockState);
            lidBuffer.light(light).renderInto(ms, vb);
        }
        if (MechanicalCrafterBlock.isValidTarget(be.method_10997(), pos.method_10093(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT, blockState);
            SuperByteBuffer beltFrameBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, blockState);
            if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)be.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                beltBuffer.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, (float)(textureIndex % 4) / 4.0f, 0.0f, 1);
            }
            beltBuffer.light(light).renderInto(ms, vb);
            beltFrameBuffer.light(light).renderInto(ms, vb);
        } else {
            SuperByteBuffer arrowBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_ARROW, blockState);
            arrowBuffer.light(light).renderInto(ms, vb);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, class_2680 crafterState) {
        SuperByteBuffer buffer = CachedBufferer.partial(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.method_11654(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((class_2350)crafterState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered(class_2350.field_11036, (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI));
        buffer.rotateCentered(class_2350.field_11034, (float)((double)(xRot / 180.0f) * Math.PI));
        return buffer;
    }
}

