/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan.processing;

import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class FanProcessing {
    public static boolean canProcess(class_1542 entity, FanProcessingType type) {
        class_2487 compound;
        if (entity.getExtraCustomData().method_10545("CreateData") && (compound = entity.getExtraCustomData().method_10562("CreateData")).method_10545("Processing")) {
            class_2487 processing = compound.method_10562("Processing");
            if (AllFanProcessingTypes.parseLegacy(processing.method_10558("Type")) != type) {
                return type.canProcess(entity.method_6983(), entity.field_6002);
            }
            if (processing.method_10550("Time") >= 0) {
                return true;
            }
            if (processing.method_10550("Time") == -1) {
                return false;
            }
        }
        return type.canProcess(entity.method_6983(), entity.field_6002);
    }

    public static boolean applyProcessing(class_1542 entity, FanProcessingType type) {
        if (FanProcessing.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List<class_1799> stacks = type.process(entity.method_6983(), entity.field_6002);
        if (stacks == null) {
            return false;
        }
        if (stacks.isEmpty()) {
            entity.method_31472();
            return false;
        }
        entity.method_6979(stacks.remove(0));
        for (class_1799 additional : stacks) {
            class_1542 entityIn = new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), additional);
            entityIn.method_18799(entity.method_18798());
            entity.field_6002.method_8649((class_1297)entityIn);
        }
        return true;
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, class_1937 world, FanProcessingType type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            int processingTime;
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.method_7947() - 1) / 16 + 1;
            transported.processingTime = processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<class_1799> stacks = type.process(transported.stack, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (class_1799 additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.method_7972();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static int decrementProcessingTime(class_1542 entity, FanProcessingType type) {
        class_2487 processing;
        class_2487 createData;
        class_2487 nbt = entity.getExtraCustomData();
        if (!nbt.method_10545("CreateData")) {
            nbt.method_10566("CreateData", (class_2520)new class_2487());
        }
        if (!(createData = nbt.method_10562("CreateData")).method_10545("Processing")) {
            createData.method_10566("Processing", (class_2520)new class_2487());
        }
        if (!(processing = createData.method_10562("Processing")).method_10545("Type") || AllFanProcessingTypes.parseLegacy(processing.method_10558("Type")) != type) {
            processing.method_10582("Type", FanProcessingTypeRegistry.getIdOrThrow(type).toString());
            int timeModifierForStackSize = (entity.method_6983().method_7947() - 1) / 16 + 1;
            int processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            processing.method_10569("Time", processingTime);
        }
        int value = processing.method_10550("Time") - 1;
        processing.method_10569("Time", value);
        return value;
    }
}

