/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1271;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1813;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2387;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3920;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import net.minecraft.class_4969;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AllArmInteractionPointTypes {
    public static final BasinType BASIN = AllArmInteractionPointTypes.register("basin", BasinType::new);
    public static final BeltType BELT = AllArmInteractionPointTypes.register("belt", BeltType::new);
    public static final BlazeBurnerType BLAZE_BURNER = AllArmInteractionPointTypes.register("blaze_burner", BlazeBurnerType::new);
    public static final ChuteType CHUTE = AllArmInteractionPointTypes.register("chute", ChuteType::new);
    public static final CrafterType CRAFTER = AllArmInteractionPointTypes.register("crafter", CrafterType::new);
    public static final CrushingWheelsType CRUSHING_WHEELS = AllArmInteractionPointTypes.register("crushing_wheels", CrushingWheelsType::new);
    public static final DeployerType DEPLOYER = AllArmInteractionPointTypes.register("deployer", DeployerType::new);
    public static final DepotType DEPOT = AllArmInteractionPointTypes.register("depot", DepotType::new);
    public static final FunnelType FUNNEL = AllArmInteractionPointTypes.register("funnel", FunnelType::new);
    public static final MillstoneType MILLSTONE = AllArmInteractionPointTypes.register("millstone", MillstoneType::new);
    public static final SawType SAW = AllArmInteractionPointTypes.register("saw", SawType::new);
    public static final CampfireType CAMPFIRE = AllArmInteractionPointTypes.register("campfire", CampfireType::new);
    public static final ComposterType COMPOSTER = AllArmInteractionPointTypes.register("composter", ComposterType::new);
    public static final JukeboxType JUKEBOX = AllArmInteractionPointTypes.register("jukebox", JukeboxType::new);
    public static final RespawnAnchorType RESPAWN_ANCHOR = AllArmInteractionPointTypes.register("respawn_anchor", RespawnAnchorType::new);

    private static <T extends ArmInteractionPointType> T register(String id, Function<class_2960, T> factory) {
        ArmInteractionPointType type = (ArmInteractionPointType)factory.apply(Create.asResource(id));
        ArmInteractionPointType.register(type);
        return (T)type;
    }

    public static void register() {
    }

    public static class BasinType
    extends ArmInteractionPointType {
        public BasinType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.BASIN.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class BeltType
    extends ArmInteractionPointType {
        public BeltType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.BELT.has(state) && !(level.method_8320(pos.method_10084()).method_26204() instanceof BeltTunnelBlock);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new BeltPoint(this, level, pos, state);
        }
    }

    public static class BlazeBurnerType
    extends ArmInteractionPointType {
        public BlazeBurnerType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.BLAZE_BURNER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new BlazeBurnerPoint(this, level, pos, state);
        }
    }

    public static class ChuteType
    extends ArmInteractionPointType {
        public ChuteType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AbstractChuteBlock.isChute(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class CrafterType
    extends ArmInteractionPointType {
        public CrafterType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.MECHANICAL_CRAFTER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new CrafterPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelsType
    extends ArmInteractionPointType {
        public CrushingWheelsType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class DeployerType
    extends ArmInteractionPointType {
        public DeployerType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.DEPLOYER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new DeployerPoint(this, level, pos, state);
        }
    }

    public static class DepotType
    extends ArmInteractionPointType {
        public DepotType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state) || AllBlocks.TRACK_STATION.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class FunnelType
    extends ArmInteractionPointType {
        public FunnelType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return !(!(state.method_26204() instanceof AbstractFunnelBlock) || state.method_28498((class_2769)FunnelBlock.EXTRACTING) && (Boolean)state.method_11654((class_2769)FunnelBlock.EXTRACTING) != false || state.method_28498(BeltFunnelBlock.SHAPE) && state.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PUSHING);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new FunnelPoint(this, level, pos, state);
        }
    }

    public static class MillstoneType
    extends ArmInteractionPointType {
        public MillstoneType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.MILLSTONE.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class SawType
    extends ArmInteractionPointType {
        public SawType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return AllBlocks.MECHANICAL_SAW.has(state) && state.method_11654((class_2769)SawBlock.FACING) == class_2350.field_11036 && ((KineticBlockEntity)level.method_8321(pos)).getSpeed() != 0.0f;
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class CampfireType
    extends ArmInteractionPointType {
        public CampfireType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_26204() instanceof class_3922;
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new CampfirePoint(this, level, pos, state);
        }
    }

    public static class ComposterType
    extends ArmInteractionPointType {
        public ComposterType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(class_2246.field_17563);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new ComposterPoint(this, level, pos, state);
        }
    }

    public static class JukeboxType
    extends ArmInteractionPointType {
        public JukeboxType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(class_2246.field_10223);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new JukeboxPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorType
    extends ArmInteractionPointType {
        public RespawnAnchorType(class_2960 id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(class_1937 level, class_2338 pos, class_2680 state) {
            return state.method_27852(class_2246.field_23152);
        }

        @Override
        public ArmInteractionPoint createPoint(class_1937 level, class_2338 pos, class_2680 state) {
            return new RespawnAnchorPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorPoint
    extends DepositOnlyArmInteractionPoint {
        public RespawnAnchorPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954((class_2382)this.pos).method_1031(0.5, 1.0, 0.5);
        }

        @Override
        public class_1799 insert(class_1799 stack, TransactionContext ctx) {
            if (!stack.method_31574(class_1802.field_8801)) {
                return stack;
            }
            if (this.cachedState.method_28500((class_2769)class_4969.field_23153).orElse(4) == 4) {
                return stack;
            }
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> class_4969.method_26382((class_1937)this.level, (class_2338)this.pos, (class_2680)this.cachedState));
            class_1799 remainder = stack.method_7972();
            remainder.method_7934(1);
            return remainder;
        }
    }

    public static class JukeboxPoint
    extends TopFaceArmInteractionPoint {
        public JukeboxPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public class_1799 insert(class_1799 stack, TransactionContext ctx) {
            class_1792 item = stack.method_7909();
            if (!(item instanceof class_1813)) {
                return stack;
            }
            if (this.cachedState.method_28500((class_2769)class_2387.field_11180).orElse(true).booleanValue()) {
                return stack;
            }
            class_2586 blockEntity = this.level.method_8321(this.pos);
            if (!(blockEntity instanceof class_2619)) {
                return stack;
            }
            class_2619 jukeboxBE = (class_2619)blockEntity;
            if (!jukeboxBE.method_11275().method_7960()) {
                return stack;
            }
            class_1799 remainder = stack.method_7972();
            class_1799 toInsert = remainder.method_7971(1);
            this.level.updateSnapshots(ctx);
            this.level.method_8652(this.pos, (class_2680)this.cachedState.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(true)), 2);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                jukeboxBE.method_11276(toInsert);
                this.level.method_8444(null, 1010, this.pos, class_1792.method_7880((class_1792)item));
            });
            return remainder;
        }

        @Override
        public class_1799 extract(int amount, TransactionContext ctx) {
            if (!this.cachedState.method_28500((class_2769)class_2387.field_11180).orElse(false).booleanValue()) {
                return class_1799.field_8037;
            }
            class_2586 blockEntity = this.level.method_8321(this.pos);
            if (!(blockEntity instanceof class_2619)) {
                return class_1799.field_8037;
            }
            class_2619 jukeboxBE = (class_2619)blockEntity;
            class_1799 record = jukeboxBE.method_11275();
            if (record.method_7960()) {
                return class_1799.field_8037;
            }
            this.level.updateSnapshots(ctx);
            this.level.method_8652(this.pos, (class_2680)this.cachedState.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(false)), 2);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                this.level.method_20290(1010, this.pos, 0);
                jukeboxBE.method_5448();
            });
            return record;
        }
    }

    public static class ComposterPoint
    extends ArmInteractionPoint {
        public ComposterPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954((class_2382)this.pos).method_1031(0.5, 0.8125, 0.5);
        }
    }

    public static class CampfirePoint
    extends DepositOnlyArmInteractionPoint {
        public CampfirePoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public class_1799 insert(class_1799 stack, TransactionContext ctx) {
            class_2586 blockEntity = this.level.method_8321(this.pos);
            if (!(blockEntity instanceof class_3924)) {
                return stack;
            }
            class_3924 campfireBE = (class_3924)blockEntity;
            Optional recipe = campfireBE.method_17502(stack);
            if (recipe.isEmpty()) {
                return stack;
            }
            boolean hasSpace = false;
            for (class_1799 campfireStack : campfireBE.method_17505()) {
                if (!campfireStack.method_7960()) continue;
                hasSpace = true;
                break;
            }
            if (!hasSpace) {
                return stack;
            }
            class_1799 inserted = ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)1);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> campfireBE.method_17503(null, inserted, ((class_3920)recipe.get()).method_8167()));
            class_1799 remainder = stack.method_7972();
            remainder.method_7934(1);
            return remainder;
        }
    }

    public static class FunnelPoint
    extends DepositOnlyArmInteractionPoint {
        public FunnelPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            class_2350 funnelFacing = FunnelBlock.getFunnelFacing(this.cachedState);
            class_2382 normal = funnelFacing != null ? funnelFacing.method_10163() : class_2382.field_11176;
            return VecHelper.getCenterOf((class_2382)this.pos).method_1019(class_243.method_24954((class_2382)normal).method_1021((double)-0.15f));
        }

        @Override
        protected class_2350 getInteractionDirection() {
            class_2350 funnelFacing = FunnelBlock.getFunnelFacing(this.cachedState);
            return funnelFacing != null ? funnelFacing.method_10153() : class_2350.field_11036;
        }

        @Override
        public void updateCachedState() {
            class_2680 oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public class_1799 insert(class_1799 stack, TransactionContext ctx) {
            class_2586 blockEntity;
            FilteringBehaviour filtering = BlockEntityBehaviour.get((class_1922)this.level, this.pos, FilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = BlockEntityBehaviour.get((class_1922)this.level, this.pos, InvManipulationBehaviour.TYPE);
            if (this.cachedState.method_28500((class_2769)class_2741.field_12484).orElse(false).booleanValue()) {
                return stack;
            }
            if (inserter == null) {
                return stack;
            }
            if (filtering != null && !filtering.test(stack)) {
                return stack;
            }
            class_1799 insert = inserter.insert(stack);
            if (insert.method_7947() != stack.method_7947() && (blockEntity = this.level.method_8321(this.pos)) instanceof FunnelBlockEntity) {
                FunnelBlockEntity funnelBlockEntity = (FunnelBlockEntity)blockEntity;
                TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                    funnelBlockEntity.onTransfer(stack);
                    if (funnelBlockEntity.hasFlap()) {
                        funnelBlockEntity.flap(true);
                    }
                });
            }
            return insert;
        }
    }

    public static class DepotPoint
    extends ArmInteractionPoint {
        public DepotPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954((class_2382)this.pos).method_1031(0.5, 0.875, 0.5);
        }
    }

    public static class DeployerPoint
    extends ArmInteractionPoint {
        public DeployerPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_2350 getInteractionDirection() {
            return this.cachedState.method_28500((class_2769)DeployerBlock.FACING).orElse(class_2350.field_11036).method_10153();
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return super.getInteractionPositionVector().method_1019(class_243.method_24954((class_2382)this.getInteractionDirection().method_10163()).method_1021((double)0.65f));
        }

        @Override
        public void updateCachedState() {
            class_2680 oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }
    }

    public static class CrafterPoint
    extends ArmInteractionPoint {
        public CrafterPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_2350 getInteractionDirection() {
            return this.cachedState.method_28500(MechanicalCrafterBlock.HORIZONTAL_FACING).orElse(class_2350.field_11035).method_10153();
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return super.getInteractionPositionVector().method_1019(class_243.method_24954((class_2382)this.getInteractionDirection().method_10163()).method_1021(0.5));
        }

        @Override
        public void updateCachedState() {
            class_2680 oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public class_1799 extract(int amount, TransactionContext ctx) {
            class_2586 be = this.level.method_8321(this.pos);
            if (!(be instanceof MechanicalCrafterBlockEntity)) {
                return class_1799.field_8037;
            }
            MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)be;
            MechanicalCrafterBlockEntity.Inventory inventory = crafter.getInventory();
            inventory.allowExtraction();
            class_1799 extract = super.extract(amount, ctx);
            inventory.forbidExtraction();
            return extract;
        }
    }

    public static class BlazeBurnerPoint
    extends DepositOnlyArmInteractionPoint {
        public BlazeBurnerPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public class_1799 insert(class_1799 stack, TransactionContext ctx) {
            class_1799 input = stack.method_7972();
            class_1271<class_1799> res = BlazeBurnerBlock.tryInsert(this.cachedState, this.level, this.pos, input, false, false, ctx);
            class_1799 remainder = (class_1799)res.method_5466();
            if (input.method_7960()) {
                return remainder;
            }
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> class_1264.method_5449((class_1937)this.level, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), (class_1799)remainder));
            return input;
        }
    }

    public static class BeltPoint
    extends DepotPoint {
        public BeltPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public void keepAlive() {
            super.keepAlive();
            BeltBlockEntity beltBE = BeltHelper.getSegmentBE((class_1936)this.level, this.pos);
            if (beltBE == null) {
                return;
            }
            TransportedItemStackHandlerBehaviour transport = beltBE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null) {
                return;
            }
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public static class TopFaceArmInteractionPoint
    extends ArmInteractionPoint {
        public TopFaceArmInteractionPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        protected class_243 getInteractionPositionVector() {
            return class_243.method_24954((class_2382)this.pos).method_1031(0.5, 1.0, 0.5);
        }
    }

    public static class DepositOnlyArmInteractionPoint
    extends ArmInteractionPoint {
        public DepositOnlyArmInteractionPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
            super(type, level, pos, state);
        }

        @Override
        public void cycleMode() {
        }

        @Override
        public class_1799 extract(int amount, TransactionContext ctx) {
            return class_1799.field_8037;
        }
    }
}

