/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.waterwheel;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2258;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;

public class WaterWheelBlockEntity
extends GeneratingKineticBlockEntity {
    public static final Map<class_2350.class_2351, Set<class_2338>> SMALL_OFFSETS = new EnumMap<class_2350.class_2351, Set<class_2338>>(class_2350.class_2351.class);
    public static final Map<class_2350.class_2351, Set<class_2338>> LARGE_OFFSETS = new EnumMap<class_2350.class_2351, Set<class_2338>>(class_2350.class_2351.class);
    public int flowScore;
    public class_2680 material = class_2246.field_9975.method_9564();

    public WaterWheelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(60);
    }

    protected int getSize() {
        return 1;
    }

    protected Set<class_2338> getOffsetsToCheck() {
        return (this.getSize() == 1 ? SMALL_OFFSETS : LARGE_OFFSETS).get(this.getAxis());
    }

    public class_1269 applyMaterialIfValid(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return class_1269.field_5811;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2680 material = blockItem.method_7711().method_9564();
        if (material == this.material) {
            return class_1269.field_5811;
        }
        if (!material.method_26164(class_3481.field_15471)) {
            return class_1269.field_5811;
        }
        if (this.field_11863.method_8608() && !this.isVirtual()) {
            return class_1269.field_5812;
        }
        this.material = material;
        this.notifyUpdate();
        this.field_11863.method_20290(2001, this.field_11867, class_2248.method_9507((class_2680)material));
        return class_1269.field_5812;
    }

    protected class_2350.class_2351 getAxis() {
        class_2350.class_2351 axis = class_2350.class_2351.field_11048;
        class_2680 blockState = this.method_11010();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof IRotate) {
            IRotate irotate = (IRotate)class_22482;
            axis = irotate.getRotationAxis(blockState);
        }
        return axis;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.determineAndApplyFlowScore();
    }

    public void determineAndApplyFlowScore() {
        class_243 wheelPlane = class_243.method_24954((class_2382)new class_2382(1, 1, 1).method_35852(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.getAxis()).method_10163()));
        int flowScore = 0;
        boolean lava = false;
        for (class_2338 blockPos : this.getOffsetsToCheck()) {
            class_243 normal;
            class_243 positiveMotion;
            double dot;
            class_2338 targetPos = blockPos.method_10081((class_2382)this.field_11867);
            class_243 flowAtPos = this.getFlowVectorAtPosition(targetPos).method_18806(wheelPlane);
            lava |= FluidHelper.isLava(this.field_11863.method_8316(targetPos).method_15772());
            if (flowAtPos.method_1027() == 0.0 || !(Math.abs(dot = (flowAtPos = flowAtPos.method_1029()).method_1026(positiveMotion = VecHelper.rotate(normal = class_243.method_24954((class_2382)blockPos).method_1029(), 90.0, this.getAxis()))) > 0.5)) continue;
            flowScore = (int)((double)flowScore + Math.signum(dot));
        }
        if (flowScore != 0 && !this.field_11863.method_8608()) {
            this.award(lava ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
        }
        this.setFlowScoreAndUpdate(flowScore);
    }

    public class_243 getFlowVectorAtPosition(class_2338 pos) {
        class_3610 fluid = this.field_11863.method_8316(pos);
        class_243 vec = fluid.method_15758((class_1922)this.field_11863, pos);
        class_2680 blockState = this.field_11863.method_8320(pos);
        if (blockState.method_26204() == class_2246.field_10422) {
            vec = new class_243(0.0, (Boolean)blockState.method_11654((class_2769)class_2258.field_10680) != false ? -1.0 : 1.0, 0.0);
        }
        return vec;
    }

    public void setFlowScoreAndUpdate(int score) {
        if (this.flowScore == score) {
            return;
        }
        this.flowScore = score;
        this.updateGeneratedRotation();
        this.method_5431();
    }

    private void redraw() {
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.method_11002()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            this.field_11863.method_8398().method_12130().method_15513(this.field_11867);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.LAVA_WHEEL, AllAdvancements.WATER_WHEEL);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.flowScore = compound.method_10550("FlowScore");
        class_2680 prevMaterial = this.material;
        if (!compound.method_10545("Material")) {
            return;
        }
        this.material = class_2512.method_10681((class_2487)compound.method_10562("Material"));
        if (this.material.method_26215()) {
            this.material = class_2246.field_9975.method_9564();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("FlowScore", this.flowScore);
        compound.method_10566("Material", (class_2520)class_2512.method_10686((class_2680)this.material));
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014((double)this.getSize());
    }

    @Override
    public float getGeneratedSpeed() {
        return class_3532.method_15340((int)this.flowScore, (int)-1, (int)1) * 8 / this.getSize();
    }

    static {
        for (class_2350.class_2351 axis : Iterate.axes) {
            HashSet<class_2338> offsets = new HashSet<class_2338>();
            for (class_2350 d : Iterate.directions) {
                if (d.method_10166() == axis) continue;
                offsets.add(class_2338.field_10980.method_10093(d));
            }
            SMALL_OFFSETS.put(axis, offsets);
            offsets = new HashSet();
            for (class_2350 d : Iterate.directions) {
                if (d.method_10166() == axis) continue;
                class_2338 centralOffset = class_2338.field_10980.method_10079(d, 2);
                offsets.add(centralOffset);
                for (class_2350 d2 : Iterate.directions) {
                    if (d2.method_10166() == axis || d2.method_10166() == d.method_10166()) continue;
                    offsets.add(centralOffset.method_10093(d2));
                }
            }
            LARGE_OFFSETS.put(axis, offsets);
        }
    }
}

