/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class ProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
implements class_1865<T> {
    private final ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory;

    public ProcessingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory) {
        this.factory = factory;
    }

    protected void writeToJson(JsonObject json, T recipe) {
        HeatCondition requiredHeat;
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        ((ProcessingRecipe)recipe).ingredients.forEach(i -> jsonIngredients.add(i.method_8089()));
        ((ProcessingRecipe)recipe).fluidIngredients.forEach(i -> jsonIngredients.add((JsonElement)i.serialize()));
        ((ProcessingRecipe)recipe).results.forEach(o -> jsonOutputs.add(o.serialize()));
        ((ProcessingRecipe)recipe).fluidResults.forEach(o -> jsonOutputs.add(FluidHelper.serializeFluidStack(o)));
        json.add("ingredients", (JsonElement)jsonIngredients);
        json.add("results", (JsonElement)jsonOutputs);
        int processingDuration = ((ProcessingRecipe)recipe).getProcessingDuration();
        if (processingDuration > 0) {
            json.addProperty("processingTime", (Number)processingDuration);
        }
        if ((requiredHeat = ((ProcessingRecipe)recipe).getRequiredHeat()) != HeatCondition.NONE) {
            json.addProperty("heatRequirement", requiredHeat.serialize());
        }
        ((ProcessingRecipe)recipe).writeAdditional(json);
    }

    protected T readFromJson(class_2960 recipeId, JsonObject json) {
        ProcessingRecipeBuilder<T> builder = new ProcessingRecipeBuilder<T>(this.factory, recipeId);
        class_2371 ingredients = class_2371.method_10211();
        class_2371 fluidIngredients = class_2371.method_10211();
        class_2371 results = class_2371.method_10211();
        class_2371 fluidResults = class_2371.method_10211();
        for (JsonElement je : class_3518.method_15261((JsonObject)json, (String)"ingredients")) {
            if (FluidIngredient.isFluidIngredient(je)) {
                fluidIngredients.add((Object)FluidIngredient.deserialize(je));
                continue;
            }
            ingredients.add((Object)class_1856.method_8102((JsonElement)je));
        }
        for (JsonElement je : class_3518.method_15261((JsonObject)json, (String)"results")) {
            JsonObject jsonObject = je.getAsJsonObject();
            if (class_3518.method_15294((JsonObject)jsonObject, (String)"fluid")) {
                fluidResults.add((Object)FluidHelper.deserializeFluidStack(jsonObject));
                continue;
            }
            results.add((Object)ProcessingOutput.deserialize(je));
        }
        builder.withItemIngredients((class_2371<class_1856>)ingredients).withItemOutputs((class_2371<ProcessingOutput>)results).withFluidIngredients((class_2371<FluidIngredient>)fluidIngredients).withFluidOutputs((class_2371<FluidStack>)fluidResults);
        if (class_3518.method_15294((JsonObject)json, (String)"processingTime")) {
            builder.duration(class_3518.method_15260((JsonObject)json, (String)"processingTime"));
        }
        if (class_3518.method_15294((JsonObject)json, (String)"heatRequirement")) {
            builder.requiresHeat(HeatCondition.deserialize(class_3518.method_15265((JsonObject)json, (String)"heatRequirement")));
        }
        T recipe = builder.build();
        ((ProcessingRecipe)recipe).readAdditional(json);
        return recipe;
    }

    protected void writeToBuffer(class_2540 buffer, T recipe) {
        class_2371<class_1856> ingredients = ((ProcessingRecipe)recipe).ingredients;
        class_2371<FluidIngredient> fluidIngredients = ((ProcessingRecipe)recipe).fluidIngredients;
        class_2371<ProcessingOutput> outputs = ((ProcessingRecipe)recipe).results;
        class_2371<FluidStack> fluidOutputs = ((ProcessingRecipe)recipe).fluidResults;
        buffer.method_10804(ingredients.size());
        ingredients.forEach(i -> i.method_8088(buffer));
        buffer.method_10804(fluidIngredients.size());
        fluidIngredients.forEach(i -> i.write(buffer));
        buffer.method_10804(outputs.size());
        outputs.forEach(o -> o.write(buffer));
        buffer.method_10804(fluidOutputs.size());
        fluidOutputs.forEach(o -> o.toBuffer(buffer));
        buffer.method_10804(((ProcessingRecipe)recipe).getProcessingDuration());
        buffer.method_10804(((ProcessingRecipe)recipe).getRequiredHeat().ordinal());
        ((ProcessingRecipe)recipe).writeAdditional(buffer);
    }

    protected T readFromBuffer(class_2960 recipeId, class_2540 buffer) {
        int i;
        class_2371 ingredients = class_2371.method_10211();
        class_2371 fluidIngredients = class_2371.method_10211();
        class_2371 results = class_2371.method_10211();
        class_2371 fluidResults = class_2371.method_10211();
        int size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            ingredients.add((Object)class_1856.method_8086((class_2540)buffer));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            fluidIngredients.add((Object)FluidIngredient.read(buffer));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            results.add((Object)ProcessingOutput.read(buffer));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            fluidResults.add((Object)FluidStack.fromBuffer((class_2540)buffer));
        }
        T recipe = new ProcessingRecipeBuilder<T>(this.factory, recipeId).withItemIngredients((class_2371<class_1856>)ingredients).withItemOutputs((class_2371<ProcessingOutput>)results).withFluidIngredients((class_2371<FluidIngredient>)fluidIngredients).withFluidOutputs((class_2371<FluidStack>)fluidResults).duration(buffer.method_10816()).requiresHeat(HeatCondition.values()[buffer.method_10816()]).build();
        ((ProcessingRecipe)recipe).readAdditional(buffer);
        return recipe;
    }

    public final void write(JsonObject json, T recipe) {
        this.writeToJson(json, recipe);
    }

    public final T fromJson(class_2960 id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(class_2540 buffer, T recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final T fromNetwork(class_2960 id, class_2540 buffer) {
        return this.readFromBuffer(id, buffer);
    }

    public ProcessingRecipeBuilder.ProcessingRecipeFactory<T> getFactory() {
        return this.factory;
    }
}

