/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.diodes;

import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.content.redstone.diodes.BrassDiodeScrollSlot;
import com.simibubi.create.content.redstone.diodes.BrassDiodeScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public abstract class BrassDiodeBlockEntity
extends SmartBlockEntity
implements ClipboardCloneable {
    protected int state;
    ScrollValueBehaviour maxState;

    public BrassDiodeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.maxState = new BrassDiodeScrollValueBehaviour((class_2561)Lang.translateDirect("logistics.redstone_interval", new Object[0]), this, new BrassDiodeScrollSlot()).between(2, 72000);
        this.maxState.withFormatter(this::format);
        this.maxState.withCallback(this::onMaxDelayChanged);
        this.maxState.setValue(2);
        behaviours.add(this.maxState);
    }

    public float getProgress() {
        int max = Math.max(2, this.maxState.getValue());
        return (float)class_3532.method_15340((int)this.state, (int)0, (int)max) / (float)max;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = (Boolean)this.method_11010().method_11654((class_2769)class_2312.field_10911);
        boolean powering = (Boolean)this.method_11010().method_11654((class_2769)BrassDiodeBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean var1, boolean var2, boolean var3, boolean var4);

    private void onMaxDelayChanged(int newMax) {
        this.state = class_3532.method_15340((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.state = compound.method_10550("State");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("State", this.state);
        super.write(compound, clientPacket);
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    @Override
    public String getClipboardKey() {
        return "Block";
    }

    @Override
    public boolean readFromClipboard(class_2487 tag, class_1657 player, class_2350 side, boolean simulate) {
        if (!tag.method_10545("Inverted")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        class_2680 blockState = this.method_11010();
        if (((Boolean)blockState.method_11654((class_2769)BrassDiodeBlock.INVERTED)).booleanValue() != tag.method_10577("Inverted")) {
            this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)BrassDiodeBlock.INVERTED));
        }
        return true;
    }

    @Override
    public boolean writeToClipboard(class_2487 tag, class_2350 side) {
        tag.method_10556("Inverted", this.method_11010().method_28500((class_2769)BrassDiodeBlock.INVERTED).orElse(false).booleanValue());
        return true;
    }
}

