/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.mojang.logging.LogUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.SchematicProcessor;
import com.simibubi.create.content.schematics.client.SchematicEditScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import org.slf4j.Logger;

public class SchematicItem
extends class_1792 {
    private static final Logger LOGGER = LogUtils.getLogger();

    public SchematicItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static class_1799 create(String schematic, String owner) {
        class_1799 blueprint = AllItems.SCHEMATIC.asStack();
        class_2487 tag = new class_2487();
        tag.method_10556("Deployed", false);
        tag.method_10582("Owner", owner);
        tag.method_10582("File", schematic);
        tag.method_10566("Anchor", (class_2520)class_2512.method_10692((class_2338)class_2338.field_10980));
        tag.method_10582("Rotation", class_2470.field_11467.name());
        tag.method_10582("Mirror", class_2415.field_11302.name());
        blueprint.method_7980(tag);
        SchematicItem.writeSize(blueprint);
        return blueprint;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_7985()) {
            if (stack.method_7969().method_10545("File")) {
                tooltip.add((class_2561)Components.literal(class_124.field_1065 + stack.method_7969().method_10558("File")));
            }
        } else {
            tooltip.add((class_2561)Lang.translateDirect("schematic.invalid", new Object[0]).method_27692(class_124.field_1061));
        }
        super.method_7851(stack, worldIn, tooltip, flagIn);
    }

    public static void writeSize(class_1799 blueprint) {
        class_2487 tag = blueprint.method_7969();
        class_3499 t = SchematicItem.loadSchematic(blueprint);
        tag.method_10566("Bounds", (class_2520)NBTHelper.writeVec3i(t.method_15160()));
        blueprint.method_7980(tag);
        SchematicInstances.clearHash(blueprint);
    }

    public static class_3492 getSettings(class_1799 blueprint) {
        return SchematicItem.getSettings(blueprint, true);
    }

    public static class_3492 getSettings(class_1799 blueprint, boolean processNBT) {
        class_2487 tag = blueprint.method_7969();
        class_3492 settings = new class_3492();
        settings.method_15123(class_2470.valueOf((String)tag.method_10558("Rotation")));
        settings.method_15125(class_2415.valueOf((String)tag.method_10558("Mirror")));
        if (processNBT) {
            settings.method_16184((class_3491)SchematicProcessor.INSTANCE);
        }
        return settings;
    }

    public static class_3499 loadSchematic(class_1799 blueprint) {
        Path file;
        Path dir;
        class_3499 t = new class_3499();
        String owner = blueprint.method_7969().method_10558("Owner");
        String schematic = blueprint.method_7969().method_10558("File");
        if (!schematic.endsWith(".nbt")) {
            return t;
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            dir = Paths.get("schematics", "uploaded").toAbsolutePath();
            file = Paths.get(owner, schematic);
        } else {
            dir = Paths.get("schematics", new String[0]).toAbsolutePath();
            file = Paths.get(schematic, new String[0]);
        }
        Path path = dir.resolve(file).normalize();
        if (!path.startsWith(dir)) {
            return t;
        }
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, StandardOpenOption.READ))));){
            class_2487 nbt = class_2507.method_10625((DataInput)stream, (class_2505)new class_2505(0x20000000L));
            t.method_15183(nbt);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read schematic", (Throwable)e);
        }
        return t;
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && !this.onItemUse(context.method_8036(), context.method_20287())) {
            return super.method_7884(context);
        }
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (!this.onItemUse(playerIn, handIn)) {
            return super.method_7836(worldIn, playerIn, handIn);
        }
        return new class_1271(class_1269.field_5812, (Object)playerIn.method_5998(handIn));
    }

    private boolean onItemUse(class_1657 player, class_1268 hand) {
        if (!player.method_5715() || hand != class_1268.field_5808) {
            return false;
        }
        if (!player.method_5998(hand).method_7985()) {
            return false;
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::displayBlueprintScreen);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    protected void displayBlueprintScreen() {
        ScreenOpener.open(new SchematicEditScreen());
    }
}

