/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class TrainHUDUpdatePacket
extends SimplePacketBase {
    UUID trainId;
    Double throttle;
    double speed;
    int fuelTicks;

    public TrainHUDUpdatePacket() {
    }

    public TrainHUDUpdatePacket(Train train) {
        this.trainId = train.id;
        this.throttle = train.throttle;
        this.speed = train.speedBeforeStall == null ? train.speed : train.speedBeforeStall;
        this.fuelTicks = train.fuelTicks;
    }

    public TrainHUDUpdatePacket(class_2540 buffer) {
        this.trainId = buffer.method_10790();
        if (buffer.readBoolean()) {
            this.throttle = buffer.readDouble();
        }
        this.speed = buffer.readDouble();
        this.fuelTicks = buffer.readInt();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.trainId);
        buffer.writeBoolean(this.throttle != null);
        if (this.throttle != null) {
            buffer.writeDouble(this.throttle.doubleValue());
        }
        buffer.writeDouble(this.speed);
        buffer.writeInt(this.fuelTicks);
    }

    @Override
    public boolean handle(SimplePacketBase.Context context) {
        context.enqueueWork(() -> {
            class_3222 sender = context.getSender();
            boolean clientSide = sender == null;
            Train train = Create.RAILWAYS.sided((class_1936)(clientSide ? null : sender.field_6002)).trains.get(this.trainId);
            if (train == null) {
                return;
            }
            if (this.throttle != null) {
                train.throttle = this.throttle;
            }
            if (clientSide) {
                train.speed = this.speed;
                train.fuelTicks = this.fuelTicks;
            }
        });
        return true;
    }

    public static class Serverbound
    extends TrainHUDUpdatePacket {
        public Serverbound(class_2540 buffer) {
            super(buffer);
        }

        public Serverbound(Train train, Double sendThrottle) {
            this.trainId = train.id;
            this.throttle = sendThrottle;
        }
    }
}

