/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.AssemblyScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationEditPacket;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.content.trains.station.WideIconButton;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StationScreen
extends AbstractStationScreen {
    private class_342 nameBox;
    private class_342 trainNameBox;
    private IconButton newTrainButton;
    private IconButton disassembleTrainButton;
    private IconButton dropScheduleButton;
    private int leavingAnimation;
    private LerpedFloat trainPosition;
    private DoorControl doorControl;
    private boolean switchingToAssemblyMode;

    public StationScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION;
        this.leavingAnimation = 0;
        this.trainPosition = LerpedFloat.linear().startWithValue(0.0);
        this.switchingToAssemblyMode = false;
        this.doorControl = be.doorControls.mode;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        Consumer<String> onTextChanged = s -> {
            this.nameBox.field_22760 = this.nameBoxX((String)s, this.nameBox);
        };
        this.nameBox = new class_342((class_327)new NoShadowFontWrapper(this.field_22793), x + 23, y + 4, this.background.width - 20, 10, (class_2561)Components.literal(this.station.name));
        this.nameBox.method_1858(false);
        this.nameBox.method_1880(25);
        this.nameBox.method_1868(5841956);
        this.nameBox.method_1852(this.station.name);
        this.nameBox.method_25407(false);
        this.nameBox.method_25402(0.0, 0.0, 0);
        this.nameBox.method_1863(onTextChanged);
        this.nameBox.field_22760 = this.nameBoxX(this.nameBox.method_1882(), this.nameBox);
        this.method_37063((class_364)this.nameBox);
        Runnable assemblyCallback = () -> {
            this.switchingToAssemblyMode = true;
            this.field_22787.method_1507((class_437)new AssemblyScreen(this.blockEntity, this.station));
        };
        this.newTrainButton = new WideIconButton(x + 84, y + 65, AllGuiTextures.I_NEW_TRAIN);
        this.newTrainButton.withCallback(assemblyCallback);
        this.method_37063(this.newTrainButton);
        this.disassembleTrainButton = new WideIconButton(x + 94, y + 65, AllGuiTextures.I_DISASSEMBLE_TRAIN);
        this.disassembleTrainButton.field_22763 = false;
        this.disassembleTrainButton.field_22764 = false;
        this.disassembleTrainButton.withCallback(assemblyCallback);
        this.method_37063(this.disassembleTrainButton);
        this.dropScheduleButton = new IconButton(x + 73, y + 65, AllIcons.I_VIEW_SCHEDULE);
        this.dropScheduleButton.field_22763 = false;
        this.dropScheduleButton.field_22764 = false;
        this.dropScheduleButton.withCallback(() -> AllPackets.getChannel().sendToServer((C2SPacket)StationEditPacket.dropSchedule(this.blockEntity.method_11016())));
        this.method_37063(this.dropScheduleButton);
        onTextChanged = s -> {
            this.trainNameBox.field_22760 = this.nameBoxX((String)s, this.trainNameBox);
        };
        this.trainNameBox = new class_342(this.field_22793, x + 23, y + 47, this.background.width - 75, 10, Components.immutableEmpty());
        this.trainNameBox.method_1858(false);
        this.trainNameBox.method_1880(35);
        this.trainNameBox.method_1868(0xC6C6C6);
        this.trainNameBox.method_25407(false);
        this.trainNameBox.method_25402(0.0, 0.0, 0);
        this.trainNameBox.method_1863(onTextChanged);
        this.trainNameBox.field_22763 = false;
        this.tickTrainDisplay();
        Pair<ScrollInput, Label> doorControlWidgets = DoorControl.createWidget(x + 35, y + 102, mode -> {
            this.doorControl = mode;
        }, this.doorControl);
        this.method_37063(doorControlWidgets.getFirst());
        this.method_37063(doorControlWidgets.getSecond());
    }

    @Override
    public void method_25393() {
        this.tickTrainDisplay();
        if (this.method_25399() != this.nameBox) {
            this.nameBox.method_1875(this.nameBox.method_1882().length());
            this.nameBox.method_1884(this.nameBox.method_1881());
        }
        if (this.method_25399() != this.trainNameBox || !this.trainNameBox.field_22763) {
            this.trainNameBox.method_1875(this.trainNameBox.method_1882().length());
            this.trainNameBox.method_1884(this.trainNameBox.method_1881());
        }
        super.method_25393();
        this.updateAssemblyTooltip(this.blockEntity.edgePoint.isOnCurve() ? "no_assembly_curve" : (!this.blockEntity.edgePoint.isOrthogonal() ? "no_assembly_diagonal" : (this.trainPresent() && !this.blockEntity.trainCanDisassemble ? "train_not_aligned" : null)));
    }

    private void tickTrainDisplay() {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            if (this.trainNameBox.field_22763) {
                this.trainNameBox.field_22763 = false;
                this.method_37066((class_364)this.trainNameBox);
            }
            this.leavingAnimation = 0;
            this.newTrainButton.field_22763 = this.blockEntity.edgePoint.isOrthogonal();
            this.newTrainButton.field_22764 = true;
            Train imminentTrain = this.getImminent();
            if (imminentTrain != null) {
                this.displayedTrain = new WeakReference<Train>(imminentTrain);
                this.newTrainButton.field_22763 = false;
                this.newTrainButton.field_22764 = false;
                this.disassembleTrainButton.field_22763 = false;
                this.disassembleTrainButton.field_22764 = true;
                this.dropScheduleButton.field_22763 = this.blockEntity.trainHasSchedule;
                this.dropScheduleButton.field_22764 = true;
                this.trainNameBox.field_22763 = true;
                this.trainNameBox.method_1852(imminentTrain.name.getString());
                this.trainNameBox.field_22760 = this.nameBoxX(this.trainNameBox.method_1882(), this.trainNameBox);
                this.method_37063((class_364)this.trainNameBox);
                int trainIconWidth = this.getTrainIconWidth(imminentTrain);
                int targetPos = this.background.width / 2 - trainIconWidth / 2;
                if (trainIconWidth > 130) {
                    targetPos -= trainIconWidth - 130;
                }
                float f = (float)(imminentTrain.navigation.distanceToDestination / 15.0);
                if (this.trainPresent()) {
                    f = 0.0f;
                }
                this.trainPosition.startWithValue((float)targetPos - (float)(targetPos + 5) * f);
            }
            return;
        }
        int trainIconWidth = this.getTrainIconWidth(train);
        int targetPos = this.background.width / 2 - trainIconWidth / 2;
        if (trainIconWidth > 130) {
            targetPos -= trainIconWidth - 130;
        }
        if (this.leavingAnimation > 0) {
            this.disassembleTrainButton.field_22763 = false;
            float f = 1.0f - (float)this.leavingAnimation / 80.0f;
            this.trainPosition.setValue((float)targetPos + f * f * f * (float)(this.background.width - targetPos + 5));
            --this.leavingAnimation;
            if (this.leavingAnimation > 0) {
                return;
            }
            this.displayedTrain = new WeakReference<Object>(null);
            this.disassembleTrainButton.field_22764 = false;
            this.dropScheduleButton.field_22763 = false;
            this.dropScheduleButton.field_22764 = false;
            return;
        }
        if (this.getImminent() != train) {
            this.leavingAnimation = 80;
            return;
        }
        boolean trainAtStation = this.trainPresent();
        this.disassembleTrainButton.field_22763 = trainAtStation && this.blockEntity.trainCanDisassemble && this.blockEntity.edgePoint.isOrthogonal();
        this.dropScheduleButton.field_22763 = this.blockEntity.trainHasSchedule;
        if (this.blockEntity.trainHasSchedule) {
            this.dropScheduleButton.setToolTip((class_2561)Lang.translateDirect(this.blockEntity.trainHasAutoSchedule ? "station.remove_auto_schedule" : "station.remove_schedule", new Object[0]));
        } else {
            this.dropScheduleButton.getToolTip().clear();
        }
        float f = trainAtStation ? 0.0f : (float)(train.navigation.distanceToDestination / 30.0);
        this.trainPosition.setValue((float)targetPos - (float)(targetPos + trainIconWidth) * f);
    }

    private int nameBoxX(String s, class_342 nameBox) {
        return this.guiLeft + this.background.width / 2 - (Math.min(this.field_22793.method_1727(s), nameBox.method_25368()) + 10) / 2;
    }

    private void updateAssemblyTooltip(String key) {
        if (key == null) {
            this.disassembleTrainButton.setToolTip((class_2561)Lang.translateDirect("station.disassemble_train", new Object[0]));
            this.newTrainButton.setToolTip((class_2561)Lang.translateDirect("station.create_train", new Object[0]));
            return;
        }
        for (IconButton ib : new IconButton[]{this.disassembleTrainButton, this.newTrainButton}) {
            List<class_2561> toolTip = ib.getToolTip();
            toolTip.clear();
            toolTip.add((class_2561)Lang.translateDirect("station." + key, new Object[0]).method_27692(class_124.field_1080));
            toolTip.add((class_2561)Lang.translateDirect("station." + key + "_1", new Object[0]).method_27692(class_124.field_1080));
        }
    }

    @Override
    protected void renderWindow(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(ms, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        String text = this.nameBox.method_1882();
        if (!this.nameBox.method_25370()) {
            AllGuiTextures.STATION_EDIT_NAME.render(ms, this.nameBoxX(text, this.nameBox) + this.field_22793.method_1727(text) + 5, y + 1);
        }
        this.field_22788.method_4010(AllBlocks.TRAIN_DOOR.asStack(), x + 14, y + 103);
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            class_5250 header = Lang.translateDirect("station.idle", new Object[0]);
            this.field_22793.method_30883(ms, (class_2561)header, (float)(x + 97 - this.field_22793.method_27525((class_5348)header) / 2), (float)(y + 47), 0x7A7A7A);
            return;
        }
        float position = this.trainPosition.getValue(partialTicks);
        ms.method_22903();
        RenderSystem.enableBlend();
        ms.method_22904((double)position, 0.0, 0.0);
        TrainIconType icon = train.icon;
        int offset = 0;
        List<Carriage> carriages = train.carriages;
        for (int i = carriages.size() - 1; i > 0; --i) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, Math.min((position + (float)offset - 10.0f) / 30.0f, ((float)(this.background.width - 40) - position - (float)offset) / 30.0f)));
            Carriage carriage = carriages.get(this.blockEntity.trainBackwards ? carriages.size() - i - 1 : i);
            offset += icon.render(carriage.bogeySpacing, ms, x + offset, y + 20) + 1;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, Math.min((position + (float)offset - 10.0f) / 30.0f, ((float)(this.background.width - 40) - position - (float)offset) / 30.0f)));
        offset += icon.render(-1, ms, x + offset, y + 20);
        RenderSystem.disableBlend();
        ms.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AllGuiTextures.STATION_TEXTBOX_TOP.render(ms, x + 21, y + 42);
        UIRenderHelper.drawStretched(ms, x + 21, y + 60, 150, 26, 0, AllGuiTextures.STATION_TEXTBOX_MIDDLE);
        AllGuiTextures.STATION_TEXTBOX_BOTTOM.render(ms, x + 21, y + 86);
        ms.method_22903();
        ms.method_22904((double)class_3532.method_15363((float)(position + (float)offset - 13.0f), (float)25.0f, (float)159.0f), 0.0, 0.0);
        AllGuiTextures.STATION_TEXTBOX_SPEECH.render(ms, x, y + 38);
        ms.method_22909();
        text = this.trainNameBox.method_1882();
        if (!this.trainNameBox.method_25370()) {
            int buttonX = this.nameBoxX(text, this.trainNameBox) + this.field_22793.method_1727(text) + 5;
            AllGuiTextures.STATION_EDIT_TRAIN_NAME.render(ms, Math.min(buttonX, this.guiLeft + 156), y + 44);
            if (this.field_22793.method_1727(text) > this.trainNameBox.method_25368()) {
                this.field_22793.method_1720(ms, "...", (float)(this.guiLeft + 26), (float)(this.guiTop + 47), 0xA6A6A6);
            }
        }
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (!this.nameBox.method_25370() && pMouseY > (double)this.guiTop && pMouseY < (double)(this.guiTop + 14) && pMouseX > (double)this.guiLeft && pMouseX < (double)(this.guiLeft + this.background.width)) {
            this.nameBox.method_1876(true);
            this.nameBox.method_1884(0);
            this.method_25395((class_364)this.nameBox);
            return true;
        }
        if (this.trainNameBox.field_22763 && !this.trainNameBox.method_25370() && pMouseY > (double)(this.guiTop + 45) && pMouseY < (double)(this.guiTop + 58) && pMouseX > (double)(this.guiLeft + 25) && pMouseX < (double)(this.guiLeft + 168)) {
            this.trainNameBox.method_1876(true);
            this.trainNameBox.method_1884(0);
            this.method_25395((class_364)this.trainNameBox);
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.method_25399() instanceof class_342 && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.method_25370()) {
            this.nameBox.method_1876(false);
            this.syncStationName();
            return true;
        }
        if (hitEnter && this.trainNameBox.method_25370()) {
            this.trainNameBox.method_1876(false);
            this.syncTrainName();
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    private void syncTrainName() {
        Train train = (Train)this.displayedTrain.get();
        if (train != null && !this.trainNameBox.method_1882().equals(train.name.getString())) {
            AllPackets.getChannel().sendToServer((C2SPacket)new TrainEditPacket(train.id, this.trainNameBox.method_1882(), train.icon.getId()));
        }
    }

    private void syncStationName() {
        if (!this.nameBox.method_1882().equals(this.station.name)) {
            AllPackets.getChannel().sendToServer((C2SPacket)StationEditPacket.configure(this.blockEntity.method_11016(), false, this.nameBox.method_1882(), this.doorControl));
        }
    }

    public void method_25432() {
        super.method_25432();
        if (this.nameBox == null || this.trainNameBox == null) {
            return;
        }
        AllPackets.getChannel().sendToServer((C2SPacket)StationEditPacket.configure(this.blockEntity.method_11016(), this.switchingToAssemblyMode, this.nameBox.method_1882(), this.doorControl));
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            return;
        }
        if (!this.switchingToAssemblyMode) {
            AllPackets.getChannel().sendToServer((C2SPacket)new TrainEditPacket(train.id, this.trainNameBox.method_1882(), train.icon.getId()));
        } else {
            this.blockEntity.imminentTrain = null;
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return this.blockEntity.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF;
    }
}

