/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.extensions.ITeleporter;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class AllPortalTracks {
    private static final AttachedRegistry<class_2248, PortalTrackProvider> PORTAL_BEHAVIOURS = new AttachedRegistry(class_2378.field_11146);

    public static void registerIntegration(class_2960 block, PortalTrackProvider provider) {
        PORTAL_BEHAVIOURS.register((class_2248)block, provider);
    }

    public static void registerIntegration(class_2248 block, PortalTrackProvider provider) {
        PORTAL_BEHAVIOURS.register(block, provider);
    }

    public static boolean isSupportedPortal(class_2680 state) {
        return PORTAL_BEHAVIOURS.get(state.method_26204()) != null;
    }

    public static Pair<class_3218, BlockFace> getOtherSide(class_3218 level, BlockFace inboundTrack) {
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        PortalTrackProvider provider = PORTAL_BEHAVIOURS.get(portalState.method_26204());
        return provider == null ? null : (Pair)provider.apply(Pair.of(level, inboundTrack));
    }

    public static void registerDefaults() {
        AllPortalTracks.registerIntegration(class_2246.field_10316, AllPortalTracks::nether);
        if (Mods.AETHER.isLoaded()) {
            AllPortalTracks.registerIntegration(new class_2960("aether", "aether_portal"), AllPortalTracks::aether);
        }
    }

    private static Pair<class_3218, BlockFace> nether(Pair<class_3218, BlockFace> inbound) {
        return AllPortalTracks.standardPortalProvider(inbound, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)class_1937.field_25180, AllPortalTracks::getTeleporter);
    }

    private static Pair<class_3218, BlockFace> aether(Pair<class_3218, BlockFace> inbound) {
        class_5321 aetherLevelKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("aether", "the_aether"));
        return AllPortalTracks.standardPortalProvider(inbound, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)aetherLevelKey, level -> {
            try {
                return (ITeleporter)Class.forName("com.aetherteam.aether.block.portal.AetherPortalForcer").getDeclaredConstructor(class_3218.class, Boolean.TYPE).newInstance(level, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return AllPortalTracks.getTeleporter(level);
            }
        });
    }

    private static ITeleporter getTeleporter(class_3218 level) {
        return (ITeleporter)level.method_14173();
    }

    public static Pair<class_3218, BlockFace> standardPortalProvider(Pair<class_3218, BlockFace> inbound, class_5321<class_1937> firstDimension, class_5321<class_1937> secondDimension, Function<class_3218, ITeleporter> customPortalForcer) {
        class_3218 level = inbound.getFirst();
        class_5321<class_1937> resourcekey = level.method_27983() == secondDimension ? firstDimension : secondDimension;
        MinecraftServer minecraftserver = level.method_8503();
        class_3218 otherLevel = minecraftserver.method_3847(resourcekey);
        if (otherLevel == null || !minecraftserver.method_3839()) {
            return null;
        }
        BlockFace inboundTrack = inbound.getSecond();
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        ITeleporter teleporter = customPortalForcer.apply(otherLevel);
        SuperGlueEntity probe = new SuperGlueEntity((class_1937)level, new class_238(portalPos));
        probe.method_36456(inboundTrack.getFace().method_10144());
        probe.setPortalEntrancePos();
        class_5454 portalinfo = teleporter.getPortalInfo((class_1297)probe, otherLevel, probe::method_30329);
        if (portalinfo == null) {
            return null;
        }
        class_2338 otherPortalPos = new class_2338(portalinfo.field_25879);
        class_2680 otherPortalState = otherLevel.method_8320(otherPortalPos);
        if (otherPortalState.method_26204() != portalState.method_26204()) {
            return null;
        }
        class_2350 targetDirection = inboundTrack.getFace();
        if (targetDirection.method_10166() == otherPortalState.method_11654((class_2769)class_2741.field_12529)) {
            targetDirection = targetDirection.method_10170();
        }
        class_2338 otherPos = otherPortalPos.method_10093(targetDirection);
        return Pair.of(otherLevel, new BlockFace(otherPos, targetDirection.method_10153()));
    }

    @FunctionalInterface
    public static interface PortalTrackProvider
    extends UnaryOperator<Pair<class_3218, BlockFace>> {
    }
}

