/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigModListScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.SubMenuConfigScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.element.TextStencilElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class BaseConfigScreen
extends ConfigScreen {
    public static final DelegatedStencilElement.ElementRenderer DISABLED_RENDERER = (ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, Theme.p(Theme.Key.BUTTON_DISABLE));
    private static final Map<String, UnaryOperator<BaseConfigScreen>> DEFAULTS = new HashMap<String, UnaryOperator<BaseConfigScreen>>();
    protected BoxWidget clientConfigWidget;
    protected BoxWidget commonConfigWidget;
    protected BoxWidget serverConfigWidget;
    protected BoxWidget goBack;
    protected BoxWidget others;
    protected BoxWidget title;
    protected ForgeConfigSpec clientSpec;
    protected ForgeConfigSpec commonSpec;
    protected ForgeConfigSpec serverSpec;
    protected String clientTitle = "Client Config";
    protected String commonTitle = "Common Config";
    protected String serverTitle = "Server Config";
    protected String modID;
    protected boolean returnOnClose;

    public static void setDefaultActionFor(String modID, UnaryOperator<BaseConfigScreen> transform) {
        if (modID.equals("create")) {
            return;
        }
        DEFAULTS.put(modID, transform);
    }

    public static BaseConfigScreen forCreate(class_437 parent) {
        return new BaseConfigScreen(parent);
    }

    public BaseConfigScreen(class_437 parent, @Nonnull String modID) {
        super(parent);
        this.modID = modID;
        if (DEFAULTS.containsKey(modID)) {
            DEFAULTS.get(modID).apply(this);
        } else {
            this.searchForSpecsInModContainer();
        }
    }

    private BaseConfigScreen(class_437 parent) {
        this(parent, "create");
    }

    public BaseConfigScreen searchForSpecsInModContainer() {
        if (!ConfigHelper.hasAnyForgeConfig(this.modID)) {
            return this;
        }
        try {
            this.clientSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.CLIENT, this.modID);
        }
        catch (Exception e) {
            Create.LOGGER.debug("Unable to find ClientConfigSpec for mod: " + this.modID);
        }
        try {
            this.commonSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.COMMON, this.modID);
        }
        catch (Exception e) {
            Create.LOGGER.debug("Unable to find CommonConfigSpec for mod: " + this.modID);
        }
        try {
            this.serverSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.SERVER, this.modID);
        }
        catch (Exception e) {
            Create.LOGGER.debug("Unable to find ServerConfigSpec for mod: " + this.modID);
        }
        return this;
    }

    public BaseConfigScreen withSpecs(@Nullable ForgeConfigSpec client, @Nullable ForgeConfigSpec common, @Nullable ForgeConfigSpec server) {
        this.clientSpec = client;
        this.commonSpec = common;
        this.serverSpec = server;
        return this;
    }

    public BaseConfigScreen withTitles(@Nullable String client, @Nullable String common, @Nullable String server) {
        if (client != null) {
            this.clientTitle = client;
        }
        if (common != null) {
            this.commonTitle = common;
        }
        if (server != null) {
            this.serverTitle = server;
        }
        return this;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.returnOnClose = true;
        TextStencilElement clientText = new TextStencilElement(this.field_22793, Components.literal(this.clientTitle)).centered(true, true);
        this.clientConfigWidget = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15 - 30, 200, 16).showingElement(clientText);
        this.method_37063(this.clientConfigWidget);
        if (this.clientSpec != null) {
            this.clientConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.CLIENT, this.clientSpec)));
            clientText.withElementRenderer(BoxWidget.gradientFactory.apply(this.clientConfigWidget));
        } else {
            this.clientConfigWidget.field_22763 = false;
            this.clientConfigWidget.updateColorsFromState();
            clientText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement commonText = new TextStencilElement(this.field_22793, Components.literal(this.commonTitle)).centered(true, true);
        this.commonConfigWidget = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15, 200, 16).showingElement(commonText);
        this.method_37063(this.commonConfigWidget);
        if (this.commonSpec != null) {
            this.commonConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.COMMON, this.commonSpec)));
            commonText.withElementRenderer(BoxWidget.gradientFactory.apply(this.commonConfigWidget));
        } else {
            this.commonConfigWidget.field_22763 = false;
            this.commonConfigWidget.updateColorsFromState();
            commonText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement serverText = new TextStencilElement(this.field_22793, Components.literal(this.serverTitle)).centered(true, true);
        this.serverConfigWidget = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15 + 30, 200, 16).showingElement(serverText);
        this.method_37063(this.serverConfigWidget);
        if (this.serverSpec == null) {
            this.serverConfigWidget.field_22763 = false;
            this.serverConfigWidget.updateColorsFromState();
            serverText.withElementRenderer(DISABLED_RENDERER);
        } else if (this.field_22787.field_1687 == null) {
            serverText.withElementRenderer(DISABLED_RENDERER);
            this.serverConfigWidget.getToolTip().add((class_2561)Components.literal("Stored individually per World"));
            this.serverConfigWidget.getToolTip().addAll(TooltipHelper.cutTextComponent((class_2561)Components.literal("Gameplay settings can only be accessed from the in-game menu after joining a World or Server."), TooltipHelper.Palette.ALL_GRAY));
        } else {
            this.serverConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.SERVER, this.serverSpec)));
            serverText.withElementRenderer(BoxWidget.gradientFactory.apply(this.serverConfigWidget));
        }
        TextStencilElement titleText = (TextStencilElement)new TextStencilElement(this.field_22793, this.modID.toUpperCase(Locale.ROOT)).centered(true, true).withElementRenderer((ms, w, h, alpha) -> {
            UIRenderHelper.angledGradient(ms, 0.0f, 0, h / 2, h, w / 2, Theme.p(Theme.Key.CONFIG_TITLE_A));
            UIRenderHelper.angledGradient(ms, 0.0f, w / 2, h / 2, h, w / 2, Theme.p(Theme.Key.CONFIG_TITLE_B));
        });
        int boxWidth = this.field_22789 + 10;
        int boxHeight = 39;
        int boxPadding = 4;
        this.title = (BoxWidget)((ElementWidget)((ElementWidget)((ElementWidget)new BoxWidget(-5, this.field_22790 / 2 - 110, boxWidth, boxHeight).withBorderColors(Theme.p(Theme.Key.BUTTON_IDLE))).withPadding(0.0f, boxPadding)).rescaleElement((float)boxWidth / 2.0f, (float)(boxHeight - 2 * boxPadding) / 2.0f)).showingElement((RenderElement)titleText.at(0.0f, 7.0f));
        this.title.field_22763 = false;
        this.method_37063(this.title);
        ConfigScreen.modID = this.modID;
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.field_22789 / 2 - 134, this.field_22790 / 2, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.linkTo(this.parent));
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((class_2561)Components.literal("Go Back"));
        this.method_37063(this.goBack);
        TextStencilElement othersText = new TextStencilElement(this.field_22793, Components.literal("Access Configs of other Mods")).centered(true, true);
        this.others = (BoxWidget)new BoxWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 15 + 90, 200, 16).showingElement(othersText);
        othersText.withElementRenderer(BoxWidget.gradientFactory.apply(this.others));
        this.others.withCallback(() -> this.linkTo(new ConfigModListScreen(this)));
        this.method_37063(this.others);
    }

    @Override
    protected void renderWindow(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        BaseConfigScreen.method_25300((class_4587)ms, (class_327)this.field_22793, (String)"Access Configs for Mod:", (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 - 105), (int)Theme.i(Theme.Key.TEXT_ACCENT_STRONG));
    }

    protected void linkTo(class_437 screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            this.linkTo(this.parent);
        }
        return false;
    }

    static {
        DEFAULTS.put("create", base -> base.withTitles("Client Settings", "World Generation Settings", "Gameplay Settings").withSpecs(AllConfigs.client().specification, AllConfigs.common().specification, AllConfigs.server().specification));
    }
}

