/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import io.github.fabricators_of_create.porting_lib.extensions.INBTSerializable;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;

public class SmartInventory
extends ItemStackHandlerContainer
implements INBTSerializable<class_2487> {
    protected boolean extractionAllowed;
    protected boolean insertionAllowed;
    protected boolean stackNonStackables;
    protected int stackSize;
    private SyncedBlockEntity blockEntity;
    private Runnable updateCallback;

    public SmartInventory(int slots, SyncedBlockEntity be) {
        this(slots, be, 64, false);
    }

    public SmartInventory(int slots, SyncedBlockEntity be, int stackSize, boolean stackNonStackables) {
        super(slots);
        this.stackNonStackables = stackNonStackables;
        this.insertionAllowed = true;
        this.extractionAllowed = true;
        this.stackSize = stackSize;
        this.blockEntity = be;
    }

    public SmartInventory withMaxStackSize(int maxStackSize) {
        this.stackSize = maxStackSize;
        return this;
    }

    public SmartInventory whenContentsChanged(Runnable updateCallback) {
        this.updateCallback = updateCallback;
        return this;
    }

    public SmartInventory allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    public SmartInventory allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    public SmartInventory forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    public SmartInventory forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.insertionAllowed) {
            return 0L;
        }
        return super.insert(resource, maxAmount, transaction);
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.extractionAllowed) {
            return 0L;
        }
        if (this.stackNonStackables) {
            try (Transaction t = transaction.openNested();){
                long extracted = super.extract(resource, maxAmount, (TransactionContext)t);
                t.abort();
                if (extracted != 0L && (long)resource.getItem().method_7882() < extracted) {
                    maxAmount = resource.getItem().method_7882();
                }
            }
        }
        return super.extract(resource, maxAmount, transaction);
    }

    protected void onFinalCommit() {
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
        this.blockEntity.notifyUpdate();
    }

    public int getSlotLimit(int slot) {
        return Math.min(this.stackNonStackables ? 64 : super.getSlotLimit(slot), this.stackSize);
    }

    public int method_5444() {
        return Math.min(64, this.stackSize);
    }
}

