/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.util.client.ScreenUtils;
import javax.annotation.Nonnull;
import net.minecraft.class_1144;
import net.minecraft.class_1159;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class PonderProgressBar
extends AbstractSimiWidget {
    LerpedFloat progress;
    PonderUI ponder;

    public PonderProgressBar(PonderUI ponder, int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.ponder = ponder;
        this.progress = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void tick() {
        this.progress.chase(this.ponder.getActiveScene().getSceneProgress(), 0.5, LerpedFloat.Chaser.EXP);
        this.progress.tickChaser();
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && this.ponder.getActiveScene().getKeyframeCount() > 0 && mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758 + 4) && mouseY >= (double)this.field_22761 - 3.0 && mouseY < (double)(this.field_22761 + this.field_22759 + 20);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int keyframeIndex = this.getHoveredKeyframeIndex(activeScene, mouseX);
        if (keyframeIndex == -1) {
            this.ponder.seekToTime(0);
        } else if (keyframeIndex == activeScene.getKeyframeCount()) {
            this.ponder.seekToTime(activeScene.getTotalTime());
        } else {
            this.ponder.seekToTime(activeScene.getKeyframeTime(keyframeIndex));
        }
    }

    public int getHoveredKeyframeIndex(PonderScene activeScene, double mouseX) {
        int keyframeTime;
        int totalTime = activeScene.getTotalTime();
        int clickedAtTime = (int)((mouseX - (double)this.field_22760) / ((double)this.field_22758 + 4.0) * (double)totalTime);
        int lastKeyframeTime = activeScene.getKeyframeTime(activeScene.getKeyframeCount() - 1);
        int diffToEnd = totalTime - clickedAtTime;
        int diffToLast = clickedAtTime - lastKeyframeTime;
        if (diffToEnd > 0 && diffToEnd < diffToLast / 2) {
            return activeScene.getKeyframeCount();
        }
        int index = -1;
        int i = 0;
        while (i < activeScene.getKeyframeCount() && (keyframeTime = activeScene.getKeyframeTime(i)) <= clickedAtTime) {
            index = i++;
        }
        return index;
    }

    @Override
    public void method_25359(@Nonnull class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        this.field_22762 = this.method_25361(mouseX, mouseY);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(this.field_22760, this.field_22761, 400.0f)).withBounds(this.field_22758, this.field_22759)).render(ms);
        ms.method_22903();
        ms.method_22904((double)(this.field_22760 - 2), (double)(this.field_22761 - 2), 100.0);
        ms.method_22903();
        ms.method_22905((float)(this.field_22758 + 4) * this.progress.getValue(partialTicks), 1.0f, 1.0f);
        int c1 = Theme.i(Theme.Key.PONDER_PROGRESSBAR, true);
        int c2 = Theme.i(Theme.Key.PONDER_PROGRESSBAR, false);
        ScreenUtils.drawGradientRect((class_1159)ms.method_23760().method_23761(), (int)310, (int)0, (int)3, (int)1, (int)4, (int)c1, (int)c1);
        ScreenUtils.drawGradientRect((class_1159)ms.method_23760().method_23761(), (int)310, (int)0, (int)4, (int)1, (int)5, (int)c2, (int)c2);
        ms.method_22909();
        this.renderKeyframes(ms, mouseX, partialTicks);
        ms.method_22909();
    }

    private void renderKeyframes(class_4587 ms, int mouseX, float partialTicks) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int hoverStartColor = Theme.i(Theme.Key.PONDER_HOVER, true) | 0xA0000000;
        int hoverEndColor = Theme.i(Theme.Key.PONDER_HOVER, false) | 0xA0000000;
        int idleStartColor = Theme.i(Theme.Key.PONDER_IDLE, true) | 0x40000000;
        int idleEndColor = Theme.i(Theme.Key.PONDER_IDLE, false) | 0x40000000;
        int hoverIndex = this.field_22762 ? this.getHoveredKeyframeIndex(activeScene, mouseX) : -2;
        if (hoverIndex == -1) {
            this.drawKeyframe(ms, activeScene, true, 0, 0, hoverStartColor, hoverEndColor, 8);
        } else if (hoverIndex == activeScene.getKeyframeCount()) {
            this.drawKeyframe(ms, activeScene, true, activeScene.getTotalTime(), this.field_22758 + 4, hoverStartColor, hoverEndColor, 8);
        }
        for (int i = 0; i < activeScene.getKeyframeCount(); ++i) {
            int keyframeTime = activeScene.getKeyframeTime(i);
            int keyframePos = (int)((float)keyframeTime / (float)activeScene.getTotalTime() * (float)(this.field_22758 + 4));
            boolean selected = i == hoverIndex;
            int startColor = selected ? hoverStartColor : idleStartColor;
            int endColor = selected ? hoverEndColor : idleEndColor;
            int height = selected ? 8 : 4;
            this.drawKeyframe(ms, activeScene, selected, keyframeTime, keyframePos, startColor, endColor, height);
        }
    }

    private void drawKeyframe(class_4587 ms, PonderScene activeScene, boolean selected, int keyframeTime, int keyframePos, int startColor, int endColor, int height) {
        if (selected) {
            int offset;
            String text;
            class_327 font = class_310.method_1551().field_1772;
            ScreenUtils.drawGradientRect((class_1159)ms.method_23760().method_23761(), (int)600, (int)keyframePos, (int)10, (int)(keyframePos + 1), (int)(10 + height), (int)endColor, (int)startColor);
            ms.method_22903();
            ms.method_22904(0.0, 0.0, 200.0);
            if (activeScene.getCurrentTime() < keyframeTime) {
                text = ">";
                offset = -1 - font.method_1727(text);
            } else {
                text = "<";
                offset = 3;
            }
            font.method_1729(ms, text, (float)(keyframePos + offset), 10.0f, endColor);
            ms.method_22909();
        }
        ScreenUtils.drawGradientRect((class_1159)ms.method_23760().method_23761(), (int)400, (int)keyframePos, (int)-1, (int)(keyframePos + 1), (int)(2 + height), (int)startColor, (int)endColor);
    }

    public void method_25354(class_1144 handler) {
    }
}

