/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest;

import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2633;
import net.minecraft.class_4516;
import net.minecraft.class_4525;
import net.minecraft.class_4529;
import net.minecraft.class_6302;
import org.jetbrains.annotations.NotNull;

public class CreateTestFunction
extends class_4529 {
    public static final Map<String, CreateTestFunction> NAMES_TO_FUNCTIONS = new HashMap<String, CreateTestFunction>();
    public final String fullName;
    public final String simpleName;

    protected CreateTestFunction(String fullName, String simpleName, String pBatchName, String pTestName, String pStructureName, class_2470 pRotation, int pMaxTicks, long pSetupTicks, boolean pRequired, int pRequiredSuccesses, int pMaxAttempts, Consumer<class_4516> pFunction) {
        super(pBatchName, pTestName, pStructureName, pRotation, pMaxTicks, pSetupTicks, pRequired, pRequiredSuccesses, pMaxAttempts, pFunction);
        this.fullName = fullName;
        this.simpleName = simpleName;
        NAMES_TO_FUNCTIONS.put(fullName, this);
    }

    public String method_22296() {
        return this.simpleName;
    }

    public static Collection<class_4529> getTestsFrom(Class<?> ... classes) {
        return Stream.of(classes).map(Class::getDeclaredMethods).flatMap(Stream::of).map(CreateTestFunction::of).filter(Objects::nonNull).sorted(Comparator.comparing(class_4529::method_22296)).toList();
    }

    @Nullable
    public static class_4529 of(Method method) {
        class_6302 gt = method.getAnnotation(class_6302.class);
        if (gt == null) {
            return null;
        }
        Class<?> owner = method.getDeclaringClass();
        GameTestGroup group = owner.getAnnotation(GameTestGroup.class);
        String simpleName = owner.getSimpleName() + "." + method.getName();
        CreateTestFunction.validateTestMethod(method, gt, owner, group, simpleName);
        String structure = "%s:gametest/%s/%s".formatted(group.namespace(), group.path(), gt.method_35936());
        class_2470 rotation = class_4525.method_29408((int)gt.method_35934());
        String fullName = owner.getName() + "." + method.getName();
        return new CreateTestFunction(fullName, simpleName, gt.method_35933(), structure, structure, rotation, gt.method_35932(), gt.method_35937(), gt.method_35935(), gt.method_35939(), gt.method_35938(), CreateTestFunction.asConsumer(method));
    }

    private static void validateTestMethod(Method method, class_6302 gt, Class<?> owner, GameTestGroup group, String simpleName) {
        if (gt.method_35936().isEmpty()) {
            throw new IllegalArgumentException(simpleName + " must provide a template structure");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(simpleName + " must be static");
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException(simpleName + " must return void");
        }
        if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != CreateGameTestHelper.class) {
            throw new IllegalArgumentException(simpleName + " must take 1 parameter of type CreateGameTestHelper");
        }
        if (group == null) {
            throw new IllegalArgumentException(owner.getName() + " must be annotated with @GameTestGroup");
        }
    }

    private static Consumer<class_4516> asConsumer(Method method) {
        return helper -> {
            try {
                method.invoke(null, helper);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void method_22297(@NotNull class_4516 helper) {
        class_2633 be = (class_2633)helper.method_36014(class_2338.field_10980);
        be.getExtraCustomData().method_10582("CreateTestFunction", this.fullName);
        super.method_22297((class_4516)CreateGameTestHelper.of(helper));
    }
}

