/*
 * Decompiled with CFR 0.152.
 */
package com.cupboard.config;

import com.cupboard.Cupboard;
import com.cupboard.config.ICommonConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class CupboardConfig<C extends ICommonConfig> {
    private static Set<CupboardConfig> allConfigs = new HashSet<CupboardConfig>();
    private static WatchService watchService = null;
    private static Map<String, CupboardConfig> watchedConfigs = new HashMap<String, CupboardConfig>();
    private static final Map<CupboardConfig, Integer> scheuledReloads = new HashMap<CupboardConfig, Integer>();
    private static long lastUpdate = 0L;
    private C commonConfig;
    private final String filename;
    private int loaded = 0;
    private int saveCounter = 0;
    private final Path configPath;
    static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void initloadAll() {
        for (CupboardConfig config : allConfigs) {
            config.getCommonConfig();
        }
    }

    private static void registerConfig(CupboardConfig config) {
        if (!allConfigs.contains(config)) {
            allConfigs.add(config);
            try {
                config.configPath.getParent().register(CupboardConfig.getWatchService(), StandardWatchEventKinds.ENTRY_MODIFY);
                watchedConfigs.put(config.filename, config);
            }
            catch (IOException e) {
                Cupboard.LOGGER.warn("Failed to register config path to file watcher", (Throwable)e);
            }
        }
    }

    private static WatchService getWatchService() {
        if (watchService == null) {
            try {
                watchService = FileSystems.getDefault().newWatchService();
            }
            catch (Throwable e) {
                Cupboard.LOGGER.warn("Failed to create config file watcher", e);
            }
        }
        return watchService;
    }

    public static void pollConfigs() {
        if (System.currentTimeMillis() - lastUpdate <= 1000L) {
            return;
        }
        lastUpdate = System.currentTimeMillis();
        WatchKey watchKey = CupboardConfig.getWatchService().poll();
        if (watchKey != null) {
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                CupboardConfig config;
                if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || (config = watchedConfigs.get(event.context().toString())) == null) continue;
                if (config.saveCounter > 0) {
                    config.saveCounter = 0;
                    continue;
                }
                scheuledReloads.put(config, 10);
            }
            watchKey.reset();
        }
        Iterator<Map.Entry<CupboardConfig, Integer>> iterator = scheuledReloads.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CupboardConfig, Integer> entry = iterator.next();
            if (entry.getValue() > 0) {
                entry.setValue(entry.getValue() - 1);
                continue;
            }
            iterator.remove();
            entry.getKey().load(false);
        }
    }

    public CupboardConfig(String filename, C commonConfig) {
        this.commonConfig = commonConfig;
        this.filename = filename.replace(".json", "") + ".json";
        this.configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve(this.filename);
        CupboardConfig.registerConfig(this);
    }

    public void load() {
        this.load(true);
    }

    public void load(boolean manualReload) {
        block15: {
            ++this.loaded;
            File config = this.configPath.toFile();
            if (!config.exists()) {
                Cupboard.LOGGER.warn("Config " + this.filename + " not found, recreating default");
                if (this.loaded < 3 && manualReload) {
                    this.save();
                    this.load();
                }
            } else {
                JsonObject jsonFileData = null;
                try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
                    jsonFileData = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    this.commonConfig.deserialize(jsonFileData);
                    Cupboard.LOGGER.info("Loaded config for: " + this.filename);
                }
                catch (Exception e) {
                    if (jsonFileData != null) {
                        JsonObject defaultConfig = this.commonConfig.serialize();
                        for (Map.Entry defaultEntry : defaultConfig.entrySet()) {
                            if (jsonFileData.has((String)defaultEntry.getKey())) continue;
                            jsonFileData.add((String)defaultEntry.getKey(), (JsonElement)defaultEntry.getValue());
                        }
                        try {
                            this.commonConfig.deserialize(jsonFileData);
                            this.save();
                            Cupboard.LOGGER.info("Loaded config for: " + this.filename);
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Cupboard.LOGGER.error("Could not read config " + this.filename + " from:" + this.configPath, (Throwable)e);
                    if (this.loaded >= 3 || !manualReload) break block15;
                    this.save();
                    this.load();
                }
            }
        }
    }

    public void save() {
        ++this.saveCounter;
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
        }
        catch (Throwable e) {
            Cupboard.LOGGER.error("Could not write config " + this.filename + " to:" + this.configPath, e);
        }
    }

    public C getCommonConfig() {
        if (this.loaded == 0) {
            this.load();
        }
        return this.commonConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CupboardConfig config = (CupboardConfig)o;
        return Objects.equals(this.configPath, config.configPath);
    }

    public int hashCode() {
        return this.configPath.hashCode();
    }
}

