/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.blockentity;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.block.DockBlock;
import tfar.dankstorage.container.DockMenu;
import tfar.dankstorage.inventory.api.DankInventorySlotWrapper;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.DankInventory;

public class DockBlockEntity
extends class_2586
implements class_1275,
class_3908 {
    public class_2487 settings;
    public int numPlayersUsing = 0;
    protected class_2561 customName;
    protected boolean originalName;
    public static final DankInventory DUMMY = new DankInventory(DankStats.zero, -1);
    private CombinedStorage<ItemVariant, DankInventorySlotWrapper> storage;

    public DockBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(DankStorage.dank_tile, blockPos, blockState);
    }

    public void setFrequency(int freq) {
        if (this.settings != null) {
            this.settings.method_10569("dankstorage:id", freq);
        }
    }

    public DankInventory getInventory() {
        if (this.settings != null && this.settings.method_10545("dankstorage:id")) {
            int id = this.settings.method_10550("dankstorage:id");
            DankInventory dankInventory = DankStorage.instance.data.getInventory(id);
            if (dankInventory == null) {
                int next = DankStorage.instance.data.getNextID();
                dankInventory = DankStorage.instance.data.getOrCreateInventory(next, DankStats.values()[(Integer)this.method_11010().method_11654((class_2769)DockBlock.TIER)]);
                this.settings.method_10569("dankstorage:id", next);
            }
            return dankInventory;
        }
        return DUMMY;
    }

    public int getComparatorSignal() {
        return this.getInventory().calcRedstone();
    }

    public boolean method_11004(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.method_5431();
            return true;
        }
        return super.method_11004(id, type);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.settings = compound.method_10562("settings");
        if (compound.method_10573("CustomName", 8)) {
            this.setCustomName((class_2561)class_2561.class_2562.method_10877((String)compound.method_10558("CustomName")));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.settings != null) {
            tag.method_10566("settings", (class_2520)this.settings);
        }
        if (this.method_16914()) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
    }

    @Nonnull
    public class_2487 method_16887() {
        return super.method_16887();
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)("container.dankstorage.dank_" + this.method_11010().method_11654((class_2769)DockBlock.TIER)));
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 text) {
        this.customName = text;
    }

    @Nullable
    public DockMenu createMenu(int syncId, class_1661 inventory, class_1657 player) {
        int tier = (Integer)this.method_11010().method_11654((class_2769)DockBlock.TIER);
        DankInventory dankInventory = this.getInventory();
        DankStats type = DankStats.values()[tier];
        if (type != dankInventory.dankStats) {
            if (type.ordinal() < dankInventory.dankStats.ordinal()) {
                Utils.warn(player, type, dankInventory.dankStats);
                return null;
            }
            dankInventory.upgradeTo(type);
        }
        return switch ((Integer)this.method_11010().method_11654((class_2769)DockBlock.TIER)) {
            case 1 -> DockMenu.t1s(syncId, inventory, dankInventory, this);
            case 2 -> DockMenu.t2s(syncId, inventory, dankInventory, this);
            case 3 -> DockMenu.t3s(syncId, inventory, dankInventory, this);
            case 4 -> DockMenu.t4s(syncId, inventory, dankInventory, this);
            case 5 -> DockMenu.t5s(syncId, inventory, dankInventory, this);
            case 6 -> DockMenu.t6s(syncId, inventory, dankInventory, this);
            case 7 -> DockMenu.t7s(syncId, inventory, dankInventory, this);
            default -> null;
        };
    }

    public void giveToPlayer(class_1657 player) {
        class_1799 dankInStack = this.removeDankWithoutItemSpawn();
        if (!player.method_7270(dankInStack)) {
            class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), dankInStack);
            this.field_11863.method_8649((class_1297)entity);
        }
    }

    public void removeDankWithItemSpawn() {
        class_1799 dankInStack = this.removeDankWithoutItemSpawn();
        class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), dankInStack);
        this.field_11863.method_8649((class_1297)entity);
    }

    public class_1799 removeDankWithoutItemSpawn() {
        int tier = (Integer)this.method_11010().method_11654((class_2769)DockBlock.TIER);
        if (tier == 0) {
            throw new RuntimeException("tried to remove a null dank?");
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)DockBlock.TIER, (Comparable)Integer.valueOf(0)));
        class_1799 stack = new class_1799((class_1935)Utils.getItemFromTier(tier));
        if (this.settings != null) {
            stack.method_7948().method_10566("settings", (class_2520)this.settings);
        }
        this.settings = null;
        if (this.method_16914() && this.originalName) {
            stack.method_7977(this.method_5797());
        }
        this.setCustomName(null);
        this.originalName = false;
        this.method_5431();
        return stack;
    }

    public void addDank(class_1799 tank) {
        if (tank.method_7909() instanceof DankItem) {
            DankInventory dankInventory;
            DankStats stats = ((DankItem)tank.method_7909()).stats;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)DockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
            this.originalName = tank.method_7938();
            if (this.originalName) {
                this.setCustomName(tank.method_7964());
            }
            class_2487 iSettings = Utils.getSettings(tank);
            tank.method_7934(1);
            if (iSettings != null && iSettings.method_10545("dankstorage:id")) {
                this.settings = iSettings;
                dankInventory = DankStorage.instance.data.getInventory(iSettings.method_10550("dankstorage:id"));
            } else {
                this.settings = new class_2487();
                int newId = DankStorage.instance.data.getNextID();
                dankInventory = DankStorage.instance.data.getOrCreateInventory(newId, stats);
                this.settings.method_10569("dankstorage:id", newId);
            }
            if (stats != dankInventory.dankStats) {
                dankInventory.upgradeTo(stats);
            }
            this.method_5431();
        }
    }

    public void upgradeTo(DankStats stats) {
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)DockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
        DankInventory dankInventory = this.getInventory();
        dankInventory.upgradeTo(stats);
    }

    public CombinedStorage<ItemVariant, DankInventorySlotWrapper> getStorage(class_2350 direction) {
        DankInventory dankInventory = this.getInventory();
        if (this.storage != null && this.storage.parts.size() != dankInventory.method_5439()) {
            this.storage = null;
        }
        if (this.storage == null) {
            this.storage = DockBlockEntity.create(dankInventory);
        }
        return this.storage;
    }

    public static CombinedStorage<ItemVariant, DankInventorySlotWrapper> create(DankInventory dankInventory) {
        int slots = dankInventory.method_5439();
        ArrayList<DankInventorySlotWrapper> storages = new ArrayList<DankInventorySlotWrapper>();
        for (int i = 0; i < slots; ++i) {
            DankInventorySlotWrapper storage = new DankInventorySlotWrapper(dankInventory, i);
            storages.add(storage);
        }
        return new CombinedStorage(storages);
    }
}

