/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.creator;

import com.hugman.dawn.api.creator.SimpleCreator;
import com.hugman.dawn.api.object.ModData;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;

public class ItemCreator
extends SimpleCreator<class_1792> {
    protected final Builder builder;

    protected ItemCreator(Builder builder) {
        super((class_2378<?>)class_2378.field_11142, builder.name, builder.itemProvider.apply(builder.settings));
        this.builder = builder;
    }

    @Override
    public void serverRegister(ModData modData, boolean isDedicated) {
        if (this.builder.cookTime != 0) {
            FuelRegistry.INSTANCE.add((class_1935)this.value, (Object)this.builder.cookTime);
        }
        if (this.builder.compostingChance != 0.0f) {
            CompostingChanceRegistry.INSTANCE.add((class_1935)this.value, (Object)Float.valueOf(this.builder.compostingChance));
        }
    }

    public static class Builder {
        protected String name;
        protected Function<class_1792.class_1793, ? extends class_1792> itemProvider;
        protected class_1792.class_1793 settings;
        protected int cookTime;
        protected float compostingChance;

        public Builder() {
        }

        public Builder(String name, Function<class_1792.class_1793, ? extends class_1792> itemProvider, class_1792.class_1793 settings, int cookTime, float compostingChance) {
            this.name = name;
            this.itemProvider = itemProvider;
            this.settings = settings;
            this.cookTime = cookTime;
            this.compostingChance = compostingChance;
        }

        public Builder(String name, Function<class_1792.class_1793, ? extends class_1792> itemProvider, class_1792.class_1793 settings) {
            this.name = name;
            this.itemProvider = itemProvider;
            this.settings = settings;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder item(Function<class_1792.class_1793, ? extends class_1792> itemProvider) {
            this.itemProvider = itemProvider;
            return this;
        }

        public Builder settings(class_1792.class_1793 settings) {
            this.settings = settings;
            return this;
        }

        public Builder cookTime(int cookTime) {
            this.cookTime = cookTime;
            return this;
        }

        public Builder compostingChance(float compostingChance) {
            this.compostingChance = compostingChance;
            return this;
        }

        public ItemCreator build() {
            Objects.requireNonNull(this.name, "Cannot build a item with no name!");
            Objects.requireNonNull(this.itemProvider, "Cannot build a item with no item provider!");
            Objects.requireNonNull(this.settings, "Cannot build a item with no item settings!");
            return new ItemCreator(this.copy());
        }

        public Builder copy() {
            return new Builder(this.name, this.itemProvider, this.settings, this.cookTime, this.compostingChance);
        }
    }
}

