/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.fabric;

import java.util.HashMap;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6812;
import net.minecraft.class_6819;
import samebutdifferent.ecologics.Ecologics;
import samebutdifferent.ecologics.block.FloweringAzaleaLogBlock;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.fabric.ModConfigFabric;

public class EcologicsFabric
implements ModInitializer {
    public void onInitialize() {
        AutoConfig.register(ModConfigFabric.class, GsonConfigSerializer::new);
        Ecologics.init();
        this.registerEntityAttributes();
        this.registerEvents();
        this.addFeatures();
        this.replaceFeatures();
        this.addSpawns();
        Ecologics.commonSetup();
    }

    public void registerEntityAttributes() {
        HashMap<class_1299<? extends class_1309>, class_5132.class_5133> attributes = new HashMap<class_1299<? extends class_1309>, class_5132.class_5133>();
        Ecologics.registerEntityAttributes(attributes);
        attributes.forEach(FabricDefaultAttributeRegistry::register);
    }

    public void registerEvents() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2350 direction;
            class_2680 state = world.method_8320(hitResult.method_17777());
            if (state.method_27852((class_2248)ModBlocks.POT.get()) && player.method_18276()) {
                if (player.method_6047().method_7909() instanceof class_1810 && hand.equals((Object)class_1268.field_5808)) {
                    world.method_8501(hitResult.method_17777(), (class_2680)state.method_28493((class_2769)PotBlock.CHISEL));
                    world.method_8396(null, hitResult.method_17777(), class_3417.field_17710, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
                    player.method_6104(class_1268.field_5808);
                    player.method_6047().method_7956(1, (class_1309)player, plr -> plr.method_20236(class_1268.field_5808));
                }
                if (player.method_6079().method_7909() instanceof class_1810 && !(player.method_6047().method_7909() instanceof class_1810) && hand.equals((Object)class_1268.field_5810)) {
                    world.method_8501(hitResult.method_17777(), (class_2680)state.method_28493((class_2769)PotBlock.CHISEL));
                    world.method_8396(null, hitResult.method_17777(), class_3417.field_17710, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
                    player.method_6104(class_1268.field_5810);
                    player.method_6079().method_7956(1, (class_1309)player, plr -> plr.method_20236(class_1268.field_5810));
                }
            }
            class_1799 stack = player.method_5998(hand);
            class_2350 class_23502 = direction = hitResult.method_17780().method_10166() == class_2350.class_2351.field_11052 ? hitResult.method_17780().method_10153() : hitResult.method_17780();
            if (stack.method_31574(class_1802.field_8868)) {
                if (state.method_27852(class_2246.field_28679)) {
                    FloweringAzaleaLogBlock.shearAzalea(world, player, hitResult.method_17777(), stack, hand, direction, class_2246.field_28678.method_9564());
                    player.method_23667(hand, true);
                }
                if (state.method_27852(class_2246.field_28674)) {
                    FloweringAzaleaLogBlock.shearAzalea(world, player, hitResult.method_17777(), stack, hand, direction, (class_2680)((class_2680)class_2246.field_28673.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)((Boolean)state.method_11654((class_2769)class_2397.field_11200)))).method_11657((class_2769)class_2397.field_11199, (Comparable)((Integer)state.method_11654((class_2769)class_2397.field_11199))));
                    player.method_23667(hand, true);
                }
            }
            return class_1269.field_5811;
        });
    }

    public void addFeatures() {
        ModConfigFabric config = (ModConfigFabric)AutoConfig.getConfigHolder(ModConfigFabric.class).getConfig();
        if (config.beach.generateCoconutTrees) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9434), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeatureKey("trees_beach"));
        }
        if (config.beach.generateSeashells) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9434), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeatureKey("seashell"));
        }
        if (config.snowy.generateThinIcePatches) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9463) || biomeSelector.getBiomeKey().equals(class_1972.field_9435) || biomeSelector.getBiomeKey().equals(class_1972.field_35117), (class_2893.class_2895)class_2893.class_2895.field_13179, this.getPlacedFeatureKey("thin_ice_patch"));
        }
        if (config.desert.generatePricklyPears) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9424), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeatureKey("prickly_pear"));
        }
        if (config.desert.generateDesertRuins) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9424), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeatureKey("desert_ruin"));
        }
    }

    public void replaceFeatures() {
        ModConfigFabric config = (ModConfigFabric)AutoConfig.getConfigHolder(ModConfigFabric.class).getConfig();
        BiomeModifications.create((class_2960)new class_2960("ecologics", "remove_azalea_trees")).add(ModificationPhase.REPLACEMENTS, biomeSelectionContext -> biomeSelectionContext.getBiomeKey().equals(class_1972.field_29218), c -> {
            if (config.lushCaves.replaceAzaleaTree) {
                c.getGenerationSettings().removeBuiltInFeature((class_6796)class_6812.field_35989.comp_349());
                c.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, this.getPlacedFeatureKey("rooted_azalea_tree"));
            }
            if (config.lushCaves.generateSurfaceMoss) {
                c.getGenerationSettings().removeBuiltInFeature((class_6796)class_6812.field_35995.comp_349());
                c.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, this.getPlacedFeatureKey("surface_moss_patch"));
            }
        });
        BiomeModifications.create((class_2960)new class_2960("ecologics", "remove_oak_trees")).add(ModificationPhase.REPLACEMENTS, biomeSelectionContext -> biomeSelectionContext.getBiomeKey().equals(class_1972.field_9451), c -> {
            if (config.plains.generateWalnutTrees) {
                c.getGenerationSettings().removeBuiltInFeature((class_6796)class_6819.field_36135.comp_349());
                c.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, this.getPlacedFeatureKey("trees_walnut"));
            }
        });
    }

    public void addSpawns() {
        ModConfigFabric config = (ModConfigFabric)AutoConfig.getConfigHolder(ModConfigFabric.class).getConfig();
        if (config.snowy.spawnPenguins) {
            BiomeModifications.addSpawn(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9463) || biomeSelector.getBiomeKey().equals(class_1972.field_9435) || biomeSelector.getBiomeKey().equals(class_1972.field_35117), (class_1311)class_1311.field_6294, ModEntityTypes.PENGUIN.get(), (int)2, (int)4, (int)5);
        }
        if (config.desert.spawnCamels) {
            BiomeModifications.addSpawn(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9424), (class_1311)class_1311.field_6294, ModEntityTypes.CAMEL.get(), (int)1, (int)1, (int)1);
        }
        if (config.plains.spawnSquirrels) {
            BiomeModifications.addSpawn(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9451), (class_1311)class_1311.field_6294, ModEntityTypes.SQUIRREL.get(), (int)10, (int)2, (int)3);
        }
    }

    private class_5321<class_6796> getPlacedFeatureKey(String key) {
        return class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)new class_2960("ecologics", key));
    }
}

