/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.eldritch_mobs.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.hyper_pigeon.eldritch_mobs.EldritchMobsMod;
import net.hyper_pigeon.eldritch_mobs.ability.Ability;
import net.hyper_pigeon.eldritch_mobs.ability.active.defensive.SprinterAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.AlchemistAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.BlindingAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.BurningAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.DrainingAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.DrowningAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.DuplicatorAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.GhastlyAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.GravityAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.LethargicAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.StarvingAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.StormyAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.WeaknessAbility;
import net.hyper_pigeon.eldritch_mobs.ability.active.offensive.WebslingingAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.CloakedAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.DeflectorAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.EnderAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.RegeneratingAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.ResistantAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.ThornyAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.ToxicAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.UndyingAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.defensive.WitheringAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.offensive.BerserkAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.offensive.LifestealAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.offensive.RustAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.offensive.SpeedsterAbility;
import net.hyper_pigeon.eldritch_mobs.ability.passive.offensive.YeeterAbility;
import net.hyper_pigeon.eldritch_mobs.config.EldritchMobsConfig;
import net.minecraft.class_1299;
import org.jetbrains.annotations.Nullable;

public class AbilityHelper {
    public static final ArrayList<AbilityRecord<?>> ALL_ABILITIES = new ArrayList<AbilityRecord<?>>(){
        {
            this.add(new AbilityRecord<EldritchMobsConfig.AlchemistConfig>(new AlchemistAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.alchemistConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.BlindingConfig>(new BlindingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.blindingConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.BurningConfig>(new BurningAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.burningConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.DrainingConfig>(new DrainingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.drainingConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.DrowningConfig>(new DrowningAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.drowningConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.DuplicatorConfig>(new DuplicatorAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.duplicatorConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.GhastlyConfig>(new GhastlyAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.ghastlyConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.GravityConfig>(new GravityAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.gravityConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.LethargicConfig>(new LethargicAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.lethargicConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.RustConfig>(new RustAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.rustConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.SpeedsterConfig>(new StarvingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.speedsterConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.StormyConfig>(new StormyAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.stormyConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.WeaknessConfig>(new WeaknessAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.weaknessConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.WebslingingConfig>(new WebslingingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.webslingingConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.CloakedConfig>(new CloakedAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.cloakedConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.DeflectorConfig>(new DeflectorAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.deflectorConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.EnderConfig>(new EnderAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.enderConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.UndyingConfig>(new UndyingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.undyingConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.RegeneratingConfig>(new RegeneratingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.regeneratingConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.ResistantConfig>(new ResistantAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.resistantConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.SprinterConfig>(new SprinterAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.sprinterConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.StarvingConfig>(new StarvingAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.starvingConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.ThornyConfig>(new ThornyAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.thornyConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.ToxicConfig>(new ToxicAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.toxicConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.WitheringConfig>(new WitheringAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.witheringConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.BerserkConfig>(new BerserkAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.berserkConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.LifestealConfig>(new LifestealAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.lifestealConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.SpeedsterConfig>(new SpeedsterAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.speedsterConfig));
            this.add(new AbilityRecord<EldritchMobsConfig.YeeterConfig>(new YeeterAbility(), EldritchMobsMod.ELDRITCH_MOBS_CONFIG.yeeterConfig));
        }
    };
    public static final HashMap<String, List<class_1299<?>>> ABILITY_BLACKLIST = new HashMap();
    public static final Random RANDOM = new Random();

    public static List<Ability> pickNRandom(List<Ability> l, int n) {
        ArrayList<Ability> copy = new ArrayList<Ability>(l);
        Collections.shuffle(copy);
        return n > copy.size() ? copy.subList(0, copy.size()) : copy.subList(0, n);
    }

    public static List<Ability> pickNRandomForEntity(List<Ability> lst, int n, class_1299<?> entityType) {
        ArrayList<Ability> copy = new ArrayList<Ability>(lst);
        copy.removeIf(ability -> ABILITY_BLACKLIST.containsKey(ability.getName()) && ABILITY_BLACKLIST.get(ability.getName()).contains(entityType));
        Collections.shuffle(copy);
        return n > copy.size() ? copy.subList(0, copy.size()) : copy.subList(0, n);
    }

    public static void addAbility(Ability ability) {
        ALL_ABILITIES.add(new AbilityRecord<Object>(ability, null));
    }

    public static boolean includesAbility(String abilityName) {
        return ALL_ABILITIES.stream().anyMatch(abilityRecord -> abilityRecord.name.equals(abilityName));
    }

    public static void addBlacklist(String name, List<class_1299<?>> entityTypeList) {
        ABILITY_BLACKLIST.put(name, entityTypeList);
    }

    public static void removeAbility(Ability ability) {
        ALL_ABILITIES.removeIf(abilityRecord -> abilityRecord.name.equals(ability.getName()));
    }

    public static void removeAbilityByName(String name) {
        ALL_ABILITIES.removeIf(abilityRecord -> abilityRecord.name.equals(name));
    }

    public static Optional<AbilityRecord<?>> getAbilityRecordByName(String name) {
        return ALL_ABILITIES.stream().filter(record -> record.name.equals(name)).findFirst();
    }

    public static List<String> getAbilityNames() {
        return ALL_ABILITIES.stream().map(record -> record.name).collect(Collectors.toList());
    }

    public static List<Ability> getAbilities() {
        return ALL_ABILITIES.stream().map(record -> record.ability).collect(Collectors.toList());
    }

    public static void removeDisabledAbilities() {
        ArrayList<String> abilitiesToRemove = new ArrayList<String>();
        for (AbilityRecord<?> record : ALL_ABILITIES) {
            try {
                if (record.config == null || !record.config.getClass().getField("disabled").getBoolean(record.config)) continue;
                abilitiesToRemove.add(record.name);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        for (String name : abilitiesToRemove) {
            AbilityHelper.removeAbilityByName(name);
        }
    }

    public static final class AbilityRecord<C> {
        public final Ability ability;
        @Nullable
        public final C config;
        public final String name;

        public Class<C> getConfigType() {
            return this.config == null ? null : this.config.getClass();
        }

        public AbilityRecord(Ability ability, @Nullable C config) {
            this.ability = ability;
            this.config = config;
            this.name = ability.getName();
        }
    }
}

