/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.eldritch_mobs.ability.active.offensive;

import net.hyper_pigeon.eldritch_mobs.EldritchMobsMod;
import net.hyper_pigeon.eldritch_mobs.ability.Ability;
import net.hyper_pigeon.eldritch_mobs.ability.AbilitySubType;
import net.hyper_pigeon.eldritch_mobs.ability.AbilityType;
import net.hyper_pigeon.eldritch_mobs.config.EldritchMobsConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3222;

public class GravityAbility
implements Ability {
    private final EldritchMobsConfig.GravityConfig gravityConfig;
    private final long cooldown;
    private long nextUseTime;

    public GravityAbility() {
        this.gravityConfig = EldritchMobsMod.ELDRITCH_MOBS_CONFIG.gravityConfig;
        this.cooldown = this.gravityConfig.cooldown;
        this.nextUseTime = 0L;
    }

    @Override
    public String getName() {
        return this.gravityConfig.name;
    }

    @Override
    public AbilityType getAbilityType() {
        return AbilityType.ACTIVE;
    }

    @Override
    public AbilitySubType getAbilitySubType() {
        return AbilitySubType.OFFENSIVE;
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean canUseAbility(class_1308 mobEntity) {
        return mobEntity.field_6002.method_8510() > this.nextUseTime && mobEntity.method_5968() != null;
    }

    @Override
    public void onAbilityUse(class_1308 mobEntity) {
        long time;
        if (!mobEntity.method_5770().method_8608() && mobEntity.method_5968() != null && mobEntity.method_6057((class_1297)mobEntity.method_5968()) && mobEntity.method_5968().method_5805() && (time = mobEntity.method_5770().method_8510()) > this.nextUseTime) {
            this.nextUseTime = time + this.cooldown;
            class_1309 target = mobEntity.method_5968();
            double targetX = target.method_23317();
            double targetY = target.method_23318();
            double targetZ = target.method_23321();
            double entityX = mobEntity.method_23317();
            double entityY = mobEntity.method_23318();
            double entityZ = mobEntity.method_23321();
            double diffX = entityX - targetX;
            double diffY = entityY - targetY;
            double diffZ = entityZ - targetZ;
            if (target instanceof class_3222) {
                class_3222 serverTarget = (class_3222)target;
                serverTarget.field_13987.method_14364((class_2596)new class_2743(target.method_5628(), new class_243(diffX, diffY, diffZ)));
            } else {
                target.method_5762(diffX, diffY, diffZ);
            }
        }
    }
}

