/*
 * Decompiled with CFR 0.152.
 */
package com.rebelkeithy.extendedarmorbars;

import com.mojang.blaze3d.systems.RenderSystem;
import com.rebelkeithy.extendedarmorbars.utils.DefaultList;
import java.awt.Color;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class StatusBarRenderer {
    public static int TEXTURE_WIDTH = 45;
    public static int TEXTURE_HEIGHT = 9;
    public static int ICON_WIDTH = 9;
    public static int ICON_HEIGHT = 9;
    public static int OVERLAP = 1;
    public static int BAR_WIDTH = 10 * (ICON_WIDTH - OVERLAP) + OVERLAP;
    public static final int U_EMPTY = 0;
    public static final int U_HALF = 9;
    public static final int U_FULL = 18;
    public static final int U_CAPPED = 27;
    public static final int U_CAPPED_HALF = 36;
    private final class_2960 icons;
    private final DefaultList<Color> colors;
    private final boolean mirrored;
    public boolean hideWhenEmpty = true;
    public boolean hideEmptySlots = false;

    public StatusBarRenderer(class_2960 icons, DefaultList<Color> colors, boolean mirrored) {
        this.icons = icons;
        this.colors = colors;
        this.mirrored = mirrored;
    }

    public StatusBarRenderer(class_2960 icons, DefaultList<Color> colors) {
        this(icons, colors, false);
    }

    public void render(class_4587 matrices, int x, int y, int statusBarValue) {
        if (this.hideWhenEmpty && statusBarValue <= 0) {
            return;
        }
        matrices.method_22903();
        RenderSystem.setShaderTexture((int)0, (class_2960)this.icons);
        int topLayerIndex = (statusBarValue - 1) / 20;
        int valueOfTopLayer = (statusBarValue - 1) % 20 + 1;
        int numFullIcons = valueOfTopLayer / 2;
        int widthOfFullIcons = numFullIcons * (ICON_WIDTH - OVERLAP) + OVERLAP;
        boolean hasHalfIcon = valueOfTopLayer % 2 == 1;
        int indexOfHalfIcon = valueOfTopLayer / 2;
        int dx = this.mirrored ? BAR_WIDTH - widthOfFullIcons : 0;
        int dxhalfSlot = this.mirrored ? dx - ICON_WIDTH + OVERLAP : widthOfFullIcons - OVERLAP;
        this.drawLayer(matrices, x, y, topLayerIndex - 1, 10);
        this.drawLayer(matrices, x + dx, y, topLayerIndex, numFullIcons);
        if (hasHalfIcon) {
            if (topLayerIndex < this.colors.size()) {
                this.setColor(this.colors.get(topLayerIndex));
                class_332.method_25290((class_4587)matrices, (int)(x + dxhalfSlot), (int)y, (float)9.0f, (float)0.0f, (int)ICON_WIDTH, (int)ICON_HEIGHT, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
            } else {
                this.setColor(this.colors.get(topLayerIndex));
                class_332.method_25290((class_4587)matrices, (int)(x + dxhalfSlot), (int)y, (float)36.0f, (float)0.0f, (int)ICON_WIDTH, (int)ICON_HEIGHT, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
            }
        }
        this.setColor(Color.WHITE);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        matrices.method_22909();
    }

    public void drawLayer(class_4587 matrices, int x, int y, int layerIndex, int numIcons) {
        this.setColor(this.colors.get(layerIndex));
        int type = this.getUForLayerIndex(layerIndex);
        if (type == 0 && this.hideEmptySlots) {
            return;
        }
        this.drawTiled(matrices, x, y, type, 0.0f, ICON_WIDTH, ICON_HEIGHT, TEXTURE_WIDTH, TEXTURE_HEIGHT, numIcons, 1, OVERLAP, 0);
    }

    public void setColor(Color color) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 256.0f), (float)((float)color.getGreen() / 256.0f), (float)((float)color.getBlue() / 256.0f), (float)((float)color.getAlpha() / 256.0f));
    }

    public int getUForLayerIndex(int index) {
        if (index < 0) {
            return 0;
        }
        if (index >= this.colors.size()) {
            return 27;
        }
        return 18;
    }

    public void drawTiled(class_4587 matrices, int x, int y, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int xCount, int yCount, int xOverlap, int yOverlap) {
        for (int i = 0; i < xCount; ++i) {
            class_332.method_25290((class_4587)matrices, (int)(x + i * (regionWidth - xOverlap)), (int)y, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
        }
    }
}

