/*
 * Decompiled with CFR 0.152.
 */
package com.rebelkeithy.extendedarmorbars;

import com.rebelkeithy.extendedarmorbars.StatusBarRenderer;
import com.rebelkeithy.extendedarmorbars.config.Config;
import com.rebelkeithy.extendedarmorbars.config.ConfigLoader;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_746;

public class ToughnessBar
implements ModInitializer {
    public static final String MOD_ID = "extendedarmorbars";
    private static final String CONFIG_FILE = "config.json";
    private static final class_2960 ARMOR = new class_2960("extendedarmorbars", "textures/gui/armor.png");
    private static final class_2960 TOUGHNESS = new class_2960("extendedarmorbars", "textures/gui/toughness.png");
    public static Config config;
    public static StatusBarRenderer armorBar;
    public static StatusBarRenderer toughnessBar;
    public static int armorYValue;

    public void onInitialize() {
        config = new ConfigLoader().loadConfigFile(CONFIG_FILE);
        armorBar = new StatusBarRenderer(ARMOR, config.getParsedColors());
        toughnessBar = new StatusBarRenderer(TOUGHNESS, config.getParsedColors(), true);
    }

    public static void saveAndReloadConfig() {
        new ConfigLoader().saveConfigFile(CONFIG_FILE, config);
        armorBar = new StatusBarRenderer(ARMOR, config.getParsedColors());
        ToughnessBar.armorBar.hideEmptySlots = config.isArmorHideEmptySlots();
        ToughnessBar.armorBar.hideWhenEmpty = config.isArmorHideWhenEmpty();
        toughnessBar = new StatusBarRenderer(TOUGHNESS, config.getParsedColors(), true);
        ToughnessBar.toughnessBar.hideEmptySlots = config.isToughnessHideEmptySlots();
        ToughnessBar.toughnessBar.hideWhenEmpty = config.isToughnessHideWhenEmpty();
    }

    public static void render(class_4587 matrices) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null) {
            int value;
            int y;
            int x;
            int scaledWidth = client.method_22683().method_4486();
            int scaledHeight = client.method_22683().method_4502();
            if (config.isArmorEnable()) {
                x = scaledWidth / 2 - 91;
                y = scaledHeight + ToughnessBar.getArmorYOffset(player);
                if (armorYValue != 0) {
                    y = armorYValue - config.getArmorBarOffset();
                }
                value = player.method_6096();
                armorBar.render(matrices, x, y, value);
            }
            if (config.isToughnessEnable()) {
                x = scaledWidth / 2 + 91 - 80 - 1;
                y = scaledHeight + ToughnessBar.getToughnessYOffset(player);
                value = (int)player.method_26825(class_5134.field_23725);
                toughnessBar.render(matrices, x, y, value);
            }
        }
    }

    private static int getArmorYOffset(class_746 player) {
        int health;
        int renderedHealth = health = class_3532.method_15386((float)player.method_6032());
        float actualHealth = Math.max((float)player.method_26825(class_5134.field_23716), (float)Math.max(renderedHealth, health));
        int absorption = class_3532.method_15386((float)player.method_6067());
        int healthBarRows = class_3532.method_15386((float)((actualHealth + (float)absorption) / 2.0f / 10.0f));
        if (config.isOneHealthBar()) {
            healthBarRows = 1;
        }
        int r = Math.max(10 - (healthBarRows - 2), 3);
        return -39 - (healthBarRows - 1) * r - 10 - config.getArmorBarOffset();
    }

    private static int getToughnessYOffset(class_746 player) {
        int y = -49;
        int z = player.method_5748();
        int aa = Math.min(player.method_5669(), z);
        if (player.method_5777(class_3486.field_15517) || aa < z) {
            y -= 10;
        }
        return y - config.getToughnessBarOffset();
    }

    static {
        armorYValue = 0;
    }
}

