/*
 * Decompiled with CFR 0.152.
 */
package net.quarrymod.blockentity.machine.tier3;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.quarrymod.block.QuarryBlock;
import net.quarrymod.block.misc.BlockDrillTube;
import net.quarrymod.blockentity.machine.tier3.ExcavationState;
import net.quarrymod.blockentity.machine.tier3.ExcavationWorkType;
import net.quarrymod.blockentity.machine.tier3.MiningUtil;
import net.quarrymod.blockentity.utils.SlotGroup;
import net.quarrymod.config.QuarryMachineConfig;
import net.quarrymod.init.QuarryManagerContent;
import net.quarrymod.init.QuarryModBlockEntities;
import net.quarrymod.items.IQuarryUpgrade;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.screen.slot.BaseSlot;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.WorldUtils;

public class QuarryBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    private int rangeExtenderLevel;
    private int fortuneLevel;
    private boolean isSilkTouch;
    public final RebornInventory<QuarryBlockEntity> inventory = new RebornInventory(12, "QuarryBlockEntity", 64, (MachineBaseBlockEntity)this);
    public final RebornInventory<QuarryBlockEntity> quarryUpgradesInventory = new RebornInventory(2, "QuarryUpgrades", 1, (MachineBaseBlockEntity)this);
    private long miningEnergySpend = 0L;
    private ExcavationState excavationState = ExcavationState.InProgress;
    private ExcavationWorkType excavationWorkType = ExcavationWorkType.Mining;
    private boolean isMineAll = false;
    private class_2338 targetBlockPosition;
    private int currentTickTime = 0;
    private final SlotGroup<QuarryBlockEntity> holeFillerSlotGroup = new SlotGroup<QuarryBlockEntity>(this.inventory, new int[]{0, 1, 2, 3});
    private final SlotGroup<QuarryBlockEntity> drillTubeSlotGroup = new SlotGroup<QuarryBlockEntity>(this.inventory, new int[]{4, 5});
    private final SlotGroup<QuarryBlockEntity> outputSlotGroup = new SlotGroup<QuarryBlockEntity>(this.inventory, new int[]{6, 7, 8, 9, 10});
    private final SlotGroup<QuarryBlockEntity> quarryUpgradesSlotGroup = new SlotGroup<QuarryBlockEntity>(this.quarryUpgradesInventory, new int[]{0, 1});
    private int currentRadius;
    private int currentY;
    private Queue<class_2338> remainingBlocks = new LinkedList<class_2338>();

    public QuarryBlockEntity(class_2338 pos, class_2680 state) {
        super(QuarryModBlockEntities.QUARRY, pos, state);
    }

    public void setSilkTouch(boolean isSilkTouch) {
        this.isSilkTouch = isSilkTouch;
    }

    public void setFortuneLevel(int newLevel) {
        this.fortuneLevel = newLevel;
    }

    public void setRangeExtenderLevel(int rangeLevel) {
        this.rangeExtenderLevel = rangeLevel;
    }

    public int getProgressScaled(int scale) {
        if (this.miningEnergySpend != 0L) {
            return (int)Math.min(this.miningEnergySpend * (long)scale / this.getEnergyPerExcavation(), 100L);
        }
        return 0;
    }

    public ExcavationState getExcavationState() {
        return this.excavationState;
    }

    public boolean getMineAll() {
        return switch (QuarryMachineConfig.quarryAccessibleExcavationModes) {
            case 1 -> false;
            case 2 -> true;
            default -> this.isMineAll;
        };
    }

    public void setMineAll(boolean mineAll) {
        this.isMineAll = switch (QuarryMachineConfig.quarryAccessibleExcavationModes) {
            case 1 -> false;
            case 2 -> true;
            default -> mineAll;
        };
    }

    private void setExcavationState(ExcavationState state) {
        if (this.excavationState == state) {
            return;
        }
        this.excavationState = state;
        this.refreshProperty();
    }

    private void setExcavationWorkType(ExcavationWorkType workType) {
        if (this.excavationWorkType == workType) {
            return;
        }
        this.excavationWorkType = workType;
        this.refreshProperty();
    }

    private void refreshProperty() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            ((QuarryBlock)this.field_11863.method_8320(this.field_11867).method_26204()).setState(this.getDisplayState(), this.field_11863, this.field_11867);
        }
    }

    public QuarryBlock.DisplayState getDisplayState() {
        QuarryBlock.DisplayState state = QuarryBlock.DisplayState.Off;
        if (this.getExcavationState() == ExcavationState.Complete) {
            state = QuarryBlock.DisplayState.Complete;
        } else if (this.getExcavationState().isError()) {
            state = QuarryBlock.DisplayState.Error;
        } else if (this.getExcavationState() == ExcavationState.InProgress) {
            state = this.excavationWorkType == ExcavationWorkType.Mining ? QuarryBlock.DisplayState.Mining : QuarryBlock.DisplayState.ExtractTube;
        }
        return state;
    }

    public String getStateName() {
        if (this.excavationWorkType == ExcavationWorkType.ExtractTube && this.excavationState == ExcavationState.InProgress) {
            return ExcavationWorkType.ExtractTube.toString();
        }
        return this.excavationState.toString();
    }

    public void resetOnPlaced() {
        this.setExcavationState(ExcavationState.InProgress);
        this.setExcavationWorkType(ExcavationWorkType.Mining);
        this.setProgress(0L);
        this.currentRadius = 0;
        this.currentY = this.field_11867.method_10264();
        this.currentTickTime = 0;
        this.remainingBlocks = new LinkedList<class_2338>();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity2) {
        super.tick(world, pos, state, blockEntity2);
        if (world == null || world.field_9236) {
            return;
        }
        this.charge(11);
        this.refreshUpgrades();
        this.tickQuarryLogic();
        ++this.currentTickTime;
    }

    private void refreshUpgrades() {
        this.rangeExtenderLevel = 0;
        this.fortuneLevel = 0;
        this.isSilkTouch = false;
        this.quarryUpgradesSlotGroup.executeForAll(stack -> {
            class_1792 patt7711$temp;
            if (!stack.method_7960() && (patt7711$temp = stack.method_7909()) instanceof IQuarryUpgrade) {
                IQuarryUpgrade upgradeItem = (IQuarryUpgrade)patt7711$temp;
                upgradeItem.process(this, (class_1799)stack);
            }
        });
    }

    private void tickQuarryLogic() {
        if (this.excavationState == ExcavationState.Complete) {
            return;
        }
        if (this.miningEnergySpend < this.getEnergyPerExcavation()) {
            this.performEnergyReduction();
        } else if (this.miningEnergySpend >= this.getEnergyPerExcavation()) {
            this.performQuarryLogic();
        }
        if (this.excavationState == ExcavationState.InProgress && this.currentTickTime % 20 == 0) {
            RecipeCrafter.soundHandler.playSound(false, (class_2586)this);
        }
    }

    private void performQuarryLogic() {
        if (this.excavationWorkType == ExcavationWorkType.ExtractTube) {
            this.drillUp();
            return;
        }
        if (!this.hasTargetBlock() && this.hasOneOfExcavationStates(ExcavationState.InProgress, ExcavationState.NoOreInCurrentPos, ExcavationState.CannotOutputMineDrop)) {
            this.targetBlockPosition = this.findMiningPosition();
        }
        if (!this.hasTargetBlock() && this.hasOneOfExcavationStates(ExcavationState.NoOresInCurrentDepth, ExcavationState.NotEnoughDrillTube)) {
            this.drillDown();
        } else if (this.hasTargetBlock() && this.hasOneOfExcavationStates(ExcavationState.InProgress, ExcavationState.CannotOutputMineDrop)) {
            this.performMineLogic(this.targetBlockPosition, !this.getMineAll());
        }
        if (this.excavationState == ExcavationState.InProgress) {
            this.miningEnergySpend -= this.getEnergyPerExcavation();
        }
    }

    private boolean hasTargetBlock() {
        return this.targetBlockPosition != null;
    }

    private boolean hasOneOfExcavationStates(ExcavationState ... states) {
        for (ExcavationState state : states) {
            if (this.excavationState != state) continue;
            return true;
        }
        return false;
    }

    private void performEnergyReduction() {
        long euNeeded = this.getEnergyPerExcavation() / (long)this.getTicksPerExcavation();
        long euAvailable = Math.min(euNeeded, this.getStored());
        if ((double)euAvailable > 0.0) {
            this.useEnergy(euAvailable);
            this.miningEnergySpend += euAvailable;
            this.setExcavationState(ExcavationState.InProgress);
        } else {
            this.setExcavationState(ExcavationState.NoEnergyIncome);
        }
    }

    private class_2338 findMiningPosition() {
        this.updateRemainingBlocks();
        while (!this.remainingBlocks.isEmpty()) {
            class_2338 blockPos = this.remainingBlocks.poll();
            if (!WorldUtils.isChunkLoaded((class_1937)this.field_11863, (class_2338)blockPos) || !this.canMineBlock(blockPos)) continue;
            this.setExcavationState(ExcavationState.InProgress);
            return blockPos;
        }
        this.setExcavationState(ExcavationState.NoOresInCurrentDepth);
        return null;
    }

    private void updateRemainingBlocks() {
        int calculatedY = this.calculateCurrentDrillTubeDepth();
        int radius = (int)Math.round(QuarryMachineConfig.quarrySqrWorkRadiusByUpgradeLevel.get(this.rangeExtenderLevel));
        if (this.currentRadius != radius || this.currentY != calculatedY || this.remainingBlocks.isEmpty()) {
            this.currentRadius = radius;
            this.currentY = calculatedY;
            this.remainingBlocks = this.createMiningArea();
        }
    }

    private Queue<class_2338> createMiningArea() {
        LinkedList<class_2338> blocks = new LinkedList<class_2338>();
        if (this.currentY == this.field_11867.method_10264()) {
            return blocks;
        }
        return MiningUtil.createMiningPosition(this.currentRadius, new class_2338(this.field_11867.method_10263(), this.currentY, this.field_11867.method_10260()));
    }

    private void performMineLogic(class_2338 blockPos, boolean fillHole) {
        if (!this.canMineBlock(blockPos)) {
            this.setExcavationState(ExcavationState.NoOreInCurrentPos);
            this.targetBlockPosition = null;
            return;
        }
        List<class_1799> drop = this.getDroppedStacks(this.field_11863.method_8320(blockPos), blockPos);
        if (this.outputSlotGroup.hasSpace(drop)) {
            this.outputSlotGroup.addStacks(drop);
            this.field_11863.method_8650(blockPos, false);
            if (fillHole) {
                this.tryFillHole(blockPos);
            }
            this.targetBlockPosition = null;
            this.setExcavationState(ExcavationState.InProgress);
        } else {
            this.setExcavationState(ExcavationState.CannotOutputMineDrop);
        }
    }

    private void tryFillHole(class_2338 blockPos) {
        class_1792 class_17922;
        class_1799 blockToPlace = this.holeFillerSlotGroup.consumeAny(1, QuarryBlockEntity::holeFillerFilter);
        if (!blockToPlace.method_7960() && (class_17922 = blockToPlace.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            this.field_11863.method_8501(blockPos, blockItem.method_7711().method_9564());
        }
    }

    private void drillDown() {
        class_1799 blockDrop;
        List<class_1799> blockDrops;
        int newDepth = this.currentY - 1;
        if (newDepth <= this.field_11863.method_31607()) {
            this.setExcavationWorkType(ExcavationWorkType.ExtractTube);
            this.setExcavationState(ExcavationState.InProgress);
            return;
        }
        class_2338 blockPos = new class_2338(this.field_11867.method_10263(), newDepth, this.field_11867.method_10260());
        class_2680 blockState = this.field_11863.method_8320(blockPos);
        class_1799 drillTubeItem = new class_1799((class_1935)QuarryManagerContent.DRILL_TUBE.method_8389());
        if (blockState.method_26214((class_1922)this.field_11863, blockPos) < 0.0f) {
            this.setExcavationWorkType(ExcavationWorkType.ExtractTube);
            this.setExcavationState(ExcavationState.InProgress);
            return;
        }
        if (!this.drillTubeSlotGroup.canConsume(drillTubeItem)) {
            this.setExcavationState(ExcavationState.NotEnoughDrillTube);
            return;
        }
        if (this.canMineBlock(blockPos)) {
            this.performMineLogic(blockPos, false);
            return;
        }
        if (!this.getMineAll() && (blockDrops = this.getDroppedStacks(blockState, blockPos)).size() == 1 && this.holeFillerSlotGroup.hasSpace(blockDrop = blockDrops.get(0)) && QuarryBlockEntity.holeFillerFilter(blockDrop)) {
            this.holeFillerSlotGroup.addStack(blockDrop);
        }
        this.drillTubeSlotGroup.consume(drillTubeItem);
        this.setExcavationState(ExcavationState.InProgress);
        this.field_11863.method_8501(blockPos, QuarryManagerContent.DRILL_TUBE.method_9564());
    }

    private void drillUp() {
        int tubeDepth = this.calculateCurrentDrillTubeDepth();
        if (tubeDepth == this.field_11867.method_10264()) {
            this.setExcavationState(ExcavationState.Complete);
            return;
        }
        class_1799 tubeItem = new class_1799((class_1935)QuarryManagerContent.DRILL_TUBE.method_8389());
        if (this.drillTubeSlotGroup.hasSpace(tubeItem)) {
            class_2338 blockPos = new class_2338(this.field_11867.method_10263(), tubeDepth, this.field_11867.method_10260());
            this.field_11863.method_8650(blockPos, false);
            if (!this.getMineAll()) {
                this.tryFillHole(blockPos);
            }
            this.drillTubeSlotGroup.addStack(tubeItem);
        } else {
            this.setExcavationState(ExcavationState.CannotOutputDrillTube);
        }
    }

    private int getTicksPerExcavation() {
        return Math.max((int)((double)QuarryMachineConfig.quarryTiksPerExcavation * (1.0 - this.getSpeedMultiplier())), QuarryMachineConfig.quarryMinTiksPerExcavation);
    }

    private long getEnergyPerExcavation() {
        return (long)((double)QuarryMachineConfig.quarryEnergyPerExcavation * this.getPowerMultiplier());
    }

    private boolean canMineBlock(class_2338 blockPos) {
        class_2680 state = this.field_11863.method_8320(blockPos);
        class_2248 block = state.method_26204();
        return !state.method_26215() && !(block instanceof class_2404) && state.method_26214((class_1922)this.field_11863, blockPos) >= 0.0f && !this.isDrillTube(state) && (this.getMineAll() || this.isOre(class_2378.field_11146.method_10221((Object)block).toString()));
    }

    private boolean isOre(String id) {
        return id.endsWith("_ore") || QuarryMachineConfig.quarryAdditioanlBlocksToMine.contains(id);
    }

    private List<class_1799> getDroppedStacks(class_2680 blockState, class_2338 blockPos) {
        class_1799 item = class_1802.field_22024.method_7854();
        item.method_7978(class_1893.field_9130, this.fortuneLevel);
        item.method_7978(class_1893.field_9099, this.isSilkTouch ? 1 : 0);
        return class_2248.method_9609((class_2680)blockState, (class_3218)((class_3218)this.field_11863), (class_2338)blockPos, (class_2586)this.field_11863.method_8321(blockPos), null, (class_1799)item);
    }

    public long getBaseMaxPower() {
        return QuarryMachineConfig.quarryMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return (long)((double)QuarryMachineConfig.quarryMaxInput * (1.0 + this.getSpeedMultiplier() * QuarryMachineConfig.quarryMaxInputOverclockerMultipier));
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return QuarryManagerContent.Machine.QUARRY.getStack();
    }

    public RebornInventory<QuarryBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        ScreenHandlerBuilder screenHandler = new ScreenHandlerBuilder("quarry").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).filterSlot(0, 30, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(1, 48, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(2, 66, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(3, 84, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(4, 121, 20, QuarryBlockEntity::drillTubeFilter).filterSlot(5, 139, 20, QuarryBlockEntity::drillTubeFilter).outputSlot(6, 55, 66).outputSlot(7, 75, 66).outputSlot(8, 95, 66).outputSlot(9, 115, 66).outputSlot(10, 135, 66).energySlot(11, 8, 72).syncEnergyValue().sync(this::getProgress, this::setProgress).sync(this::getState, this::setState).sync(this::getWorkType, this::setWorkType).sync(this::getMiningAll, this::setMiningAll).addInventory();
        try {
            this.createUiUpgradeSlots(screenHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return screenHandler.create((MachineBaseBlockEntity)this, syncID);
    }

    private void createUiUpgradeSlots(ScreenHandlerBuilder screenHandler) throws NoSuchFieldException, IllegalAccessException {
        Field slotsField = ScreenHandlerBuilder.class.getDeclaredField("slots");
        slotsField.setAccessible(true);
        List slots = (List)slotsField.get(screenHandler);
        slots.add(new BaseSlot(this.quarryUpgradesInventory, 0, -42, 30, QuarryBlockEntity::isQuarryUpgrade));
        slots.add(new BaseSlot(this.quarryUpgradesInventory, 1, -42, 48, QuarryBlockEntity::isQuarryUpgrade));
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2487 data = tag.method_10562("Quarry");
        this.setState(data.method_10550("state"));
        this.setWorkType(data.method_10550("workType"));
        this.setProgress(data.method_10537("progress"));
        this.setMiningAll(data.method_10550("mineAll"));
        this.quarryUpgradesInventory.read(tag, "quarryUpgradesInventory");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 data = new class_2487();
        data.method_10569("state", this.getState());
        data.method_10569("workType", this.getWorkType());
        data.method_10544("progress", this.getProgress());
        data.method_10569("mineAll", this.getMiningAll());
        tag.method_10566("Quarry", (class_2520)data);
        this.quarryUpgradesInventory.write(tag, "quarryUpgradesInventory");
    }

    private long getProgress() {
        return this.miningEnergySpend;
    }

    private void setProgress(long progress) {
        this.miningEnergySpend = progress;
    }

    private int getState() {
        return this.excavationState.ordinal();
    }

    private void setState(int state) {
        this.setExcavationState(ExcavationState.values()[state]);
    }

    private int getWorkType() {
        return this.excavationWorkType.ordinal();
    }

    private void setWorkType(int state) {
        this.excavationWorkType = ExcavationWorkType.values()[state];
    }

    private int getMiningAll() {
        return this.getMineAll() ? 1 : 0;
    }

    private void setMiningAll(int mineAll) {
        this.setMineAll(mineAll == 1);
    }

    private static boolean holeFillerFilter(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711().method_9564().method_26207().equals(class_3614.field_15914);
        }
        return false;
    }

    private static boolean drillTubeFilter(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711() instanceof BlockDrillTube;
        }
        return false;
    }

    private static boolean isQuarryUpgrade(class_1799 stack) {
        return stack.method_7909() instanceof IQuarryUpgrade;
    }

    private int calculateCurrentDrillTubeDepth() {
        boolean hasTubes = false;
        for (int y = this.field_11867.method_10264() - 1; y >= this.field_11863.method_31607(); --y) {
            if (!this.isDrillTube(this.field_11863.method_8320(new class_2338(this.field_11867.method_10263(), y, this.field_11867.method_10260())))) {
                return y + 1;
            }
            hasTubes = true;
        }
        return hasTubes ? this.field_11863.method_31607() : this.field_11867.method_10264();
    }

    private boolean isDrillTube(class_2680 blockState) {
        return blockState.method_26204() instanceof BlockDrillTube;
    }
}

